/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzLX;
import com.aspose.words.internal.zzXMU;

public abstract class SaveOptions {
    private boolean zz18;
    boolean zzZEZ = false;
    boolean zzYEQ = true;
    private IDocumentSavingCallback zzYaA;
    private boolean zzXnr = true;
    private boolean zzXva = false;
    private boolean zzWdr;
    private boolean zzYnv = true;
    private boolean zzWDp;
    private String zzVWN;
    private boolean zzXex;
    private boolean zzYNp = false;
    private int zzYE6 = 1;
    private int zzYXn = 1;
    private int zzR0 = 0;
    private String zzlH = "";
    private boolean zzZZK = true;
    private boolean zzQM = true;
    private boolean zzY4a;
    private boolean zzXU8;
    private int zzXvZ = 0;
    private boolean zzXDF = true;
    private boolean zzpD = false;

    protected SaveOptions() {
    }

    final boolean zzZIp() {
        return this.zzWdr;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzXgh() {
        return false;
    }

    boolean zzTO() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzYnv;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzYnv = value;
    }

    public String getTempFolder() {
        return this.zzVWN;
    }

    public void setTempFolder(String value) {
        this.zzVWN = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWDp;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWDp = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXex;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXex = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYNp;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYNp = value;
    }

    @Deprecated
    public boolean getUpdateSdtContent() {
        return this.zzZEZ;
    }

    @Deprecated
    public void setUpdateSdtContent(boolean value) {
        this.zzZEZ = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYE6;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYE6 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzR0;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzR0 = value;
    }

    public int getImlRenderingMode() {
        return this.zzYXn;
    }

    public void setImlRenderingMode(int value) {
        this.zzYXn = value;
    }

    public String getDefaultTemplate() {
        return this.zzlH;
    }

    public void setDefaultTemplate(String value) {
        this.zzlH = value;
    }

    public boolean getUpdateFields() {
        return this.zzZZK;
    }

    public void setUpdateFields(boolean value) {
        this.zzZZK = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzY4a;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzY4a = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzXU8;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzXU8 = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzpD;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzpD = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXva;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXva = value;
    }

    final boolean zzYLd() {
        return this.zzQM;
    }

    final boolean zzWAe() {
        return this.zzXDF;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzXk8(zzXMU.zzWTj(zzLX.zzXqg(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzXvZ;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzXvZ = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzYaA;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzYaA = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zz18;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zz18 = value;
    }

    final boolean zzWL8() {
        return this.zzXnr;
    }
}

