/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzB1;
import com.aspose.words.internal.zzXFP;
import com.aspose.words.zzOl;
import com.aspose.words.zzWfU;
import com.aspose.words.zzXRM;

public final class Section
extends CompositeNode<Node>
implements zzWfU {
    private zzXRM zzM2;
    private PageSetup zzY5B;
    private HeaderFooterCollection zzYa9;

    public Section(DocumentBase doc) {
        this(doc, new zzXRM());
    }

    Section(DocumentBase doc, zzXRM sectPr) {
        super(doc);
        this.zzM2 = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzYa9 == null) {
            this.zzYa9 = new HeaderFooterCollection(this);
        }
        return this.zzYa9;
    }

    public final PageSetup getPageSetup() {
        if (this.zzY5B == null) {
            Section section = this;
            this.zzY5B = new PageSetup(section, section.getDocument().zzY1G(), this.getDocument().getStyles(), new zzXQW(this));
        }
        return this.zzY5B;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzW5T();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzZby(!value);
    }

    final zzXRM zzZqO() {
        return this.zzM2;
    }

    final void zzYZ8(zzXRM zzXRM2) {
        this.zzM2 = zzXRM2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXQW(boolean bl, zzOl zzOl2) {
        zzXRM zzXRM2;
        Section section = (Section)super.zzXQW(bl, zzOl2);
        zzXRM zzXRM3 = this.zzM2;
        section.zzM2 = zzXRM2 = (zzXRM)zzXRM3.zzX81();
        section.zzY5B = null;
        section.zzYa9 = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXQW(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzO1(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zz5u(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zz5u(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzY04(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzXI1(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzY04(n) == null;
            }
        }
        return false;
    }

    final void zzYZ8(Shape shape, boolean bl) throws Exception {
        this.zzXQW(shape, 4, bl);
        this.zzXQW(shape, 0, bl);
        this.zzXQW(shape, 1, bl);
    }

    private void zzXQW(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzYqM());
        shape2.setName(zzB1.zzO1("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzWZe() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzqs()) {
                if (!shape.zzWKX()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zz5u(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzO1(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzM2.zzVZH(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzY1G().zzZkm.zzW1C(key);
        }
        return zzXRM.zzZBU(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzM2.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzY1G().zzZkm.zzZXO(key, value);
            return;
        }
        this.zzM2.zzZXO(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzM2.clear();
    }

    final boolean zzVm() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzWgG() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzXQW
    implements zzWfU {
        private Section zzWeO;

        zzXQW(Section section) {
            this.zzWeO = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzYmi().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzYmi().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzYmi().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzWfU zzYmi() {
            Document document = zzXFP.zzXQW((Object)this.zzWeO.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWeO;
        }
    }
}

