/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzB1;
import com.aspose.words.internal.zzWVg;
import com.aspose.words.internal.zzWsB;
import com.aspose.words.internal.zzXFP;
import com.aspose.words.internal.zzXes;
import com.aspose.words.internal.zzzx;
import com.aspose.words.zzYvM;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzNO;
    private zzYvM zzYNl;

    Watermark(Document doc, zzYvM watermarkProvider) {
        this.zzNO = doc;
        this.zzYNl = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzDG(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXQW(text, textWatermarkOptions, this.zzNO);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzXFP.zzO1((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzNO, 75);
        shape.getImageData().setImage(image);
        this.zzXQW(shape, options, this.zzNO);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzXFP.zzO1((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzNO, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXQW(shape, options, this.zzNO);
    }

    public final int getType() {
        Shape shape = this.zzYNl.get();
        if (shape == null) {
            return 2;
        }
        shape.zzWKX();
        if (shape.zzXua()) {
            return 0;
        }
        if (shape.zzWgc()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzYNl.add(shape);
    }

    public final void remove() {
        this.zzYNl.remove();
    }

    private static void zzDG(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzXes.zzZPV(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzXFP.zzXQW(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXQW(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzO1(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzwK(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzO1(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzbP() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzYFR()) / d2) > (double)(f = pageSetup.zzXAs())) {
            d = (double)f / d3;
        }
        shape.zzWiz(zzWVg.zzYZ8(d2 * d, 2, 1));
        shape.zzY4o(zzWVg.zzYZ8(d3 * d, 2, 1));
    }

    private Shape zzXQW(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXQW(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzwK(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXQW(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzYVj() ? 1.0f : textWatermarkOptions.getFontSize();
        zzzx zzzx2 = document.zzYvs().zzYZ8(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzzx2.zzYlo(shape.getTextPath().getText());
        if (textWatermarkOptions.zzYVj()) {
            l = Watermark.zzXQW(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzWiz(zzWVg.zzYZ8(Float.intBitsToFloat(n), 2, 1));
        shape.zzY4o(zzWVg.zzYZ8(zzWsB.zzYyH(l), 2, 1));
    }

    private static long zzXQW(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzYFR();
        float f2 = pageSetup.zzXAs();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzWsB.zzYyH(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzWsB.zzXab(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzWsB.zzYyH(l) >= Float.intBitsToFloat(n)) {
            return zzWsB.zzXab(f2 / f3, f2);
        }
        float f6 = f;
        return zzWsB.zzXab(f6, f6 * f3);
    }

    private static void zzwK(Shape shape, String string) {
        shape.setName(zzB1.zzO1("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

