/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzWkG;
import com.aspose.words.internal.zzX3X;
import com.aspose.words.internal.zzXJF;
import com.aspose.words.internal.zzXQp;
import com.aspose.words.internal.zzXoy;
import com.aspose.words.internal.zzYCg;
import com.aspose.words.internal.zzYNb;
import com.aspose.words.internal.zzYUW;
import com.aspose.words.internal.zzZPk;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzQh
extends CertPathBuilderSpi {
    private final zzXQp zzVRw;
    private zzXoy zzWX7;

    zzQh(zzXQp zzXQp2) {
        this.zzVRw = zzXQp2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzYUW pkixParams;
        if (params instanceof zzYUW) {
            pkixParams = (zzYUW)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzYUW.zzXQW((PKIXBuilderParameters)params).zzY9V();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzYUW.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzYCg zzYCg2 = pkixParams.zzYsG().zzd3();
        try {
            collection = zzZPk.zzXQW(zzYCg2, pkixParams.zzYsG().zzZSf());
            collection.addAll(zzZPk.zzXQW(zzYCg2, pkixParams.zzYsG().zzYls()));
        }
        catch (zzXoy zzXoy2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzXoy2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzXQW(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzWX7 != null) {
            throw new CertPathBuilderException(this.zzWX7.getMessage(), this.zzWX7.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzXQW(X509Certificate x509Certificate, zzYUW zzYUW2, List list) throws CertPathBuilderException {
        zzXJF zzXJF2;
        zzYNb zzYNb2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzYUW2.zzXam().contains(x509Certificate)) {
            return null;
        }
        if (zzYUW2.zzXyR() != -1 && list.size() - 1 > zzYUW2.zzXyR()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzYNb2 = new zzYNb(this.zzVRw);
            zzXJF2 = new zzXJF(this.zzVRw);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZPk.zzXQW(x509Certificate, zzYUW2.zzYsG().zzZO3(), zzYUW2.zzYsG().zzWGI()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzYNb2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzXoy("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzXJF2.engineValidate(certPath, zzYUW2);
                }
                catch (Exception exception) {
                    throw new zzXoy("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzX3X> arrayList = new ArrayList<zzX3X>();
            arrayList.addAll(zzYUW2.zzYsG().zzZSf());
            try {
                arrayList.addAll(zzZPk.zzXQW(x509Certificate.getExtensionValue(zzWkG.zzZ4r.getId()), zzYUW2.zzYsG().zzgW()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzXoy("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZPk.zzXQW(x509Certificate, zzYUW2.zzYsG().zzYls(), arrayList));
            }
            catch (zzXoy zzXoy2) {
                throw new zzXoy("Cannot find issuer certificate for certificate in certification path.", zzXoy2);
            }
            if (hashSet.isEmpty()) {
                throw new zzXoy("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzXQW(x509Certificate2, zzYUW2, list);
            }
        }
        catch (zzXoy zzXoy3) {
            this.zzWX7 = zzXoy3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

