/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzHj;
import com.aspose.words.internal.zzVR7;
import com.aspose.words.internal.zzWG7;
import com.aspose.words.internal.zzWIq;
import com.aspose.words.internal.zzWe;
import com.aspose.words.internal.zzWh7;
import com.aspose.words.internal.zzWkG;
import com.aspose.words.internal.zzWon;
import com.aspose.words.internal.zzWu;
import com.aspose.words.internal.zzXZW;
import com.aspose.words.internal.zzXgD;
import com.aspose.words.internal.zzY6t;
import com.aspose.words.internal.zzYHC;
import com.aspose.words.internal.zzYY9;
import com.aspose.words.internal.zzYZo;
import com.aspose.words.internal.zzYo8;
import com.aspose.words.internal.zzYyA;
import com.aspose.words.internal.zzZJ1;
import com.aspose.words.internal.zzZNd;
import com.aspose.words.internal.zzpy;
import com.aspose.words.internal.zzrs;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzXzV
extends X509CRL {
    private final Provider zzZPO;
    private final zzWu zzJ6;
    private final String zzXDQ;
    private final byte[] zzYTR;
    private final boolean zzXMX;
    private volatile boolean zzXrk = false;
    private volatile int zzX8;

    static boolean zzYZ8(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(zzWkG.zzZ0q.getId());
            return byArray != null && zzrs.zzY2n(zzXgD.zzXVT(byArray).zzXRi()).zzYkV();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected zzXzV(Provider provider, zzWu zzWu4) throws CRLException {
        this.zzZPO = provider;
        this.zzJ6 = zzWu4;
        try {
            this.zzXDQ = zzpy.zzWQI(zzWu4.zzWBi());
            this.zzYTR = (byte[])(zzWu4.zzWBi().zzWnQ() != null ? zzWu4.zzWBi().zzWnQ().zzL8().getEncoded("DER") : null);
            this.zzXMX = zzXzV.zzYZ8(this);
            return;
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(zzYo8.zzWMW);
        return !set.isEmpty();
    }

    private Set zzVPg(boolean bl) {
        zzVR7 zzVR72;
        if (this.getVersion() == 2 && (zzVR72 = this.zzJ6.zzJ1().zzYZP()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = zzVR72.zzWbn();
            while (enumeration.hasMoreElements()) {
                zzYHC zzYHC2 = (zzYHC)enumeration.nextElement();
                zzWkG zzWkG2 = zzVR72.zzXI1(zzYHC2);
                if (bl != zzWkG2.isCritical()) continue;
                hashSet.add(zzYHC2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public final Set getCriticalExtensionOIDs() {
        return this.zzVPg(true);
    }

    public final Set getNonCriticalExtensionOIDs() {
        return this.zzVPg(false);
    }

    @Override
    public final byte[] getExtensionValue(String oid) {
        zzWkG zzWkG2;
        zzVR7 zzVR72 = this.zzJ6.zzJ1().zzYZP();
        if (zzVR72 != null && (zzWkG2 = zzVR72.zzXI1(new zzYHC(oid))) != null) {
            try {
                return zzWkG2.zzbG().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public final byte[] getEncoded() throws CRLException {
        try {
            return this.zzJ6.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.zzZPO);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.zzXQW(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = sigProvider != null ? Signature.getInstance(this.getSigAlgName(), sigProvider) : Signature.getInstance(this.getSigAlgName());
        this.zzXQW(key, signature);
    }

    private void zzXQW(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.zzJ6.zzWBi().equals(this.zzJ6.zzJ1().zzWKP())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.zzYTR != null) {
            try {
                zzpy.zzXQW(signature, zzYyA.zzVXB(this.zzYTR));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public final int getVersion() {
        return this.zzJ6.zzWuk();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.zzJ6.zzX2P().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public final Date getThisUpdate() {
        return this.zzJ6.zzYjn().zzYR7();
    }

    @Override
    public final Date getNextUpdate() {
        if (this.zzJ6.zzmv() != null) {
            return this.zzJ6.zzmv().zzYR7();
        }
        return null;
    }

    private Set zzYhZ() {
        HashSet<zzHj> hashSet = new HashSet<zzHj>();
        Enumeration enumeration = this.zzJ6.zzZ12();
        zzWon zzWon2 = null;
        while (enumeration.hasMoreElements()) {
            zzWkG zzWkG2;
            zzWh7.zzXQW zzXQW2 = (zzWh7.zzXQW)enumeration.nextElement();
            zzHj zzHj2 = new zzHj(zzXQW2, this.zzXMX, zzWon2);
            hashSet.add(zzHj2);
            if (!this.zzXMX || !zzXQW2.hasExtensions() || (zzWkG2 = zzXQW2.zzYZP().zzXI1(zzWkG.zzNx)) == null) continue;
            zzWon2 = zzWon.zzYpe(zzY6t.zzWLj(zzWkG2.zzVZe()).zz8B()[0].zzXH6());
        }
        return hashSet;
    }

    @Override
    public final X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        Enumeration enumeration = this.zzJ6.zzZ12();
        zzWon zzWon2 = null;
        while (enumeration.hasMoreElements()) {
            zzWkG zzWkG2;
            zzWh7.zzXQW zzXQW2 = (zzWh7.zzXQW)enumeration.nextElement();
            if (serialNumber.equals(zzXQW2.zzYI6().zzYx2())) {
                return new zzHj(zzXQW2, this.zzXMX, zzWon2);
            }
            if (!this.zzXMX || !zzXQW2.hasExtensions() || (zzWkG2 = zzXQW2.zzYZP().zzXI1(zzWkG.zzNx)) == null) continue;
            zzWon2 = zzWon.zzYpe(zzY6t.zzWLj(zzWkG2.zzVZe()).zz8B()[0].zzXH6());
        }
        return null;
    }

    public final Set getRevokedCertificates() {
        Set set = this.zzYhZ();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public final byte[] getTBSCertList() throws CRLException {
        try {
            return this.zzJ6.zzJ1().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final byte[] getSignature() {
        return this.zzJ6.zzZVf().zzXRi();
    }

    @Override
    public final String getSigAlgName() {
        return this.zzXDQ;
    }

    @Override
    public final String getSigAlgOID() {
        return this.zzJ6.zzWBi().zzXK0().getId();
    }

    @Override
    public final byte[] getSigAlgParams() {
        if (this.zzYTR != null) {
            byte[] byArray = new byte[this.zzYTR.length];
            System.arraycopy(this.zzYTR, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    @Override
    public final String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzXZW.zzZuh();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(zzXZW.zzXFv(zzWIq.zzYsi(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(zzXZW.zzXFv(zzWIq.zzYsi(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(zzXZW.zzXFv(zzWIq.zzYsi(byArray, i, byArray.length - i))).append(string);
        }
        zzVR7 zzVR72 = this.zzJ6.zzJ1().zzYZP();
        if (zzVR72 != null) {
            object2 = zzVR72.zzWbn();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (zzYHC)object2.nextElement();
                zzWkG zzWkG2 = zzVR72.zzXI1((zzYHC)object);
                if (zzWkG2.zzbG() != null) {
                    byte[] byArray2 = zzWkG2.zzbG().zzXRi();
                    stringBuffer.append("                       critical(").append(zzWkG2.isCritical()).append(") ");
                    try {
                        zzYyA zzYyA2 = zzYyA.zzVXB(byArray2);
                        if (((zzYyA)object).equals(zzWkG.zzZWF)) {
                            stringBuffer.append(new zzYZo(zzZJ1.zzZjX(zzYyA2).zzZeE())).append(string);
                            continue;
                        }
                        if (((zzYyA)object).equals(zzWkG.zzWeg)) {
                            stringBuffer.append("Base CRL: " + new zzYZo(zzZJ1.zzZjX(zzYyA2).zzZeE())).append(string);
                            continue;
                        }
                        if (((zzYyA)object).equals(zzWkG.zzZ0q)) {
                            stringBuffer.append(zzrs.zzY2n(zzYyA2)).append(string);
                            continue;
                        }
                        if (((zzYyA)object).equals(zzWkG.zzq7)) {
                            stringBuffer.append(zzYY9.zzW9V(zzYyA2)).append(string);
                            continue;
                        }
                        if (((zzYyA)object).equals(zzWkG.zzXC3)) {
                            stringBuffer.append(zzYY9.zzW9V(zzYyA2)).append(string);
                            continue;
                        }
                        stringBuffer.append(((zzYHC)object).getId());
                        stringBuffer.append(" value = ").append(zzZNd.zzva(zzYyA2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((zzYHC)object).getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.zzJ6.zzZ12();
        zzWon zzWon2 = this.zzJ6.zzX2P();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)cert).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                zzWG7 zzWG72;
                zzWh7.zzXQW zzXQW2 = zzWh7.zzXQW.zzYMz(enumeration.nextElement());
                if (this.zzXMX && zzXQW2.hasExtensions() && (zzWG72 = zzXQW2.zzYZP().zzXI1(zzWkG.zzNx)) != null) {
                    zzWon2 = zzWon.zzYpe(zzY6t.zzWLj(zzWG72.zzVZe()).zz8B()[0].zzXH6());
                }
                if (!zzXQW2.zzYI6().zzYx2().equals(bigInteger)) continue;
                if (cert instanceof X509Certificate) {
                    zzWG72 = zzWon.zzYpe(((X509Certificate)cert).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        zzWG72 = zzWe.zzZwb(cert.getEncoded()).zzX2P();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return zzWon2.equals(zzWG72);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X509CRL)) {
            return false;
        }
        if (other instanceof zzXzV) {
            boolean bl;
            zzXzV zzXzV2 = (zzXzV)other;
            if (this.zzXrk && (bl = zzXzV2.zzXrk) && zzXzV2.zzX8 != this.zzX8) {
                return false;
            }
            return this.zzJ6.equals(zzXzV2.zzJ6);
        }
        return super.equals(other);
    }

    @Override
    public final int hashCode() {
        if (!this.zzXrk) {
            this.zzX8 = super.hashCode();
            this.zzXrk = true;
        }
        return this.zzX8;
    }
}

