/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXpP;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzO1;
import com.aspose.words.net.System.Data.zzYZ8;
import com.aspose.words.net.System.Data.zzZFG;
import com.aspose.words.net.System.Data.zzZzF;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXmJ;
    private final DataColumnCollection zzXtk;
    private final ConstraintCollection zzYs;
    private final zzZFG zzYx6;
    private ResultSet zzZCJ;
    private String zzZ48;
    private DataSet zzY30;
    private String zzX6n;
    private UniqueConstraint zzYY5;
    private boolean zzZM3;
    private final List<DataTableEventListener> zzWaz;
    private final Set<DataRow> zzeh;
    private DataRelationCollection zzYbR;

    public DataTable() {
        this.zzXmJ = new DataRowCollection(this);
        this.zzXtk = new DataColumnCollection(this);
        this.zzYs = new ConstraintCollection(this);
        this.zzYx6 = new zzZFG(this);
        this.zzX6n = "";
        this.zzZM3 = true;
        this.zzWaz = new ArrayList<DataTableEventListener>();
        this.zzeh = new HashSet<DataRow>();
        this.zzYbR = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzXmJ = new DataRowCollection(this);
        this.zzXtk = new DataColumnCollection(this);
        this.zzYs = new ConstraintCollection(this);
        this.zzYx6 = new zzZFG(this);
        this.zzX6n = "";
        this.zzZM3 = true;
        this.zzWaz = new ArrayList<DataTableEventListener>();
        this.zzeh = new HashSet<DataRow>();
        this.zzYbR = new DataRelationCollection();
        this.zzZ48 = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzO1.zzXQW(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzXmJ = new DataRowCollection(this);
        this.zzXtk = new DataColumnCollection(this);
        this.zzYs = new ConstraintCollection(this);
        this.zzYx6 = new zzZFG(this);
        this.zzX6n = "";
        this.zzZM3 = true;
        this.zzWaz = new ArrayList<DataTableEventListener>();
        this.zzeh = new HashSet<DataRow>();
        this.zzYbR = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzZCJ = resultSet;
        this.zzZ48 = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzZCJ != null) {
            if (this.zzZCJ.getStatement() != null) {
                this.zzZCJ.getStatement().getConnection().close();
            }
            this.zzZCJ = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZ48;
    }

    public void setTableName(String tableName) {
        this.zzZ48 = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXtk.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXtk.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzZCJ;
    }

    public DataSet getDataSet() {
        return this.zzY30;
    }

    final void zz5u(DataSet dataSet) {
        this.zzY30 = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzY30.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzYbR.add(dataRelation);
        }
        return this.zzYbR;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzY30.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzXmJ;
    }

    public DataColumnCollection getColumns() {
        return this.zzXtk;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzYs;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYY5 == null) {
            return new DataColumn[0];
        }
        return this.zzYY5.getColumns();
    }

    final void zzZFG(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYY5 != null) {
                this.zzYY5.zzZeM(false);
                this.getConstraints().remove(this.zzYY5);
                this.zzYY5 = null;
            }
            return;
        }
        if (this.zzYY5 != null && DataColumn.areColumnSetsTheSame(value, this.zzYY5.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXQW(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYY5 != null) {
            this.zzYY5.zzZeM(false);
            this.getConstraints().remove(this.zzYY5);
            this.zzYY5 = null;
        }
        UniqueConstraint.zzXQW(this.getConstraints(), uniqueConstraint);
        this.zzYY5 = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzX6n;
    }

    public void setNamespace(String namespace) {
        this.zzX6n = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZM3;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZM3 = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzeh.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzO1.zzXQW(this.getResultSet(), this);
            zzO1.zzO1(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXpP.zz5u(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzO1.zzwK(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzWaz.contains(listener)) {
            this.zzWaz.add(listener);
        }
    }

    public void removeEventListener(zzYZ8 listener) {
        if (this.zzWaz.contains(listener)) {
            this.zzWaz.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzWaz.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzeh.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWaz) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzeh.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWaz) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzeh.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWaz) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWaz) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWaz) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzZzF zzXQW(zzO1[] zzO1Array) {
        DataColumn[] dataColumnArray = new DataColumn[zzO1Array.length];
        for (int i = 0; i < zzO1Array.length; ++i) {
            dataColumnArray[i] = zzO1Array[i].zzWEV();
        }
        DataTable dataTable = this;
        zzZzF zzZzF2 = dataTable.zzYx6.zz5u(dataColumnArray);
        if (zzZzF2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzZzF2;
    }

    final zzZFG zzZK8() {
        return this.zzYx6;
    }

    final Set<DataRow> zzWfD() {
        return this.zzeh;
    }
}

