/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzWFr;
import com.aspose.words.internal.zzXv1;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXJ6;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzXJ6 zzZTM;

    BorderCollection(zzXJ6 parent) {
        this.zzZTM = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzWFr.zzWY5(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzWSP().equals(brColl.zzWSP()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzZTM.getPossibleBorderKeys().zzXSa(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzZTM.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzZTM, borderKey);
            this.zzZTM.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzZTM.getPossibleBorderKeys().zzWWk().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzZTM.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzZTM.getPossibleBorderKeys().zzWWk().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXVW(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzZTM.getPossibleBorderKeys().zzWWk().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXVW(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzWSP().zzYFK();
    }

    public final void setColor(Color value) throws Exception {
        this.zztL(zzXv1.zzXSa(value));
    }

    private zzXv1 zzWSP() throws Exception {
        return this.get(0).zzWSP();
    }

    private void zztL(zzXv1 zzXv12) throws Exception {
        Iterator iterator = this.zzZTM.getPossibleBorderKeys().zzWWk().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXVW(n)) continue;
            this.getByBorderType(n).zztL(zzXv12);
        }
    }

    final boolean zzX07(int n) {
        return this.zzZTM.getPossibleBorderKeys().zzXTq(n);
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzZTM.getPossibleBorderKeys().zzWWk().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXVW(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzZTM.getPossibleBorderKeys().zzWWk().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXVW(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzXSa(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzXVW(int n) {
        return n != 6 && n != 7;
    }

    static final class zzXSa
    implements Iterator<Border> {
        private BorderCollection zzXT5;
        private int zzmo;

        zzXSa(BorderCollection borderCollection) {
            this.zzXT5 = borderCollection;
            this.zzmo = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzmo >= this.zzXT5.getCount() - 1) {
                return false;
            }
            ++this.zzmo;
            return true;
        }

        private Border zzuD() {
            try {
                return this.zzXT5.get(this.zzmo);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzuD();
        }
    }
}

