/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzWFr;
import com.aspose.words.zz7X;
import com.aspose.words.zzAn;
import com.aspose.words.zzWHd;
import com.aspose.words.zzWU7;
import com.aspose.words.zzWbs;
import com.aspose.words.zzXnc;
import com.aspose.words.zzXzL;
import com.aspose.words.zzYuh;
import com.aspose.words.zzZcP;
import com.aspose.words.zzot;

public class Cell
extends CompositeNode<Node>
implements zzWHd,
zzXnc {
    private zzAn zzZYc;
    private CellFormat zzVY1;
    private ParagraphCollection zzYJ8;
    private TableCollection zzZdb;

    public Cell(DocumentBase doc) {
        this(doc, new zzAn());
    }

    Cell(DocumentBase doc, zzAn cellPr) {
        super(doc);
        this.zzZYc = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzoI();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzXrq();
    }

    public Row getParentRow() {
        return (Row)this.zzYFl();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzXxQ() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzZ6J(this, true);
        }
        return -1;
    }

    final int zzyI() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzyI();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzVY1 == null) {
            this.zzVY1 = new CellFormat(this);
        }
        return this.zzVY1;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzYJ8 == null) {
            this.zzYJ8 = new ParagraphCollection(this);
        }
        return this.zzYJ8;
    }

    public TableCollection getTables() {
        if (this.zzZdb == null) {
            this.zzZdb = new TableCollection(this);
        }
        return this.zzZdb;
    }

    final zzAn zzZLs() {
        return this.zzZYc;
    }

    final void zzXSa(zzAn zzAn2) {
        this.zzZYc = zzAn2;
    }

    @Override
    final Node zzXSa(boolean bl, zzXzL zzXzL2) {
        zzAn zzAn2;
        Cell cell = (Cell)super.zzXSa(bl, zzXzL2);
        zzAn zzAn3 = this.zzZYc;
        cell.zzZYc = zzAn2 = (zzAn)zzAn3.zzYjq();
        cell.zzVY1 = null;
        cell.zzYJ8 = null;
        cell.zzZdb = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXSa(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzZd9(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzZcP.zzYE0(this);
    }

    @Override
    final boolean zzZZU(Node node) {
        return zzYuh.zzZ1O(node);
    }

    final int zzYY9() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZYc.zzXUO(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzZYc.zzXUO(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzot zzot2 = zzWFr.zzXSa(object, zzot.class);
        if (zzot2 != null && zzot2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzXR4(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzAn.zzVUx(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzZYc.zzX9S(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZYc.clear();
    }

    private Object zzXR4(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzWFr.zzXSa((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzXSa(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz7X getInsertRevision() {
        Cell cell = this;
        return cell.zzZYc.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zz7X value) {
        zzXnc zzXnc2 = this;
        zz7X zz7X2 = value;
        zzXnc2 = zzXnc2.zzZYc;
        ((zzWU7)((Object)zzXnc2)).zzX9S(14, zz7X2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz7X getDeleteRevision() {
        Cell cell = this;
        return cell.zzZYc.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zz7X value) {
        zzXnc zzXnc2 = this;
        zz7X zz7X2 = value;
        zzXnc2 = zzXnc2.zzZYc;
        ((zzWU7)((Object)zzXnc2)).zzX9S(12, zz7X2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWbs getMoveFromRevision() {
        Cell cell = this;
        return cell.zzZYc.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzWbs value) {
        zzXnc zzXnc2 = this;
        zzWbs zzWbs2 = value;
        zzXnc2 = zzXnc2.zzZYc;
        ((zzWU7)((Object)zzXnc2)).zzX9S(13, zzWbs2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWbs getMoveToRevision() {
        Cell cell = this;
        return cell.zzZYc.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzWbs value) {
        zzXnc zzXnc2 = this;
        zzWbs zzWbs2 = value;
        zzXnc2 = zzXnc2.zzZYc;
        ((zzWU7)((Object)zzXnc2)).zzX9S(15, zzWbs2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzZYc.remove(13);
        cell = this;
        cell.zzZYc.remove(15);
    }

    final zzAn zzXs6(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzAn zzAn2 = new zzAn();
        this.zzXSa(3120, zzAn2);
        this.zzXSa(3140, zzAn2);
        this.zzXSa(3110, zzAn2);
        this.zzXSa(3130, zzAn2);
        this.zzXSa(3090, zzAn2);
        this.zzXSa(3100, zzAn2);
        this.zzXSa(3070, zzAn2);
        this.zzXSa(3080, zzAn2);
        if (bl && (tableStyle = zzWFr.zzXSa((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzZd9(this, zzAn2);
        }
        this.zzZYc.zzZd9((zzWU7)zzAn2);
        return zzAn2;
    }

    private void zzXSa(int n, zzAn zzAn2) {
        zzAn2.zzX9S(n, this.fetchInheritedCellAttr(n));
    }
}

