/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzWWh;
import com.aspose.words.zzBO;
import com.aspose.words.zzL0;
import com.aspose.words.zzSE;
import com.aspose.words.zzW27;
import com.aspose.words.zzWfH;
import com.aspose.words.zzWkn;
import com.aspose.words.zzWwZ;
import com.aspose.words.zzX8h;
import com.aspose.words.zzXVD;
import com.aspose.words.zzZC6;
import com.aspose.words.zzZYv;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzBO zzWYD;

    ChartSeriesCollection(zzBO chartSpace) {
        this.zzWYD = chartSpace;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXSQ().zzZVb().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXSQ().zzZVb().iterator();
    }

    public void removeAt(int index) {
        this.zzXSQ().zzcY(index);
    }

    public void clear() {
        this.zzXSQ().zzVQn();
        for (zzWwZ zzWwZ2 : this.zzWYD.zzK1()) {
            zzWwZ2.zzW1g(false);
        }
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXSa(chartSeriesCollection.zzXSQ().zzZTM(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXSa(chartSeriesCollection.zzXSQ().zzZTM(), seriesName, xValues, yValues);
    }

    private ChartSeries zzXSa(String string, zzWWh[] zzWWhArray, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXSa(chartSeriesCollection.zzXSQ().zzZTM(), string, zzWWhArray, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXSa(seriesName, zzWWh.zzXSa(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXSa(chartSeriesCollection.zzXSQ().zzZTM(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzXSa(zzWwZ zzWwZ2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXSa(zzWwZ2, string, dArray);
        chartSeries.zzXEs().zzZxs(ChartSeriesCollection.zzZNE(stringArray));
        return chartSeries;
    }

    final ChartSeries zzXSa(zzWwZ zzWwZ2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXSa(zzWwZ2, string, dArray2);
        chartSeries.zzXEs().zzZxs(ChartSeriesCollection.zzZj(dArray));
        return chartSeries;
    }

    private ChartSeries zzXSa(zzWwZ zzWwZ2, String string, zzWWh[] zzWWhArray, double[] dArray) {
        if (zzWWhArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzWWhArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzWWhArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXSa(zzWwZ2, string, dArray);
        chartSeries.zzXEs().zzZxs(ChartSeriesCollection.zzXSa(zzWWhArray));
        if (!zzWwZ2.zzYAC()) {
            zzWwZ2.zzW1g(true);
        }
        return chartSeries;
    }

    final ChartSeries zzXSa(zzWwZ zzWwZ2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzWwZ2.zzWM() != 15) {
            zzWwZ2.zzYK7(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXSa(zzWwZ2, string, dArray2);
        chartSeries.zzYvX().zzXDT().zzWY5(3, chartSeries.zzWoa().zzl5());
        chartSeries.zzXEs().zzZxs(ChartSeriesCollection.zzZj(dArray));
        if (dArray3 != null) {
            chartSeries.zzYxx().zzZxs(ChartSeriesCollection.zzZj(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzXSa(zzWwZ zzWwZ2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzWwZ2);
        chartSeries.setName(string);
        ChartSeriesCollection.zzWKo(chartSeries);
        chartSeries.zzYp7().zzZxs(ChartSeriesCollection.zzZj(dArray));
        this.zzWYD.zzAo();
        this.zzXSQ().zzWWo(chartSeries);
        return chartSeries;
    }

    private static void zzWKo(ChartSeries chartSeries) {
        chartSeries.zzYvX().zzXDT().zzWY5(5, new zzWkn());
        if (ChartDataPointCollection.zz41(chartSeries.zzWoa().zzWM())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzWoa().zzWM()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXSa(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXSa(chartSeries, 5);
                ChartSeriesCollection.zzAi(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXSa(chartSeries, 1);
                ChartSeriesCollection.zzAi(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzX9S(chartSeries);
            }
        }
    }

    private static void zzX9S(ChartSeries chartSeries) {
        zzWkn zzWkn2 = new zzWkn();
        zzWkn2.setOutline(new zzXVD());
        zzW27 zzW272 = new zzW27();
        zzW272.zzXc6(1);
        zzWkn2.getOutline().setFill(new zzX8h(zzW272));
        zzWkn2.getOutline().zzY53(19050.0);
        chartSeries.zzYvX().zzXDT().zzWY5(5, zzWkn2);
    }

    private static void zzAi(ChartSeries chartSeries) {
        zzWkn zzWkn2 = new zzWkn();
        zzWkn2.setOutline(new zzXVD());
        zzWkn2.getOutline().setFill(new zzL0());
        zzWkn2.getOutline().setEndCap(0);
        zzWkn2.getOutline().zzY53(19050.0);
        chartSeries.zzYvX().zzXDT().zzWY5(5, zzWkn2);
    }

    private static void zzXSa(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzWoa());
        chartMarker.zzLc().zzWY5(0, n);
        chartSeries.zzYvX().zzXDT().zzWY5(4, chartMarker);
    }

    private static zzZC6 zzZj(double[] dArray) {
        int n = 0;
        zzZC6 zzZC62 = new zzZC6(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzZC62.zzZvz(new zzZYv(n, d, "General"));
            }
            ++n;
        }
        zzZC62.zzY46(dArray.length);
        return zzZC62;
    }

    private static zzZC6 zzXSa(zzWWh[] zzWWhArray) {
        int n = 0;
        zzZC6 zzZC62 = new zzZC6(2);
        zzWWh[] zzWWhArray2 = zzWWhArray;
        int n2 = zzWWhArray.length;
        for (int i = 0; i < n2; ++i) {
            zzWWh zzWWh2 = zzWWhArray2[i];
            zzZC62.zzZvz(new zzZYv(n++, zzWWh2.zzXIu(), "m/d/yyyy"));
        }
        zzZC62.zzY46(zzWWhArray.length);
        return zzZC62;
    }

    private static zzZC6 zzZNE(String[] stringArray) {
        int n = 0;
        zzZC6 zzZC62 = new zzZC6(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzZC62.zzZvz(new zzWfH(n++, string));
        }
        zzZC62.zzY46(stringArray.length);
        return zzZC62;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXSQ().zzZVb().size();
    }

    private zzSE zzXSQ() {
        return this.zzWYD.zzXGj().zzXSQ();
    }
}

