/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzRt;
import com.aspose.words.internal.zzW0l;
import com.aspose.words.internal.zzWFr;
import com.aspose.words.internal.zzWYh;
import com.aspose.words.internal.zzWvg;
import com.aspose.words.internal.zzX3g;
import com.aspose.words.internal.zzY09;
import com.aspose.words.internal.zzY5b;
import com.aspose.words.internal.zzYZS;
import com.aspose.words.internal.zzZVp;
import com.aspose.words.internal.zzZu2;
import com.aspose.words.internal.zzdX;
import com.aspose.words.zzAf;
import com.aspose.words.zzY2B;
import com.aspose.words.zzY69;
import com.aspose.words.zzY9z;
import com.aspose.words.zzYEq;
import com.aspose.words.zzYoI;
import com.aspose.words.zzYsB;
import com.aspose.words.zzYxn;
import com.aspose.words.zzZLL;
import com.aspose.words.zzZgz;
import com.aspose.words.zzi;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXSa(zzY09 zzY092, zzY09 zzY093, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzWFr.zzZd9((Object)zzY092, "srcStream");
        zzWFr.zzZd9((Object)zzY093, "dstStream");
        zzWFr.zzZd9((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzZd9(zzY092, zzY093, certificateHolder, signOptions);
        zzY093.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXSa(zzY09.zzZd9(srcStream), (zzY09)zzY09.zzIl(dstStream), certHolder, signOptions);
    }

    private static void zzZd9(zzY09 zzY092, zzY09 zzY093, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzIl(digitalSignature);
        }
        if (zzY69.zz2I(zzY092)) {
            DigitalSignatureUtil.zzXSa(zzY092, zzY093, digitalSignature, true);
            return;
        }
        zzY69 zzY692 = new zzY69();
        zzY09 zzY094 = zzY092;
        zzY69 zzY693 = zzY692;
        FileFormatInfo fileFormatInfo = zzY692.zzZd9(zzY094, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYZS zzYZS2 = new zzYZS(zzY092);
                int n = fileFormatInfo.zzsi() == 1 ? 1 : 2;
                zzZgz.zzXSa(zzYZS2, digitalSignature, n);
                zzY093.zzVP6(0L);
                zzYZS2.zzWWo(zzY093);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXSa(fileFormatInfo.zzHx(), zzY093, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXSa(zzY092, zzY093, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzXSa(zzY092, zzY093, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzWFr.zzIl(srcFileName, "srcFileName");
        zzWFr.zzIl(dstFileName, "dstFileName");
        zzX3g zzX3g2 = zzWFr.zzZd9(srcFileName, 3, 1);
        try {
            zzX3g zzX3g3 = zzWFr.zzZd9(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzXSa((zzY09)zzX3g2, (zzY09)zzX3g3, certHolder, signOptions);
            }
            finally {
                zzX3g3.close();
            }
            return;
        }
        finally {
            zzX3g2.close();
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzY5b zzY5b2 = zzY09.zzIl(dstStream);
        zzY09 zzY092 = zzY09.zzZd9(srcStream);
        DigitalSignatureUtil.zzXSa(zzY092, (zzY09)zzY5b2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        zzX3g zzX3g2 = zzWFr.zzZd9(srcFileName, 3, 1);
        try {
            zzX3g zzX3g3 = zzWFr.zzZd9(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzZ6J(zzX3g2, zzX3g3);
            }
            finally {
                zzX3g3.close();
            }
            return;
        }
        finally {
            zzX3g2.close();
        }
    }

    private static void zzZ6J(zzY09 zzY092, zzY09 zzY093) throws Exception {
        zzY69 zzY692 = new zzY69();
        zzY09 zzY094 = zzY092;
        Object object = zzY692;
        FileFormatInfo fileFormatInfo = zzY692.zzZd9(zzY094, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYZS zzYZS2 = new zzYZS(zzY092);
                zzYZS2.zzWHT().zzYSU("_xmlsignatures");
                zzYZS2.zzWHT().zzYSU("_signatures");
                zzY093.zzYH1(0L);
                zzYZS2.zzWWo(zzY093);
                zzY09 zzY095 = zzY093;
                zzY095.zzVP6(zzY095.zzYqG());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzWYh zzWYh2 = new zzWYh(zzY092);
                zzW0l zzW0l2 = zzWYh2.zzXSa(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzW0l2 != null) {
                    for (zzRt zzRt2 : zzW0l2.zzYyu()) {
                        String string = zzW0l2.zzXSa(zzRt2);
                        zzWYh2.zzY7a().remove(string);
                    }
                    zzWYh2.zzY7a().remove(zzW0l2.getName());
                    zzRt zzRt3 = zzWYh2.zzYyu().zzWz5("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzWYh2.zzYyu().remove(zzRt3.getId());
                    zzWYh2.zzXsC();
                }
                zzY093.zzYH1(0L);
                zzWYh2.zzWWo(zzY093);
                zzY09 zzY096 = zzY093;
                zzY096.zzVP6(zzY096.zzYqG());
                return;
            }
            case 60: 
            case 61: {
                zzYEq zzYEq2 = new zzYEq(zzY092);
                zzYsB zzYsB2 = zzYEq2.zzZik("/META-INF/documentsignatures.xml");
                if (zzYsB2 != null) {
                    zzYEq2.zzVRc().remove(zzYsB2.getName());
                }
                zzY093.zzYH1(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzY094 = zzY093;
                object = zzYEq2;
                ((zzYEq)object).zzXSa(zzY094, string, null);
                zzY09 zzY097 = zzY093;
                zzY097.zzVP6(zzY097.zzYqG());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzZ6J(zzY09.zzZd9(srcStream), zzY09.zzIl(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        zzX3g zzX3g2 = zzWFr.zzZd9(fileName, 3, 1);
        try {
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYlV(zzX3g2);
            return digitalSignatureCollection;
        }
        finally {
            zzX3g2.close();
        }
    }

    private static DigitalSignatureCollection zzYlV(zzY09 zzY092) throws Exception {
        if (zzY69.zz2I(zzY092)) {
            return DigitalSignatureUtil.zzW76(zzY092);
        }
        zzY69 zzY692 = new zzY69();
        zzY09 zzY093 = zzY092;
        zzY69 zzY693 = zzY692;
        FileFormatInfo fileFormatInfo = zzY692.zzZd9(zzY093, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzY092, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYlV(zzY09.zzZd9(stream));
    }

    static zzdX zzXSa(zzYZS zzYZS2, String string) throws Exception {
        zzi zzi2 = new zzi(zzYZS2);
        if (zzi2.zzZ4E()) {
            zzdX zzdX2 = zzi2.zzZjk(string);
            return zzdX2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzZ1w(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzZu2.zzZd9("Unexpected digest algorithm: {0}.", n));
    }

    static String zzWG9(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzZ1w(n);
    }

    private static void zzXSa(zzY09 zzY092, zzY09 zzY093, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzWYh zzWYh2 = new zzWYh(zzY092);
        zzYxn zzYxn2 = bl ? new zzZLL(zzWYh2) : new zzY9z(zzWYh2);
        zzYxn2.zzZd9(digitalSignature);
        zzY093.zzVP6(0L);
        zzWYh2.zzWWo(zzY093);
    }

    private static void zzXSa(zzY09 zzY092, zzY09 zzY093, DigitalSignature digitalSignature) throws Exception {
        zzYEq zzYEq2 = new zzYEq(zzY092);
        zzYoI zzYoI2 = new zzYoI(zzYEq2);
        zzYoI2.zzZd9(digitalSignature);
        zzY093.zzVP6(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzY09 zzY094 = zzY093;
        zzYEq zzYEq3 = zzYEq2;
        zzYEq3.zzXSa(zzY094, string, null);
    }

    private static void zzXSa(zzYZS zzYZS2, zzY09 zzY092, DigitalSignature digitalSignature, String string) throws Exception {
        zzdX zzdX2 = DigitalSignatureUtil.zzXSa(zzYZS2, string);
        zzdX zzdX3 = new zzdX();
        DigitalSignatureUtil.zzXSa((zzY09)zzdX2, (zzY09)zzdX3, digitalSignature, false);
        zzYZS zzYZS3 = zzi.zzZxs(zzdX3, string);
        zzYZS3.zzWWo(zzY092);
    }

    private static DigitalSignatureCollection zzW76(zzY09 zzY092) throws Exception {
        zzY092.zzYH1(0L);
        zzWYh zzWYh2 = new zzWYh(zzY092);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzW0l zzW0l2 = zzWYh2.zzXSa(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzW0l2 != null) {
            for (zzRt zzRt2 : zzW0l2.zzYyu()) {
                String string = zzW0l2.zzXSa(zzRt2);
                zzW0l zzW0l3 = zzWYh2.zzYyg(string);
                zzW0l zzW0l4 = zzWYh2.zzXSa(zzW0l3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzWvg zzWvg2 = zzZVp.zzXy5(zzW0l4.zzZvf().zzW9J());
                zzY2B.zzXSa(zzW0l3.zzY09(), zzWvg2, new zzAf(zzWYh2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

