/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzVQ9;
import com.aspose.words.internal.zzVY4;
import com.aspose.words.internal.zzW8t;
import com.aspose.words.internal.zzWFr;
import com.aspose.words.internal.zzWGq;
import com.aspose.words.internal.zzWVu;
import com.aspose.words.internal.zzWfp;
import com.aspose.words.internal.zzXLq;
import com.aspose.words.internal.zzY09;
import com.aspose.words.internal.zzY3L;
import com.aspose.words.internal.zzYOj;
import com.aspose.words.internal.zzYcQ;
import com.aspose.words.internal.zzYiL;
import com.aspose.words.internal.zzYnW;
import com.aspose.words.internal.zzYz5;
import com.aspose.words.internal.zzZ2W;
import com.aspose.words.internal.zzZu2;
import com.aspose.words.internal.zzdX;
import com.aspose.words.zz8N;
import com.aspose.words.zzAn;
import com.aspose.words.zzBd;
import com.aspose.words.zzF7;
import com.aspose.words.zzNj;
import com.aspose.words.zzS;
import com.aspose.words.zzVPl;
import com.aspose.words.zzVTt;
import com.aspose.words.zzW7A;
import com.aspose.words.zzWHd;
import com.aspose.words.zzWNe;
import com.aspose.words.zzWQX;
import com.aspose.words.zzWU7;
import com.aspose.words.zzWcL;
import com.aspose.words.zzWnu;
import com.aspose.words.zzX37;
import com.aspose.words.zzX9X;
import com.aspose.words.zzXB3;
import com.aspose.words.zzXB4;
import com.aspose.words.zzXGN;
import com.aspose.words.zzXOE;
import com.aspose.words.zzXSW;
import com.aspose.words.zzXUs;
import com.aspose.words.zzXWS;
import com.aspose.words.zzXil;
import com.aspose.words.zzXn0;
import com.aspose.words.zzXnc;
import com.aspose.words.zzXsX;
import com.aspose.words.zzXu9;
import com.aspose.words.zzXv7;
import com.aspose.words.zzXxJ;
import com.aspose.words.zzY2x;
import com.aspose.words.zzY74;
import com.aspose.words.zzYBd;
import com.aspose.words.zzYSk;
import com.aspose.words.zzYaP;
import com.aspose.words.zzYqH;
import com.aspose.words.zzYuh;
import com.aspose.words.zzZ1x;
import com.aspose.words.zzZQp;
import com.aspose.words.zzZRr;
import com.aspose.words.zzZcP;
import com.aspose.words.zzZjf;
import com.aspose.words.zzbc;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzXOE,
zzXnc,
zzXu9,
zzZ1x {
    private Document zzZzo;
    private Node zzWf;
    private Node zzJB;
    private zzVTt zzBI;
    private Font zztt;
    private zzZ2W<zzVTt> zzYVz;
    private zzZ2W<zzYaP> zzIe;
    private zzZ2W<zzXSa> zzXbv;
    private zzXn0 zzWUi = zzXn0.zzYvd();
    private zzAn zzZYc = new zzAn();
    private zzYaP zzZNU;
    private RowFormat zzWHw;
    private CellFormat zzVY1;
    private ParagraphFormat zzYgT;
    private zzZ2W<zzXxJ> zzZAR;
    private int zzYEf = 0;
    private int zzYIk = -1;
    private int zzZx8;
    private boolean zzIV;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzWKo(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzWKo(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzWKo(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXSa(documentBuilder.getCurrentSection(), zzZcP.zzYGm(headerFooterType), 0, 0);
    }

    private void zzWKo(int n, int n2, int n3, int n4) {
        this.zzZzo.ensureMinimum();
        Section section = (Section)this.zzZzo.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXSa(section, 1, n3, n4);
    }

    private void zzXSa(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZcP.zz6o(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZzo, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZzo));
            }
        }
        this.zzXSa(story, n2, n3);
    }

    private void zzXSa(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXSa((CompositeNode)paragraph2, n3);
    }

    final void zzXSa(Paragraph paragraph, int n) {
        this.zzXSa((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXtr().zzWHz() ? zzVPl.zzXoB(this.zzZzo, fieldName) : zzVPl.zzZZU(this.zzXtr(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXSa(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXSa(field, isAfter, false);
    }

    private boolean zzXSa(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzXWS zzXWS2 = field.getFormat().zzLN();
        Inline inline = zzXWS2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXSa(inline.zzfo(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzYSk.zzXSa(this.zzZzo, bookmarkName) : zzYSk.zzZd9(this.zzZzo, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzW6g() == 6) {
            this.zzXSa(node.zzYFl(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYuh.zzBM(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXSa((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXSa(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzZd9(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzXSa(structuredDocumentTag);
            return;
        }
        this.zzIl(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzVRT(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzXSa((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzW6g() == 6) {
            this.zzWnu(node);
        } else {
            Node node2 = node;
            if (zzYuh.zzWfC(node2.getNodeType())) {
                Paragraph paragraph = zzYuh.zzBM(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzWnu(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzW6g() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzWnu(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzZx8 = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzXC6();
            return;
        }
        if (!this.zzXaa()) {
            this.zzXC6();
        }
    }

    private void zzXSa(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzXaa() {
        Node node = this.zzXtr();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzXtr().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXSa(((StructuredDocumentTag)documentBuilder.zzXtr().getParentNode()).zzYJG(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzXtr(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXSa(inline.zzfo(), true);
            return true;
        }
        return false;
    }

    private void zzXC6() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXSa(documentBuilder.getCurrentParagraph().zzW1l(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzVRT(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZJH() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXtr().zzYrG(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzoI();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXSa((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzWEg(text, false);
    }

    public void writeln(String text) {
        this.zzWEg(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzXtr() != null && this.zzXtr().zzW6g() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzXtr().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzVVZ();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzXsX zzXsX2 = new zzXsX(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzZzo, this.zzY9Q(), this.zzDb());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzZd9(this.zzXtr(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzXsX2.dispose();
        }
        if (this.getDocument().zzY2o()) {
            zzYuh.zzIl((zzWHd)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzVWm());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzXxc() {
        zzVTt zzVTt2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzVVZ();
        Node node = this.zzXtr();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzkb(false);
        } else {
            run2 = run = (Run)node.zzVE(21);
        }
        if (run2 == null && zzWFr.zzWY5(node, paragraph.zzVZw())) {
            run = paragraph.zzVZw();
        }
        if (run != null) {
            cloneable = run.zzfo();
            zzVTt2 = (zzVTt)((zzWU7)cloneable).zzYjq();
        } else {
            cloneable = paragraph.zzW1l();
            zzVTt2 = (zzVTt)((zzWU7)cloneable).zzYjq();
        }
        zzVTt zzVTt3 = zzVTt2;
        Paragraph paragraph2 = new Paragraph(this.zzZzo, this.zzY9Q(), zzVTt3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzXsX zzXsX2 = new zzXsX(this.zzZzo);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzZd9(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzXsX2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXGN.zzXoB(this);
    }

    public void insertBreak(int breakType) {
        this.zzYNc(breakType, true);
    }

    final void zzYNc(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzYYa(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzZAS(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzYfz())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzYYa(bl)) {
                        this.zzZAS(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzYYa(bl)) {
                        this.zz0j(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzYYa(bl)) {
                        this.zz0j(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzYYa(bl)) {
                        this.zz0j(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzYYa(bl)) {
                        this.zz0j(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzYYa(bl)) {
                        this.zz0j(4);
                    }
                    return;
                }
                case 8: {
                    this.zzZAS(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzYcQ.zzWtn(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzZu2.zzZd9("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzVVZ();
        return zzYuh.zzXSa(fieldType, updateField, this.zzDb(), this.zzZ2E(), this.zzGq(), this.zzGq() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzVVZ();
        return zzYuh.zzXSa(fieldCode, this.zzDb(), this.zzZ2E(), this.zzGq(), this.zzGq() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzVVZ();
        return zzYuh.zzXSa(fieldCode, fieldValue, this.zzDb(), this.zzZ2E(), this.zzGq(), this.zzGq() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzWFr.zzZd9((Object)displayText, "displayText");
        zzWFr.zzZd9((Object)urlOrBookmark, "hrefOrBookmark");
        zzWcL zzWcL2 = this.zzZd9(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzWcL2.zzIl(documentBuilder.zznY(88, true));
        return zzYuh.zzXSa(zzWcL2.getStart(), zzWcL2.getSeparator(), zzWcL2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzZpx(70);
        if (zzYcQ.zzWtn(name)) {
            this.startBookmark(name);
        }
        this.zzYZ7(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzXA(70);
        String string = zzYcQ.zzWtn(fieldValue) ? fieldValue : FormField.zzYF6;
        Run run = new Run(this.zzZzo, string, this.zzDb());
        this.insertNode(run);
        Node node = this.zznY(70, true);
        if (zzYcQ.zzWtn(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzY83(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzXSa((CompositeNode)((Paragraph)node.zzYFl()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzZpx(71);
        if (zzYcQ.zzWtn(name)) {
            this.startBookmark(name);
        }
        this.zzYZ7(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zznY(71, false);
        if (zzYcQ.zzWtn(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzY83(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzZpx(83);
        if (zzYcQ.zzWtn(name)) {
            this.startBookmark(name);
        }
        this.zzYZ7(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zznY(83, false);
        if (zzYcQ.zzWtn(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzY83(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzZzo, footnoteType, !zzYcQ.zzWtn(referenceMark), referenceMark, this.zzDb());
        Style style = this.getDocument().getStyles().zzfA(zzYuh.zzLx(footnoteType));
        footnote.zzfo().set(50, style.zzWW4());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZzo);
        Style style2 = this.getDocument().getStyles().zzfA(zzYuh.zzYNK(footnoteType));
        paragraph.zzkf().set(1000, style2.zzWW4());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZzo, '\u0002', new zzVTt()) : new Run(this.zzZzo, footnote.getReferenceMark(), new zzVTt());
        inline.zzfo().set(50, style.zzWW4());
        paragraph.appendChild(inline);
        if (zzYcQ.zzWtn(footnoteText)) {
            Node node = this.zzXtr();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzWnu(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzyp(zzY09 zzY092) throws Exception {
        return this.zzXSa(zzY092, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzyp(zzY09.zzZd9(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXSa(zzY09 zzY092, double d, double d2) throws Exception {
        return this.zzXSa(zzY092, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXSa(zzY09.zzZd9(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        zzdX zzdX2 = new zzdX();
        try {
            zzYOj.zzZd9(image, zzdX2);
            Shape shape = this.zzXSa(zzdX2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zzdX2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzWFr.zzIl(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzVY4.zzXj2(fileName);
        try {
            Shape shape = this.zzXSa((zzY09)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzY09)object).close();
            }
        }
    }

    private Shape zzXSa(zzY09 zzY092, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzY092 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzWFr.zzXoB(zzY092);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXSa(zzY09.zzZd9(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXSa(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzXSa(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzXLq.zzXEn(object)) {
            object4 = new zzYOj((byte[])object);
            bl2 = true;
            ((zzW8t)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzZzo.getCompatibilityOptions().getMswVersion() > 12 || this.zzZzo.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzZzo, 0);
            object3 = new zzZQp();
            ((zzXUs)object3).zzXSa(zz8N.zzX4S("rect"));
            ((zzZQp)object3).zzXSa(new zzXB3());
            ((zzZQp)object3).zzZVr().zzZ4M().zzIl(this.zzZzo);
            object2 = new zzYqH();
            ((zzS)object2).zzZd9(new zzbc(this.zzZzo.zzZfA(), ""));
            ((zzS)object2).zzXSa(new zzWQX());
            ((zzWNe)object3).zzXSa((zzS)object2);
            shape.setShapeType(75);
            shape.zzZj((zzWNe)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzZzo, 75);
        }
        if (zzXLq.zzW2u(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzXSa((byte[])object, new zzY74(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzY74(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzXLq.zzZ17((byte[])object2));
                this.zzXSa((zzZQp)shape.zzY0z(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzZQp)shape.zzY0z()).zzZVr().zzZ4M().zzW7A((byte[])object);
            object3 = zzXLq.zzXqN(object);
            object4 = new zzY74(((zzVQ9)object3).getWidthPoints(), ((zzVQ9)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzXSa(this.zzDb());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzXLq.zzX9B(object)) {
            d5 = DocumentBuilder.zzXSa(shape, object);
        }
        shape.zzXSa(d3, d4, (zzY74)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzXSa(Shape shape, byte[] byArray) throws Exception {
        int n = zzXLq.zzW9A(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzYuh.zzWyv(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzYuh.zzYl7(n);
        return d;
    }

    private void zzXSa(zzZQp zzZQp2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzZQp2.zzZVr().zzZ4M().getExtensions();
        zzdX zzdX2 = new zzdX(byArray);
        try {
            object = zzYuh.zzXSa(zzdX2, this.zzZzo);
            ((zzX9X)object).zzWfe(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzX9X)object).zzZuB();
            byArray2 = ((zzX9X)object).zzVUx(true);
        }
        finally {
            zzdX2.close();
        }
        zzZQp2.zzZVr().zzZ4M().setExtensions(new zzYnW<zzBd>());
        object = zzBd.zzXSa(byArray2, this.zzZzo);
        zzZQp2.zzZVr().zzZ4M().getExtensions().zzZxs(((zzBd)object).getUri(), (zzBd)object);
    }

    private Shape zzXSa(zzY09 zzY092, String string, boolean bl, zzY09 zzY093) throws Exception {
        zzZjf zzZjf2 = zzZjf.zzXIA(string);
        Shape shape = this.zzXSa(zzY093, bl, zzZjf2, null);
        zzNj zzNj2 = zzYBd.zzXSa(zzY092, string, bl);
        return DocumentBuilder.zzXSa(null, false, shape, zzZjf2.zzYpQ, zzNj2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXSa(zzY09.zzZd9(stream), progId, asIcon, zzY09.zzZd9(presentation));
    }

    private Shape zzXSa(String string, boolean bl, boolean bl2, zzY09 zzY092) throws Exception {
        zzZjf zzZjf2 = zzZjf.zzXUx(zzYiL.zzYfs(string));
        return this.zzXSa(string, bl, bl2, zzY092, zzZjf2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXSa(fileName, isLinked, asIcon, zzY09.zzZd9(presentation));
    }

    private Shape zzXSa(String string, String string2, boolean bl, boolean bl2, zzY09 zzY092) throws Exception {
        zzZjf zzZjf2 = zzZjf.zzXIA(string2);
        return this.zzXSa(string, bl, bl2, zzY092, zzZjf2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXSa(fileName, progId, isLinked, asIcon, zzY09.zzZd9(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZjf zzZjf2 = zzZjf.zzXUx(zzYiL.zzYfs(fileName));
        return this.zzXSa(fileName, isLinked, iconFile, iconCaption, zzZjf2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZjf zzZjf2 = zzZjf.zzXIA(progId);
        return this.zzXSa(fileName, isLinked, iconFile, iconCaption, zzZjf2);
    }

    private Shape zzZd9(zzY09 zzY092, String string, String string2, String string3) throws Exception {
        zzZjf zzZjf2 = zzZjf.zzXIA(string);
        Shape shape = this.zzXSa(string2, string3, zzZjf2);
        zzNj zzNj2 = zzYBd.zzXSa(zzY092, string, true);
        return DocumentBuilder.zzXSa(null, false, shape, zzZjf2.zzYpQ, zzNj2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzZd9(zzY09.zzZd9(stream), progId, iconFile, iconCaption);
    }

    final Shape zzXSa(zzXSW zzXSW2, zzY09 zzY092) throws Exception {
        Shape shape = this.zzYSk(zzY092);
        shape.setShapeType(201);
        shape.setShapeAttr(4112, zzXSW2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzVVZ();
        if (this.zzZff()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzWPV(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZRr zzZRr2 = zzYuh.zzXSa(html, options, this);
        zzZRr2.zz4y();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzVVZ();
        return zzYuh.zzXSa(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzVVZ();
        return zzYuh.zzXSa(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzW7A zzW7A2 = new zzW7A();
        return zzW7A2.zzXSa(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXB4(this).zzXSa(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXB4(this).zzXSa(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZzo, 75);
        shape.zzXSa(this.zzDb());
        shape.zzZnj(true);
        shape.getSignatureLine().zzXSa(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzWx2(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzXVs(this.zzZzo);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzZff() {
        boolean bl = false;
        if (this.zzXtr().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXtr().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzWPV(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzVVZ();
        if (this.zzZJH() == null) {
            this.startTable();
        }
        if (this.zzZJH().zzZg5() == 1) {
            this.zzZJH().zzYWq();
        }
        if (this.zzZJH().zzZg5() == 3) {
            this.zzZJH().zzYaZ();
        }
        return this.zzZJH().zzY41();
    }

    public Table startTable() {
        this.zzZAR.push(new zzXxJ(this));
        return this.zzZJH().startTable();
    }

    public Table endTable() {
        if (this.zzZJH() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZJH().endTable();
        this.zzZAR.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzZJH() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzZJH().endRow();
        if (this.zztt != null && this.zztt.getHidden()) {
            row.zzWw7().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZzo, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZzo, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYfO();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZzo, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzYY9();
        bookmarkStart.zzmc(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYfO();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzYY9();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZzo, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzYF(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZzo);
        this.zzYIk = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzYIk == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZzo, this.zzYIk);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZzo, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzWFr.zzZd9((Object)importFormatOptions, "ImportFormatOptions");
        this.zzVVZ();
        return zzY2x.zzXSa(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzZzo;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZzo) {
            return;
        }
        this.zzZzo = value;
        this.zzWnu(null);
        this.zzBI = new zzVTt();
        this.zzYVz = null;
        this.zzIe = null;
        this.zztt = null;
        this.zzZAR = new zzZ2W();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zztt == null) {
            DocumentBuilder documentBuilder = this;
            this.zztt = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zztt;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzYgT == null) {
            DocumentBuilder documentBuilder = this;
            this.zzYgT = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzYgT;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzWHw == null) {
            this.zzWHw = new RowFormat(this);
        }
        return this.zzWHw;
    }

    public CellFormat getCellFormat() {
        if (this.zzVY1 == null) {
            this.zzVY1 = new CellFormat(this);
        }
        return this.zzVY1;
    }

    final void zzWEg(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzVTt zzVTt2;
        if (this.getCurrentParagraph() != null) {
            zzVTt zzVTt3 = this.getCurrentParagraph().zzW1l();
            zzVTt2 = (zzVTt)zzVTt3.zzYjq();
        } else {
            zzVTt2 = this.zzDb();
        }
        zzVTt zzVTt4 = zzVTt2;
        this.zzZIr().push(new zzXSa(this.zzDb(), zzVTt4));
    }

    public void popFont() {
        zzZ2W<zzXSa> zzZ2W2 = this.zzZIr();
        if (zzZ2W2.size() > 0) {
            zzXSa zzXSa2 = (zzXSa)this.zzZIr().pop();
            this.zzXSa(zzXSa2.zzfo(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzX7l(zzXSa2.zzcS());
            }
        }
    }

    final void zzYwc() {
        this.zzXAw().push(this.zzDb());
    }

    final void zzZHa() {
        zzZ2W<zzVTt> zzZ2W2 = this.zzXAw();
        if (zzZ2W2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXSa((zzVTt)documentBuilder.zzXAw().pop(), false);
        }
    }

    final void zzYCb() {
        this.zzXRw().push(this.zzY9Q());
    }

    final void zzZnr() {
        zzZ2W<zzYaP> zzZ2W2 = this.zzXRw();
        if (zzZ2W2.size() > 0) {
            zzYaP zzYaP2 = (zzYaP)this.zzXRw().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXSa(zzYaP2);
            }
        }
    }

    private zzWcL zzZd9(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzZpx(88);
        zzX37 zzX372 = new zzX37();
        zzX372.setTarget(string2);
        zzX372.setScreenTip(string3);
        if (bl) {
            zzX372.setSubAddress(string);
        } else {
            zzX372.setAddress(zzYz5.zzWhu(string));
            zzX372.setSubAddress(zzYz5.zzOM(string));
        }
        this.zzYZ7(zzX372.zzWzf());
        FieldSeparator fieldSeparator = this.zzXA(88);
        return new zzWcL(fieldStart, fieldSeparator, null);
    }

    final zzWcL zzWKo(String string, String string2, String string3) {
        boolean bl = zzYz5.zzXGK(string);
        String string4 = bl ? zzYz5.zzOM(string) : string;
        return this.zzZd9(string4, bl, string2, string3);
    }

    final zzWcL zzXSa(zzX37 zzX372) {
        FieldStart fieldStart = this.zzZpx(88);
        this.zzYZ7(zzX372.zzWzf());
        FieldSeparator fieldSeparator = this.zzXA(88);
        return new zzWcL(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzWij() {
        return this.zznY(88, true);
    }

    final zzVTt zzDb() {
        zzVTt zzVTt2 = this.zzBI;
        return (zzVTt)zzVTt2.zzYjq();
    }

    final zzYaP zzY9Q() {
        zzYaP zzYaP2 = this.zzkf();
        return (zzYaP)zzYaP2.zzYjq();
    }

    final zzXn0 zzXTm() {
        zzXn0 zzXn02 = this.zzWw7();
        return (zzXn0)zzXn02.zzYjq();
    }

    final zzAn zz05() {
        zzAn zzAn2 = this.zzZLs();
        return (zzAn)zzAn2.zzYjq();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXtr(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXtr().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzIV && this.zzXtr().getNodeType() == 28;
    }

    private void zzWEg(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzXtr()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzZcP.zzX3g(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzXc7(string2.substring(n4, n4 + n2));
                }
                switch (this.zzYEf) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZAS(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzXc7(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzVVZ();
        if (this.zzZJH() != null && this.zzZJH().zzZg5() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzXtr().getParentNode().insertBefore(node, this.zzXtr());
    }

    final void zzYFa(int n) {
        this.zzYYa(true);
        this.zz0j(n);
    }

    private void zz0j(int n) {
        this.insertParagraph();
        zzXsX zzXsX2 = new zzXsX(this.getDocument());
        try {
            zzXil zzXil2 = this.getCurrentSection().zzZoi();
            zzXil zzXil3 = (zzXil)zzXil2.zzYjq();
            Section section = new Section(this.zzZzo, zzXil3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZzo));
            this.zzZzo.insertAfter(section, this.getCurrentSection());
            section.getBody().zzZd9(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzXsX2.dispose();
        }
    }

    final FieldStart zzZpx(int n) {
        this.zzVVZ();
        return zzYuh.zzXSa(n, this.zzDb(), this.zzZ2E(), this.zzGq(), this.zzGq() == null);
    }

    final Run zzYZ7(String string) {
        return zzYuh.zzZd9(string, this.zzDb(), this.zzZ2E(), this.zzGq(), this.zzGq() == null);
    }

    final FieldEnd zznY(int n, boolean bl) {
        return zzYuh.zzZd9(n, bl, this.zzDb(), this.zzZ2E(), this.zzGq(), this.zzGq() == null);
    }

    final FieldSeparator zzXA(int n) {
        return zzYuh.zzZd9(n, this.zzDb(), this.zzZ2E(), this.zzGq(), this.zzGq() == null);
    }

    private FormField zzY83(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZzo, new zzXv7(), this.zzDb());
        CompositeNode compositeNode = node == null ? this.zzZ2E() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzYYa(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZJH() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzVRT(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzXc7(String string) {
        if (this.zzZi1(string)) {
            zzWfp zzWfp2 = new zzWfp(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzWGq zzWGq2 : zzWfp2.zzWgf(this.getParagraphFormat().getBidi())) {
                zzWnu zzWnu2 = zzWnu.zzWzU(zzWGq2.zzYRe());
                zzVTt zzVTt2 = this.zzDb();
                zzVTt2.zzX9S(265, zzWnu2);
                if (zzWGq2.zzWmH()) {
                    zzVTt2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZzo, zzWGq2.getText(), zzVTt2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZAS(string);
    }

    private boolean zzZi1(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzY3L.zzym(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXSa(zzVTt zzVTt2, boolean bl) {
        zzVTt zzVTt3;
        if (bl) {
            zzVTt zzVTt4 = zzVTt2;
            zzVTt3 = (zzVTt)zzVTt4.zzYjq();
        } else {
            zzVTt3 = zzVTt2;
        }
        this.zzBI = zzVTt3;
    }

    final void zzY9m() {
        this.zzBI.clear();
    }

    final void zzWk7() {
        if (this.zzYfO() != null) {
            zzAn zzAn2;
            zzAn zzAn3 = zzAn2 = this.zzYfO().zzZLs();
            this.zzZYc = (zzAn)zzAn3.zzYjq();
            zzAn2.zzZd9(this.zzZYc);
        }
    }

    private Shape zzXSa(String string, boolean bl, boolean bl2, zzY09 zzY092, zzZjf zzZjf2) throws Exception {
        if (zzZjf2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzXSa(zzY092, bl2, zzZjf2, string);
        zzNj zzNj2 = zzYBd.zzXSa(string, bl, bl2, zzZjf2);
        return DocumentBuilder.zzXSa(string, bl, shape, zzZjf2.zzYpQ, zzNj2);
    }

    private Shape zzXSa(String string, boolean bl, String string2, String string3, zzZjf zzZjf2) throws Exception {
        if (zzZjf2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzYiL.zzYMZ(string);
        }
        Shape shape = string2 != null ? this.zzZtm(string2, string3) : this.zzXSa(null, string3, zzZjf2);
        zzNj zzNj2 = zzYBd.zzXSa(string, bl, true, zzZjf2);
        return DocumentBuilder.zzXSa(string, bl, shape, zzZjf2.zzYpQ, zzNj2);
    }

    private static Shape zzXSa(String string, boolean bl, Shape shape, String string2, zzNj zzNj2) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzZd9(zzNj2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzXSa(zzY09 zzY092, boolean bl, zzZjf zzZjf2, String string) throws Exception {
        if (zzZjf2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzY092 != null) {
            return this.zzYSk(zzY092);
        }
        if (!bl) {
            return this.zzW6S(zzYBd.zzXkI().get("normal"));
        }
        String string2 = string != null ? zzYiL.zzYMZ(string) : zzYBd.zzWyv(zzZjf2.zzxG);
        return this.zzXSa(zzZjf2, string2);
    }

    private Shape zzXSa(String string, String string2, zzZjf zzZjf2) throws Exception {
        if (zzZjf2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzYBd.zzWyv(zzZjf2.zzxG);
        }
        if (string != null) {
            return this.zzZtm(string, string2);
        }
        return this.zzXSa(zzZjf2, string2);
    }

    private Shape zzXSa(zzZjf zzZjf2, String string) throws Exception {
        if (zzZjf2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzYBd.zzYl7(zzZjf2.zzxG);
        zzWVu zzWVu2 = new zzWVu(byArray, null, string, this.getDocument().zzZRS());
        return this.zzW6S(zzWVu2.zzYxo());
    }

    private Shape zzZtm(String string, String string2) throws Exception {
        zzWVu zzWVu2 = new zzWVu(string, string2, this.getDocument().zzZRS());
        return this.zzW6S(zzWVu2.zzYxo());
    }

    private Shape zzYSk(zzY09 zzY092) throws Exception {
        byte[] byArray = zzWFr.zzXoB(zzY092);
        return this.zzW6S(byArray);
    }

    private Shape zzW6S(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZzo, 1);
        shape.setShapeType(75);
        shape.zzXSa(this.zzDb());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzWx2(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzXSa(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzZd9(compositeNode, n);
            return;
        }
        this.zzIl(compositeNode, n);
    }

    private void zzZd9(CompositeNode compositeNode, int n) {
        zzF7 zzF72 = zzF7.zzXMW(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzF72.zzXSa(null, true, true, true, false, true);
            node = zzF72.getNode();
            if (zzF72.zzBp() && (!node.isComposite() || node.zzW6g() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzYlW().length() : node.getTextLength();
            if (!zzF72.zzBp() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzF72.zzBp() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzXSa((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzXSa(null, node);
            this.zzZx8 = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzXSa(StructuredDocumentTag structuredDocumentTag) {
        this.zzWnu(structuredDocumentTag);
        this.zzIV = true;
        this.zzZx8 = 0;
        zzVTt zzVTt2 = structuredDocumentTag.zzYJG();
        switch (structuredDocumentTag.zzW6g()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzWY4(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzVTt2 = ((Inline)node).zzfo();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzVTt2 = paragraph.zzW1l();
                break;
            }
            default: {
                return;
            }
        }
        this.zzXSa(zzVTt2, true);
    }

    private void zzIl(CompositeNode compositeNode, int n) {
        zzF7 zzF72 = zzF7.zz1F(compositeNode);
        while (zzF72.getNode() != compositeNode || !zzF72.zzBp()) {
            int n2;
            Node node = zzF72.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzYlW().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzXSa(null, node);
                this.zzZx8 = n;
                return;
            }
            while (zzF72.zzXSa(null, false, true, true, false, true) && zzF72.zzBp() && zzF72.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzVVZ() {
        int n = this.zzZx8;
        if (n == 0) {
            return;
        }
        this.zzZx8 = 0;
        Run run = zzWFr.zzXSa((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzWya(n);
        }
    }

    private Run zzZAS(String string) {
        Run run = new Run(this.zzZzo, string, this.zzDb());
        this.insertNode(run);
        return run;
    }

    final boolean zzVQ8() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZSS() {
        return this.zzYEf;
    }

    final void zzZo3(int n) {
        this.zzYEf = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXtr();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXtr();
        }
        return (Paragraph)this.zzXtr().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzXtr();
        }
        return (StructuredDocumentTag)this.zzXtr().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzXtr().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzXxJ zzZJH() {
        zzZ2W<zzXxJ> zzZ2W2 = this.zzZAR;
        if (zzZ2W2.size() > 0) {
            return (zzXxJ)this.zzZAR.peek();
        }
        return null;
    }

    private Cell zzYfO() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzYCP();
    }

    private CompositeNode zzZ2E() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzXtr();
        }
        return this.zzXtr().getParentNode();
    }

    private Node zzGq() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXtr();
    }

    private zzZ2W<zzVTt> zzXAw() {
        if (this.zzYVz == null) {
            this.zzYVz = new zzZ2W();
        }
        return this.zzYVz;
    }

    private zzZ2W<zzYaP> zzXRw() {
        if (this.zzIe == null) {
            this.zzIe = new zzZ2W();
        }
        return this.zzIe;
    }

    private zzZ2W<zzXSa> zzZIr() {
        if (this.zzXbv == null) {
            this.zzXbv = new zzZ2W();
        }
        return this.zzXbv;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzBI.zzXUO(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzBI.zzN4(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzWvg(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzWvg(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzBI.zzX9S(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWLH()) {
            this.getCurrentParagraph().zzW1l().zzX9S(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzBI.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzBI.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWLH()) {
            this.getCurrentParagraph().zzW1l().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzkf().zzXUO(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzkf().zzN4(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzyI(key, 0);
        }
        return this.getDocument().getStyles().zzXdP().zzZQN(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzkf().zzX9S(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzkf().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzkf().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWw7().zzXUO(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWw7().zzZQN(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWw7().zzVPh(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWw7().zzX9S(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWw7().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWw7().clear();
        zzXn0.zzYvd().zzZd9(this.zzWw7());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZLs().zzXUO(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZLs().zzZQN(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZLs().zzVPh(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzWFr.zzXSa(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzYfO() != null ? this.zzYfO().getCellFormat() : this.getCellFormat();
            border.zzXSa(cellFormat);
        }
        this.zzZLs().zzX9S(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZLs().clear();
    }

    private Node zzXtr() {
        Node node = this.zzWf != null && this.zzWf.getParentNode() == null ? this.zzJB : this.zzWf;
        if (node != null && node.zzW6g() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzIV = this.zzIV && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzWnu(Node node) {
        this.zzWf = node;
        if (this.zzWf != null) {
            this.zzJB = this.zzWf.getParentNode();
        }
        this.zzIV = false;
    }

    private zzYaP zzkf() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzkf();
        }
        if (this.zzZNU == null) {
            this.zzZNU = new zzYaP();
        }
        return this.zzZNU;
    }

    private zzXn0 zzWw7() {
        if (this.zzZJH() != null && this.zzZJH().zzZg5() == 1) {
            return this.zzWUi;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWw7();
        }
        return this.zzWUi;
    }

    private zzAn zzZLs() {
        if (this.zzZJH() != null && this.zzZJH().zzZg5() != 3) {
            return this.zzZYc;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzYCP().zzZLs();
        }
        return this.zzZYc;
    }

    static final class zzXSa {
        private zzVTt zzBI;
        private zzVTt zzYbP;

        public zzXSa(zzVTt zzVTt2, zzVTt zzVTt3) {
            this.zzBI = zzVTt2;
            this.zzYbP = zzVTt3;
        }

        public final zzVTt zzfo() {
            return this.zzBI;
        }

        public final zzVTt zzcS() {
            return this.zzYbP;
        }
    }
}

