/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzWFr;
import com.aspose.words.internal.zzX3g;
import com.aspose.words.internal.zzY09;
import com.aspose.words.internal.zzYcQ;
import com.aspose.words.internal.zzYlJ;
import com.aspose.words.internal.zzZtm;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzY69;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZ3N = new HashMap();
    private static HashMap<Integer, Integer> zzWjb = new HashMap();
    private static HashMap<Integer, Integer> zzXZC = new HashMap();
    private static HashMap<Integer, Integer> zzXfO = new HashMap();
    private static HashMap<Integer, Integer> zzRn = new HashMap();
    private static HashMap<Integer, Integer> zzYDf = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzWFr.zzIl(fileName, "fileName");
        zzX3g zzX3g2 = zzWFr.zzWfe(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzjv(zzX3g2);
            return fileFormatInfo;
        }
        finally {
            ((zzY09)zzX3g2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzjv(zzZtm.zzXSa(stream));
    }

    static FileFormatInfo zzjv(zzY09 zzY092) throws Exception {
        if (zzY092 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzY69 zzY692 = new zzY69();
            zzY09 zzY093 = zzY092;
            zzY69 zzY693 = zzY692;
            return zzY692.zzZd9(zzY093, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzIl(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzWcL(zzYlJ.zzXOT(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzYNR(zzYlJ.zzXOT(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzYcQ.zzWtn(string = zzYlJ.zzYAA(FileFormatUtil.zzYNj(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzWcL(FileFormatUtil.zzY1o(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzYNR(FileFormatUtil.zzYNj(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYlJ.zzYAA(FileFormatUtil.zzY1o(saveFormat));
        if (zzYcQ.zzWtn(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzYNR(zzYlJ.zzZra(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYlJ.zzYAA(FileFormatUtil.zzZqJ(imageType));
    }

    static Exception zzIl(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzYBv(int n) {
        return zzYlJ.toString(FileFormatUtil.zzY1o(n));
    }

    static int zzYNR(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWFr.zzXSa(zzRn, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzX0J(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWFr.zzXSa(zzYDf, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzWqA(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYNj(int n) {
        return zzWFr.zzXSa(zzZ3N, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzY1o(int n) {
        return zzWFr.zzXSa(zzWjb, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZqJ(int n) {
        return zzWFr.zzXSa(zzXZC, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzWcL(int n) {
        return zzWFr.zzXSa(zzXfO, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzAi(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzWFr.zzZd9(zzRn, Integer.valueOf(n), Integer.valueOf(n2));
            zzWFr.zzZd9(zzWjb, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzXfO.containsKey(n)) {
                zzWFr.zzZd9(zzXfO, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzWFr.zzZd9(zzZ3N, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzWFr.zzZd9(zzYDf, Integer.valueOf(n), Integer.valueOf(n4));
            zzWFr.zzZd9(zzXZC, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzAi(12, 10, 10, 1);
        FileFormatUtil.zzAi(12, 0, 0, 1);
        FileFormatUtil.zzAi(13, 11, 11, 1);
        FileFormatUtil.zzAi(14, 20, 20, 1);
        FileFormatUtil.zzAi(14, 0, 254, 1);
        FileFormatUtil.zzAi(15, 21, 21, 1);
        FileFormatUtil.zzAi(16, 22, 22, 1);
        FileFormatUtil.zzAi(17, 23, 23, 1);
        FileFormatUtil.zzAi(19, 24, 24, 1);
        FileFormatUtil.zzAi(20, 25, 25, 1);
        FileFormatUtil.zzAi(21, 26, 26, 1);
        FileFormatUtil.zzAi(22, 27, 27, 1);
        FileFormatUtil.zzAi(25, 30, 30, 1);
        FileFormatUtil.zzAi(18, 31, 31, 1);
        FileFormatUtil.zzAi(26, 50, 50, 1);
        FileFormatUtil.zzAi(27, 45, 255, 1);
        FileFormatUtil.zzAi(28, 51, 51, 1);
        FileFormatUtil.zzAi(29, 54, 52, 1);
        FileFormatUtil.zzAi(30, 0, 53, 1);
        FileFormatUtil.zzAi(32, 53, 54, 1);
        FileFormatUtil.zzAi(23, 60, 60, 1);
        FileFormatUtil.zzAi(24, 61, 61, 1);
        FileFormatUtil.zzAi(35, 40, 64, 1);
        FileFormatUtil.zzAi(42, 47, 255, 1);
        FileFormatUtil.zzAi(43, 48, 255, 1);
        FileFormatUtil.zzAi(36, 41, 255, 1);
        FileFormatUtil.zzAi(37, 46, 255, 1);
        FileFormatUtil.zzAi(39, 42, 255, 1);
        FileFormatUtil.zzAi(38, 44, 255, 1);
        FileFormatUtil.zzAi(31, 52, 55, 1);
        FileFormatUtil.zzAi(33, 70, 62, 1);
        FileFormatUtil.zzAi(34, 73, 63, 1);
        FileFormatUtil.zzAi(40, 71, 255, 1);
        FileFormatUtil.zzAi(8, 100, 255, 1);
        FileFormatUtil.zzAi(9, 105, 255, 1);
        FileFormatUtil.zzAi(6, 101, 255, 6);
        FileFormatUtil.zzAi(7, 102, 255, 7);
        FileFormatUtil.zzAi(5, 104, 255, 5);
        FileFormatUtil.zzAi(4, 0, 255, 4);
        FileFormatUtil.zzAi(3, 0, 255, 3);
        FileFormatUtil.zzAi(41, 72, 255, 1);
        FileFormatUtil.zzAi(2, 103, 255, 2);
        FileFormatUtil.zzAi(10, 106, 255, 8);
        FileFormatUtil.zzAi(47, 80, 255, 1);
    }
}

