/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWFr;
import com.aspose.words.internal.zzZ2W;
import com.aspose.words.internal.zzZu2;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzF7;
import com.aspose.words.zzXzL;
import com.aspose.words.zzY6R;
import com.aspose.words.zzYuh;
import com.aspose.words.zzZeu;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzVU7;
    private Node zzuv;
    private Node zzYgY;
    private int zzYlQ;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzIl(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzVU7 == null) {
            return null;
        }
        if (this.zzVU7.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzVU7;
    }

    final CompositeNode zzYFl() {
        if (zzYuh.zzX1r(this.getParentNode())) {
            return this.getParentNode().zzYFl();
        }
        return this.getParentNode();
    }

    final CompositeNode zzYNv() {
        if (zzYuh.zzX1r(this.getParentNode()) || zzYuh.zzZip(this.getParentNode())) {
            return this.getParentNode().zzYNv();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzVU7 != null) {
            return this.zzVU7.getDocument();
        }
        return null;
    }

    final Document zzWJR() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzey() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZE2();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzYgY;
    }

    final Node zzXkV() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzYuh.zzWfC((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzXjF() {
        Node node = zzYuh.zzWKo(this.getPreviousSibling(), false);
        if (node == null && zzYuh.zzX1r(this.getParentNode())) {
            node = this.getParentNode().zzXjF();
        }
        return node;
    }

    final Node zzXxB() {
        Node node = zzYuh.zzZvz(this.getNextSibling(), false);
        if (node == null && zzYuh.zzX1r(this.getParentNode())) {
            node = this.getParentNode().zzXxB();
        }
        return node;
    }

    final CompositeNode zzXrq() {
        Node node = this;
        while ((node = node.zzXjF()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzoI() {
        Node node = this;
        while ((node = node.zzXxB()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzuv;
    }

    final Node zzZCi() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzYuh.zzWfC((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzXmz() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXAl() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzX1q() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzYuh.zzXcZ(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzWQx() {
        return this.zzuv;
    }

    final void zz10(Node node) {
        this.zzuv = node;
    }

    final Node zzZfZ() {
        return this.zzYgY;
    }

    final void zzWZF(Node node) {
        this.zzYgY = node;
    }

    final Node zzWQk() {
        Node node = this;
        if (node.zzuv != null) {
            node = this;
            return node.zzuv;
        }
        return this.getParentNode();
    }

    final int zzW6g() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzYuh.zzVYS(this);
        boolean bl2 = zzYuh.zzZ1O(this);
        boolean bl3 = zzYuh.zzWSh(this);
        boolean bl4 = zzYuh.zz4n(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzW6g() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzW6g() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzXSa(isCloneChildren, new zzXSa(this));
    }

    Node zzXSa(boolean bl, zzXzL zzXzL2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzVU7 != null) {
            node.zzVU7 = this.getDocument().zzZoJ();
        }
        node.zzuv = null;
        node.zzYgY = null;
        if (zzXzL2 != null) {
            zzXzL2.zzZ6J(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzZ31(StringBuilder stringBuilder) {
        zzWFr.zzZd9(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zz0n(Node node) {
        this.zzVU7 = node != null ? node : this.getDocument().zzZoJ();
    }

    final void zzIl(DocumentBase documentBase) {
        this.zzVU7 = documentBase != null ? documentBase.zzZoJ() : null;
    }

    final boolean zzYrG(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzWHQ() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzZha(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzVE(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzWY5(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzZ31(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzZLh(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzY6R zzY6R2 = zzYuh.zzXyE(saveFormat);
        return zzY6R2.zzZJu(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzY6R zzY6R2 = zzYuh.zzZd9(saveOptions);
        return zzY6R2.zzZJu(this);
    }

    final Node zzZOT(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzYuh.zzY0b(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzF7 zzY9M() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzF7.zz1F(node);
        }
        return zzF7.zzXMW(this.getParentNode());
    }

    final zzF7 zzXbG() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzF7.zzXMW(node);
        }
        return zzF7.zz1F(this.getParentNode());
    }

    final boolean zzYJ0(Node node) {
        return Node.zzY83(this, node);
    }

    final boolean zzWHz() {
        return this.getAncestor(1) == null;
    }

    static Node zzWEg(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzZ2W<Node> zzZ2W2 = Node.zzZPk(node);
        zzZ2W<Node> zzZ2W3 = Node.zzZPk(node2);
        return Node.zzXSa(zzZ2W2, zzZ2W3);
    }

    static boolean zzY83(Node node, Node node2) {
        zzZ2W<Node> zzZ2W2;
        if (node == null || node2 == null) {
            return false;
        }
        zzZ2W<Node> zzZ2W3 = Node.zzZPk(node);
        Node node3 = Node.zzXSa(zzZ2W3, zzZ2W2 = Node.zzZPk(node2));
        if (node3 == null) {
            return false;
        }
        zzZ2W<Node> zzZ2W4 = zzZ2W3;
        if (zzZ2W4.size() == 0 || (zzZ2W4 = zzZ2W2).size() == 0) {
            zzZ2W4 = zzZ2W2;
            boolean bl = zzZ2W4.size() > 0;
            return bl;
        }
        Object e = zzZ2W3.peek();
        Object e2 = zzZ2W2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzZ2W<Node> zzZPk(Node node) {
        zzZ2W<Node> zzZ2W2 = new zzZ2W<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzZ2W2.push(node2);
        }
        return zzZ2W2;
    }

    private static Node zzXSa(zzZ2W<Node> zzZ2W2, zzZ2W<Node> zzZ2W3) {
        Node node = null;
        while (zzZ2W2.peek() == zzZ2W3.peek()) {
            node = (Node)zzZ2W2.pop();
            zzZ2W3.pop();
            zzZ2W<Node> zzZ2W4 = zzZ2W2;
            if (zzZ2W4.size() != 0 && (zzZ2W4 = zzZ2W3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzYlQ;
    }

    public void setCustomNodeId(int value) {
        this.zzYlQ = value;
    }

    private String zzYwO() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzWFr.zzXSa(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzZu2.zzGJ(stringBuilder.toString());
    }

    public String toString() {
        return zzZu2.zzGJ(zzZu2.zzZd9("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzYwO()));
    }

    public void dd() {
    }

    final Node zzY0b(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zz4n(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZ1O(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zz4n(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zz4n(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzXSa
    implements zzXzL {
        private Node zzZCq;
        private HashMap<Integer, Integer> zzdd;

        zzXSa(Node node) {
            this.zzZCq = node;
        }

        @Override
        public final void zzZ6J(Node node, Node node2) {
            if (node == this.zzZCq) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzZeu zzZeu2 = (zzZeu)((Object)node2);
            if (this.zzdd == null) {
                this.zzdd = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzWFr.zzXSa(this.zzdd, Integer.valueOf(zzZeu2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzZyL();
                zzWFr.zzZd9(this.zzdd, Integer.valueOf(zzZeu2.getIdInternal()), Integer.valueOf(n));
            }
            zzZeu2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzWFr.zzXSa(this.zzdd, Integer.valueOf(zzZeu2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzZeu2.setParentIdInternal(n2);
            }
        }
    }
}

