/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZtm;
import com.aspose.words.zzWN1;
import com.aspose.words.zzWXn;
import com.aspose.words.zzXwC;
import com.aspose.words.zzZRp;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzWXn,
Iterable<T> {
    private Node zzWCH;
    private CompositeNode zzZd3;
    private DocumentBase zzYjt;
    private boolean zzX7Z;
    private int zzZWM;
    private int zzXWn;
    private Node zzWP7;
    private int zztL;
    private zzWN1 zzUJ;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzZRp.zzZMl(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZRp(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzWN1 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: container");
        }
        if (matcher == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: matcher");
        }
        this.zzZd3 = container;
        this.zzYjt = container.getDocument();
        this.zzUJ = matcher;
        this.zzX7Z = isDeep;
        this.zzY75();
    }

    public Node get(int index) {
        try {
            this.zzZ1m();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzXWn == index) {
                return this.zzWP7;
            }
            int n = index - this.zzXWn;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzWWo(nodeCollection.zzWP7, n);
            if (node != null) {
                this.zzXWn = index;
                this.zzWP7 = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzX7Z) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZd3.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzX7Z) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZd3.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzZ9T();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXwC(this);
    }

    final <TNode extends Node> zzXwC<TNode> zzVVO() {
        return new zzXwC(this);
    }

    final ArrayList<Node> zzW1() {
        return this.zzZ9T();
    }

    final <TValue extends Node> ArrayList<TValue> zzZ9T() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZtm.zzXSa(arrayList, node);
        }
        return arrayList;
    }

    private Node zzWWo(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzWG9(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzYqY(curNode, true);
    }

    private Node zzYqY(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzWCH = node;
        do {
            node2 = this.zzWCH;
            Node node3 = this.zzX7Z ? this.zzXSa(true, this.zzWCH) : (this.zzWCH = this.zzUJ.zzXvA() ? this.zzIl(true, this.zzWCH) : this.zzZd9(true, this.zzWCH));
        } while (this.zzWCH != null && !this.zzUJ.zzWWo(this.zzWCH));
        return node2;
    }

    private Node zzWG9(Node node, boolean bl) throws Exception {
        while ((this.zzX7Z ? this.zzXSa(bl, node) : (node = this.zzUJ.zzXvA() ? this.zzIl(bl, node) : this.zzZd9(bl, node))) != null && !this.zzUJ.zzWWo(node)) {
        }
        return node;
    }

    private Node zzXSa(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzZd3);
        }
        return node.previousPreOrder(this.zzZd3);
    }

    private Node zzZd9(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzZd3) {
                return this.zzZd3.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzZd3) {
            return this.zzZd3.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzIl(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzZd3 ? this.zzZd3.zzZpu() : node.zzXxB();
        } else {
            Node node3 = node2 = node == this.zzZd3 ? this.zzZd3.zzK2() : node.zzXjF();
        }
        if (node2 == this.zzZd3.getNextSibling() || node2 == this.zzZd3.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzZ1m() {
        if (this.zzZWM != this.zzW3()) {
            this.zzY75();
        }
    }

    private void zzY75() {
        this.zzZWM = this.zzW3();
        this.zzXWn = -1;
        this.zzWP7 = this.zzZd3;
        this.zztL = -1;
    }

    private int zzW3() {
        if (this.zzYjt != null) {
            return this.zzYjt.zzqe();
        }
        return 0;
    }

    public int getCount() {
        this.zzZ1m();
        if (this.zztL == -1) {
            this.zztL = zzXwC.zzXSa(this);
        }
        return this.zztL;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzWCH;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzZd3;
    }
}

