/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzYiL;
import com.aspose.words.internal.zzYlJ;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzYLN;
    private boolean zzVt;
    boolean zzOt = false;
    boolean zzXwX = true;
    private boolean zzW8A = true;
    private boolean zzYZy = false;
    private boolean zzXlk;
    private boolean zzZzn = true;
    private boolean zzZ;
    private String zzY2p;
    private boolean zzVd;
    private boolean zzWh9 = false;
    private int zzWDC = 1;
    private int zzXpL = 1;
    private int zzX1C = 0;
    private String zzWeI = "";
    private boolean zzZYF = true;
    private boolean zzY2I = true;
    private boolean zzW1J;
    private boolean zzX1Y;
    private int zzVSo = 0;
    private boolean zzIM = true;
    private boolean zzYgW = false;

    protected SaveOptions() {
    }

    final boolean zzYqN() {
        return this.zzXlk;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzWBF() {
        return false;
    }

    boolean zzZMn() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzZzn;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzZzn = value;
    }

    public String getTempFolder() {
        return this.zzY2p;
    }

    public void setTempFolder(String value) {
        this.zzY2p = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZ;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZ = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzVd;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzVd = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWh9;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWh9 = value;
    }

    @Deprecated
    public boolean getUpdateSdtContent() {
        return this.zzOt;
    }

    @Deprecated
    public void setUpdateSdtContent(boolean value) {
        this.zzOt = value;
    }

    public int getDmlRenderingMode() {
        return this.zzWDC;
    }

    public void setDmlRenderingMode(int value) {
        this.zzWDC = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzX1C;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzX1C = value;
    }

    public int getImlRenderingMode() {
        return this.zzXpL;
    }

    public void setImlRenderingMode(int value) {
        this.zzXpL = value;
    }

    public String getDefaultTemplate() {
        return this.zzWeI;
    }

    public void setDefaultTemplate(String value) {
        this.zzWeI = value;
    }

    public boolean getUpdateFields() {
        return this.zzZYF;
    }

    public void setUpdateFields(boolean value) {
        this.zzZYF = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzW1J;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzW1J = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzX1Y;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzX1Y = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYgW;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYgW = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYZy;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYZy = value;
    }

    final boolean zzWgE() {
        return this.zzY2I;
    }

    final boolean zzVX() {
        return this.zzIM;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzYNR(zzYlJ.zzZra(zzYiL.zzYfs(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzVSo;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzVSo = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzYLN;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzYLN = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzVt;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzVt = value;
    }

    final boolean zzZC8() {
        return this.zzW8A;
    }

    final void zzjx(boolean bl) {
        this.zzW8A = false;
    }
}

