/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzWFr;
import com.aspose.words.internal.zzZu2;
import com.aspose.words.zzXil;
import com.aspose.words.zzXzL;
import com.aspose.words.zzYin;

public final class Section
extends CompositeNode<Node>
implements zzYin {
    private zzXil zzXGn;
    private PageSetup zzWdz;
    private HeaderFooterCollection zzaz;

    public Section(DocumentBase doc) {
        this(doc, new zzXil());
    }

    Section(DocumentBase doc, zzXil sectPr) {
        super(doc);
        this.zzXGn = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzaz == null) {
            this.zzaz = new HeaderFooterCollection(this);
        }
        return this.zzaz;
    }

    public final PageSetup getPageSetup() {
        if (this.zzWdz == null) {
            Section section = this;
            this.zzWdz = new PageSetup(section, section.getDocument().zzZ4t(), this.getDocument().getStyles(), new zzXSa(this));
        }
        return this.zzWdz;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZJD();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzXPJ(!value);
    }

    final zzXil zzZoi() {
        return this.zzXGn;
    }

    final void zzIl(zzXil zzXil2) {
        this.zzXGn = zzXil2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXSa(boolean bl, zzXzL zzXzL2) {
        zzXil zzXil2;
        Section section = (Section)super.zzXSa(bl, zzXzL2);
        zzXil zzXil3 = this.zzXGn;
        section.zzXGn = zzXil2 = (zzXil)zzXil3.zzYjq();
        section.zzWdz = null;
        section.zzaz = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXSa(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzZd9(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzZ6J(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzZ6J(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzW1X(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzZZU(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzW1X(n) == null;
            }
        }
        return false;
    }

    final void zzIl(Shape shape, boolean bl) throws Exception {
        this.zzXSa(shape, 4, bl);
        this.zzXSa(shape, 0, bl);
        this.zzXSa(shape, 1, bl);
    }

    private void zzXSa(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzZfA());
        shape2.setName(zzZu2.zzZd9("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzZXc() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZsT()) {
                if (!shape.zzXXa()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzZ6J(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzZd9(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzXGn.zzXUO(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzZ4t().zzWXC.zzZQN(key);
        }
        return zzXil.zzVUx(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzXGn.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzZ4t().zzWXC.zzX9S(key, value);
            return;
        }
        this.zzXGn.zzX9S(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzXGn.clear();
    }

    final boolean zzXqH() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzXwU() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzXGn.getSectionStart());
        return zzZu2.zzZd9("{0} {1}", objectArray);
    }

    static final class zzXSa
    implements zzYin {
        private Section zzWWY;

        zzXSa(Section section) {
            this.zzWWY = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzpp().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzpp().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzpp().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzYin zzpp() {
            Document document = zzWFr.zzXSa((Object)this.zzWWY.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWWY;
        }
    }
}

