/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWFr;
import com.aspose.words.internal.zzX9t;
import com.aspose.words.internal.zzXIz;
import com.aspose.words.internal.zzYcQ;
import com.aspose.words.internal.zzZ1B;
import com.aspose.words.internal.zzZu2;
import com.aspose.words.zzXex;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzZzo;
    private zzXex zzZGF;

    Watermark(Document doc, zzXex watermarkProvider) {
        this.zzZzo = doc;
        this.zzZGF = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzzx(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXSa(text, textWatermarkOptions, this.zzZzo);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzWFr.zzZd9((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzZzo, 75);
        shape.getImageData().setImage(image);
        this.zzXSa(shape, options, this.zzZzo);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzWFr.zzZd9((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzZzo, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXSa(shape, options, this.zzZzo);
    }

    public final int getType() {
        Shape shape = this.zzZGF.get();
        if (shape == null) {
            return 2;
        }
        shape.zzXXa();
        if (shape.zzXtq()) {
            return 0;
        }
        if (shape.zzYEg()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzZGF.add(shape);
    }

    public final void remove() {
        this.zzZGF.remove();
    }

    private static void zzzx(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzYcQ.zz6A(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzWFr.zzXSa(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXSa(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzZd9(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzZxs(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzZd9(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzXZ7() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzYJy()) / d2) > (double)(f = pageSetup.zzZcb())) {
            d = (double)f / d3;
        }
        shape.zzZVp(zzXIz.zzIl(d2 * d, 2, 1));
        shape.zzYJd(zzXIz.zzIl(d3 * d, 2, 1));
    }

    private Shape zzXSa(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXSa(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzZxs(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXSa(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzXZ1() ? 1.0f : textWatermarkOptions.getFontSize();
        zzX9t zzX9t2 = document.zzZRS().zzIl(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzX9t2.zz4n(shape.getTextPath().getText());
        if (textWatermarkOptions.zzXZ1()) {
            l = Watermark.zzXSa(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZVp(zzXIz.zzIl(Float.intBitsToFloat(n), 2, 1));
        shape.zzYJd(zzXIz.zzIl(zzZ1B.zzkK(l), 2, 1));
    }

    private static long zzXSa(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzYJy();
        float f2 = pageSetup.zzZcb();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzZ1B.zzkK(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzZ1B.zzYE0(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzZ1B.zzkK(l) >= Float.intBitsToFloat(n)) {
            return zzZ1B.zzYE0(f2 / f3, f2);
        }
        float f6 = f;
        return zzZ1B.zzYE0(f6, f6 * f3);
    }

    private static void zzZxs(Shape shape, String string) {
        shape.setName(zzZu2.zzZd9("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

