/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZu2;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzX2G = new ArrayList();
    private final Map<String, DataColumn> zzWPO = new HashMap<String, DataColumn>();
    private DataTable zzWBQ;

    DataColumnCollection(DataTable table) {
        this.zzWBQ = table;
    }

    public void add(DataColumn column) {
        if (zzZu2.zzZNf(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzXTq(column.getColumnName());
        if (this.zzWPO.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzZ6J(this.zzWBQ);
        column.setOrdinal(this.zzX2G.size());
        this.zzX2G.add(column);
        this.zzWPO.put(string, column);
        this.zzWBQ.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWBQ);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWBQ);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzZu2.zzZNf(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzXTq(columnName);
        DataColumn dataColumn = this.zzWPO.get(string);
        if (dataColumn != null) {
            int n = this.zzX2G.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzX2G.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzX2G.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzX2G.remove(n);
            this.zzWPO.remove(DataColumnCollection.zzXTq(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzWBQ.getRows()) {
                dataRow.remove(n);
            }
            this.zzWBQ.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzX2G.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzX2G.iterator();
    }

    public void clear() {
        this.zzWPO.clear();
        this.zzX2G.clear();
    }

    final DataColumn[] zzeN() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzX2G);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzXSa(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzX2G.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzX2G.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzXTq(string);
            String string3 = DataColumnCollection.zzXTq(dataColumn.getColumnName());
            this.zzWPO.remove(string3);
            this.zzWPO.put(string2, dataColumn);
            return;
        }
    }

    private static String zzXTq(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

