/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWWh;
import com.aspose.words.internal.zzXmG;
import com.aspose.words.internal.zzYBI;
import com.aspose.words.internal.zzZtm;
import com.aspose.words.internal.zzZu2;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzZ6J;
import com.aspose.words.net.System.Data.zzZd9;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzWBQ;
    private Object[] zzTn;
    private int zzXwN = 1;
    private int zzwV;
    private String zzZHB;
    private Map<String, Object> zzhW = new HashMap<String, Object>();
    private Map<String, String> zzZvD = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzWBQ = table;
        this.zzTn = new Object[table.getColumns().getCount()];
        Arrays.fill(this.zzTn, DBNull.Value);
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzZd9.zzIl(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzWBQ.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzWBQ.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzWBQ;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzWBQ.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzWBQ.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzWBQ.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzWBQ.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzWBQ.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzWBQ.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzWBQ) {
            throw new IllegalStateException(zzZu2.zzZd9("Table {0} is not the child table in the relation {1}", this.zzWBQ.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzXSa(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzVRo(columnIndex, value);
        this.zzWBQ.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzWBQ.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzXwN;
    }

    public void setRowState(int state) {
        this.zzXwN = state;
    }

    public void delete() {
        zzZ6J.zzZd9(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzhW.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzhW.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzTn.length];
        System.arraycopy(this.zzTn, 0, objectArray, 0, this.zzTn.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzTn.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzTn.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzVRo(i, array[i]);
        }
        this.zzWBQ.onDataRowChanged(this);
    }

    final int zzZgj() {
        return this.zzwV;
    }

    final void zzYdW(String string, String string2) {
        this.zzZvD.put(string, string2);
    }

    final void zz10(String string, String string2) {
        this.zzZHB = zzZu2.zzZd9(string, string2);
    }

    final String zzXjG() {
        return this.zzZHB;
    }

    final void zz4p(int n) {
        this.zzwV = n;
    }

    final Object[] zzWZw() {
        return this.zzTn;
    }

    static boolean zzXSa(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null && dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzXKs(index)) {
            return null;
        }
        return this.zzTn[index];
    }

    private void zzVRo(int n, Object object) {
        if (!this.zzXKs(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzXSa((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzXSa((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzXSa(clazz, object)))));
        this.zzTn[n] = object2;
    }

    private static Object zzXSa(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        try {
            if (clazz == String.class) {
                return string;
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzWWh.class) {
                return zzWWh.zzXSa(string, zzXmG.zzZS2(), 128).zzYvq();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzYBI.zzIl(exception);
        }
        return object;
    }

    private boolean zzXKs(int n) {
        this.zzWUA();
        return this.zzTn != null && n >= 0 && n < this.zzTn.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzWBQ.getColumns().getCount();
        if (this.zzTn.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzTn.length - 1];
        System.arraycopy(this.zzTn, 0, objectArray, 0, index);
        System.arraycopy(this.zzTn, index + 1, objectArray, index, this.zzTn.length - index - 1);
        this.zzTn = objectArray;
    }

    private void zzWUA() {
        if (this.zzWBQ == null || this.zzWBQ.getColumns() == null || this.zzTn == null) {
            return;
        }
        int n = this.zzWBQ.getColumns().getCount();
        if (this.zzTn.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzTn.length];
        System.arraycopy(this.zzTn, 0, objectArray, 0, this.zzTn.length);
        this.zzTn = new Object[n];
        int n2 = Math.min(objectArray.length, this.zzTn.length);
        System.arraycopy(objectArray, 0, this.zzTn, 0, n2);
        for (int i = n2; i < this.zzTn.length; ++i) {
            this.zzTn[i] = DBNull.Value;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] zzXSa(Blob blob) {
        InputStream inputStream;
        byte[] byArray;
        block13: {
            byArray = null;
            inputStream = null;
            if (blob != null && blob.length() != 0L) break block13;
            byte[] byArray2 = byArray;
            if (inputStream == null) return byArray2;
            try {
                inputStream.close();
                return byArray2;
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                zzYBI.zzIl(iOException);
            }
            return byArray2;
        }
        Object object = new ByteArrayOutputStream();
        inputStream = blob.getBinaryStream();
        zzZtm.zzXSa(inputStream, (OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            object = iOException;
            zzYBI.zzIl(iOException);
        }
        return byArray;
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
                zzYBI.zzIl(exception);
                if (inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException3 = iOException;
                    zzYBI.zzIl(iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                zzYBI.zzIl(iOException);
            }
            return byArray;
        }
    }

    private static String zzXSa(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzYBI.zzIl(exception);
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzYBI.zzIl(iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.getTable().getTableName() == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzTn;
        int n = dataRow.zzTn.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

