/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYBI;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzIl;
import com.aspose.words.net.System.Data.zzYK7;
import com.aspose.words.net.System.Data.zzZd9;
import com.aspose.words.net.System.Data.zzZj;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzVQ7;
    private final DataColumnCollection zzXTb;
    private final ConstraintCollection zzfY;
    private final zzYK7 zzYIO;
    private ResultSet zzXQ1;
    private String zzZtf;
    private DataSet zzXuj;
    private String zzW6K;
    private UniqueConstraint zzVTO;
    private boolean zzZyn;
    private final List<DataTableEventListener> zzW0s;
    private final Set<DataRow> zzYT9;
    private DataRelationCollection zzWI0;

    public DataTable() {
        this.zzVQ7 = new DataRowCollection(this);
        this.zzXTb = new DataColumnCollection(this);
        this.zzfY = new ConstraintCollection(this);
        this.zzYIO = new zzYK7(this);
        this.zzW6K = "";
        this.zzZyn = true;
        this.zzW0s = new ArrayList<DataTableEventListener>();
        this.zzYT9 = new HashSet<DataRow>();
        this.zzWI0 = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzVQ7 = new DataRowCollection(this);
        this.zzXTb = new DataColumnCollection(this);
        this.zzfY = new ConstraintCollection(this);
        this.zzYIO = new zzYK7(this);
        this.zzW6K = "";
        this.zzZyn = true;
        this.zzW0s = new ArrayList<DataTableEventListener>();
        this.zzYT9 = new HashSet<DataRow>();
        this.zzWI0 = new DataRelationCollection();
        this.zzZtf = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzZd9.zzXSa(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzVQ7 = new DataRowCollection(this);
        this.zzXTb = new DataColumnCollection(this);
        this.zzfY = new ConstraintCollection(this);
        this.zzYIO = new zzYK7(this);
        this.zzW6K = "";
        this.zzZyn = true;
        this.zzW0s = new ArrayList<DataTableEventListener>();
        this.zzYT9 = new HashSet<DataRow>();
        this.zzWI0 = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXQ1 = resultSet;
        this.zzZtf = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXQ1 != null) {
            if (this.zzXQ1.getStatement() != null) {
                this.zzXQ1.getStatement().getConnection().close();
            }
            this.zzXQ1 = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZtf;
    }

    public void setTableName(String tableName) {
        this.zzZtf = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXTb.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXTb.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXQ1;
    }

    public DataSet getDataSet() {
        return this.zzXuj;
    }

    final void zzZ6J(DataSet dataSet) {
        this.zzXuj = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzXuj.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzWI0.add(dataRelation);
        }
        return this.zzWI0;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzXuj.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzVQ7;
    }

    public DataColumnCollection getColumns() {
        return this.zzXTb;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzfY;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzVTO == null) {
            return new DataColumn[0];
        }
        return this.zzVTO.getColumns();
    }

    final void zzYK7(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzVTO != null) {
                this.zzVTO.zzYh7(false);
                this.getConstraints().remove(this.zzVTO);
                this.zzVTO = null;
            }
            return;
        }
        if (this.zzVTO != null && DataColumn.areColumnSetsTheSame(value, this.zzVTO.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXSa(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzVTO != null) {
            this.zzVTO.zzYh7(false);
            this.getConstraints().remove(this.zzVTO);
            this.zzVTO = null;
        }
        UniqueConstraint.zzXSa(this.getConstraints(), uniqueConstraint);
        this.zzVTO = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzW6K;
    }

    public void setNamespace(String namespace) {
        this.zzW6K = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZyn;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZyn = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzYT9.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzZd9.zzXSa(this.getResultSet(), this);
            zzZd9.zzZd9(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzYBI.zzZ6J(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzZd9.zzZxs(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzW0s.contains(listener)) {
            this.zzW0s.add(listener);
        }
    }

    public void removeEventListener(zzIl listener) {
        if (this.zzW0s.contains(listener)) {
            this.zzW0s.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzW0s.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzYT9.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzW0s) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzYT9.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzW0s) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzYT9.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzW0s) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzW0s) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzW0s) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzZj zzXSa(zzZd9[] zzZd9Array) {
        DataColumn[] dataColumnArray = new DataColumn[zzZd9Array.length];
        for (int i = 0; i < zzZd9Array.length; ++i) {
            dataColumnArray[i] = zzZd9Array[i].zzYQT();
        }
        DataTable dataTable = this;
        zzZj zzZj2 = dataTable.zzYIO.zzZ6J(dataColumnArray);
        if (zzZj2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzZj2;
    }

    final zzYK7 zzYaA() {
        return this.zzYIO;
    }

    final Set<DataRow> zzZXG() {
        return this.zzYT9;
    }
}

