/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzhd;
import com.aspose.words.zzAc;
import com.aspose.words.zzWUP;
import com.aspose.words.zzWdH;
import com.aspose.words.zzXHH;
import com.aspose.words.zzXU4;
import com.aspose.words.zzXXc;
import com.aspose.words.zzYem;
import com.aspose.words.zzYvg;
import com.aspose.words.zzZ3;
import com.aspose.words.zzZNc;
import com.aspose.words.zzZkc;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzWdH zzZBo;

    ChartSeriesCollection(zzWdH chartSpace) {
        this.zzZBo = chartSpace;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZ9n().zzZSF().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZ9n().zzZSF().iterator();
    }

    public void removeAt(int index) {
        this.zzZ9n().zzZIr(index);
    }

    public void clear() {
        this.zzZ9n().zzeX();
        for (zzWUP zzWUP2 : this.zzZBo.zzWrX()) {
            zzWUP2.zzY0O(false);
        }
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXQZ(chartSeriesCollection.zzZ9n().zzWfI(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXQZ(chartSeriesCollection.zzZ9n().zzWfI(), seriesName, xValues, yValues);
    }

    private ChartSeries zzXQZ(String string, zzhd[] zzhdArray, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXQZ(chartSeriesCollection.zzZ9n().zzWfI(), string, zzhdArray, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXQZ(seriesName, zzhd.zzXQZ(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXQZ(chartSeriesCollection.zzZ9n().zzWfI(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzXQZ(zzWUP zzWUP2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXQZ(zzWUP2, string, dArray);
        chartSeries.zzmW().zzuZ(ChartSeriesCollection.zzXUb(stringArray));
        return chartSeries;
    }

    final ChartSeries zzXQZ(zzWUP zzWUP2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXQZ(zzWUP2, string, dArray2);
        chartSeries.zzmW().zzuZ(ChartSeriesCollection.zzw1(dArray));
        return chartSeries;
    }

    private ChartSeries zzXQZ(zzWUP zzWUP2, String string, zzhd[] zzhdArray, double[] dArray) {
        if (zzhdArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzhdArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzhdArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXQZ(zzWUP2, string, dArray);
        chartSeries.zzmW().zzuZ(ChartSeriesCollection.zzXQZ(zzhdArray));
        if (!zzWUP2.zzYzt()) {
            zzWUP2.zzY0O(true);
        }
        return chartSeries;
    }

    final ChartSeries zzXQZ(zzWUP zzWUP2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzWUP2.zzYho() != 15) {
            zzWUP2.zzZDB(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXQZ(zzWUP2, string, dArray2);
        chartSeries.zzZCV().zzXPk().zz4W(3, chartSeries.zzYch().zzWuw());
        chartSeries.zzmW().zzuZ(ChartSeriesCollection.zzw1(dArray));
        if (dArray3 != null) {
            chartSeries.zzZIx().zzuZ(ChartSeriesCollection.zzw1(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzXQZ(zzWUP zzWUP2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzWUP2);
        chartSeries.setName(string);
        ChartSeriesCollection.zzYe3(chartSeries);
        chartSeries.zzkr().zzuZ(ChartSeriesCollection.zzw1(dArray));
        this.zzZBo.zzZhF();
        this.zzZ9n().zzXsA(chartSeries);
        return chartSeries;
    }

    private static void zzYe3(ChartSeries chartSeries) {
        chartSeries.zzZCV().zzXPk().zz4W(5, new zzZkc());
        if (ChartDataPointCollection.zzZIc(chartSeries.zzYch().zzYho())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzYch().zzYho()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXQZ(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXQZ(chartSeries, 5);
                ChartSeriesCollection.zzYhu(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXQZ(chartSeries, 1);
                ChartSeriesCollection.zzYhu(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzXf9(chartSeries);
            }
        }
    }

    private static void zzXf9(ChartSeries chartSeries) {
        zzZkc zzZkc2 = new zzZkc();
        zzZkc2.setOutline(new zzYem());
        zzXXc zzXXc2 = new zzXXc();
        zzXXc2.zzVRT(1);
        zzZkc2.getOutline().setFill(new zzZNc(zzXXc2));
        zzZkc2.getOutline().zzWWa(19050.0);
        chartSeries.zzZCV().zzXPk().zz4W(5, zzZkc2);
    }

    private static void zzYhu(ChartSeries chartSeries) {
        zzZkc zzZkc2 = new zzZkc();
        zzZkc2.setOutline(new zzYem());
        zzZkc2.getOutline().setFill(new zzYvg());
        zzZkc2.getOutline().setEndCap(0);
        zzZkc2.getOutline().zzWWa(19050.0);
        chartSeries.zzZCV().zzXPk().zz4W(5, zzZkc2);
    }

    private static void zzXQZ(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzYch());
        chartMarker.zzVZn().zz4W(0, n);
        chartSeries.zzZCV().zzXPk().zz4W(4, chartMarker);
    }

    private static zzAc zzw1(double[] dArray) {
        int n = 0;
        zzAc zzAc2 = new zzAc(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzAc2.zz9U(new zzXU4(n, d, "General"));
            }
            ++n;
        }
        zzAc2.zzZDM(dArray.length);
        return zzAc2;
    }

    private static zzAc zzXQZ(zzhd[] zzhdArray) {
        int n = 0;
        zzAc zzAc2 = new zzAc(2);
        zzhd[] zzhdArray2 = zzhdArray;
        int n2 = zzhdArray.length;
        for (int i = 0; i < n2; ++i) {
            zzhd zzhd2 = zzhdArray2[i];
            zzAc2.zz9U(new zzXU4(n++, zzhd2.zzZTz(), "m/d/yyyy"));
        }
        zzAc2.zzZDM(zzhdArray.length);
        return zzAc2;
    }

    private static zzAc zzXUb(String[] stringArray) {
        int n = 0;
        zzAc zzAc2 = new zzAc(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzAc2.zz9U(new zzZ3(n++, string));
        }
        zzAc2.zzZDM(stringArray.length);
        return zzAc2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZ9n().zzZSF().size();
    }

    private zzXHH zzZ9n() {
        return this.zzZBo.zzWy5().zzZ9n();
    }
}

