/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzWLV;
import com.aspose.words.internal.zzZ3F;
import com.aspose.words.internal.zzhd;
import com.aspose.words.zzG8;
import com.aspose.words.zzWiz;
import com.aspose.words.zzXLt;
import com.aspose.words.zzXaK;
import com.aspose.words.zzY59;
import com.aspose.words.zzYfQ;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzG8,
zzXLt {
    private int zzYoK;
    private boolean zzWrA;
    private boolean zzLx;
    private int zzX9K;
    private int zzXHO = -1;
    private String zzZL1 = "";
    private String zzMe = "";
    private zzhd zzWa = zzhd.zzlc;
    private zzhd zzjx = zzhd.zzlc;
    private CommentCollection zzWb9;

    Comment(DocumentBase doc, zzYfQ runPr) {
        super(doc, runPr);
        this.zzX9K = doc.zzPq();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzhd.zzlc);
    }

    private Comment(DocumentBase doc, String author, String initial, zzhd dateTime) {
        this(doc, new zzYfQ());
        this.setAuthor(author);
        this.setInitial(initial);
        zzhd zzhd2 = dateTime;
        Comment comment = this;
        this.zzWa = zzhd2;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzhd.zzXQZ(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzX9K;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.zzX9K;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.zzX9K = value;
        if (this.getDocument() != null) {
            this.getDocument().zzp4();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        Comment comment = this;
        return comment.zzXHO;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.zzIL(value);
    }

    public final String getInitial() {
        return this.zzZL1;
    }

    public final void setInitial(String value) {
        zzZ3F.zzfO((Object)value, "Initial");
        this.zzZL1 = value;
    }

    final zzhd zzVXT() {
        return this.zzWa;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzhd.zzWTj(comment.zzWa);
    }

    final void zzdK(zzhd zzhd2) {
        this.zzWa = zzhd2;
    }

    public final void setDateTime(Date value) {
        zzhd zzhd2 = zzhd.zzXQZ(value);
        Comment comment = this;
        this.zzWa = zzhd2;
    }

    final zzhd zzVZY() {
        return this.zzjx;
    }

    final void zzZiw(zzhd zzhd2) {
        this.zzjx = zzhd2;
    }

    public final String getAuthor() {
        return this.zzMe;
    }

    public final void setAuthor(String value) {
        zzZ3F.zzfO((Object)value, "Author");
        this.zzMe = value;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzXQZ(String string, String string2, zzhd zzhd2, String string3) throws Exception {
        Comment comment = this;
        if (comment.zzXHO != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment2 = new Comment(this.getDocument(), string, string2, zzhd2);
        comment2.setIdInternal(zzXaK.zzXQZ(this.getDocument()));
        comment2.zzIL(this.zzX9K);
        comment2.setText(string3);
        Comment comment3 = this;
        Comment comment4 = zzZ3F.zzXQZ((Object)this.zzl3(), Comment.class);
        while (comment4 != null) {
            comment = comment4;
            if (comment.zzXHO != this.zzX9K) break;
            comment3 = comment4;
            comment4 = zzZ3F.zzXQZ((Object)comment4.zzl3(), Comment.class);
        }
        this.getParentNode().insertAfter(comment2, comment3);
        zzY59 zzY592 = new zzY59();
        if (zzY592.zzfO(this.getDocument(), this.zzX9K)) {
            this.zzXQZ(zzY592.zzY1t(), new CommentRangeStart(this.getDocument(), comment2.getId()));
            this.zzXQZ(zzY592.zzYoO(), new CommentRangeEnd(this.getDocument(), comment2.getId()));
        }
        return comment2;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzXQZ(author, initial, zzhd.zzXQZ(dateTime), text);
    }

    private void zzXQZ(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzWLV.zzXQZ(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeStart2, (Node)object);
    }

    private void zzXQZ(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzWLV.zzXQZ(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzX9K) break;
            object = node;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeEnd2, (Node)object);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzY59 zzY592 = new zzY59();
        if (zzY592.zzfO(this.getDocument(), reply.getId())) {
            zzY592.zzY1t().remove();
            zzY592.zzYoO().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zz8M()) {
            this.removeReply(comment);
        }
    }

    @Override
    final int zzXQZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCommentStart(this);
    }

    @Override
    final int zzfO(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzM());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzM(), '\u0005', new zzYfQ());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        Comment comment;
        block4: {
            block3: {
                if (this.getDocument() == null) break block3;
                comment = this;
                if (comment.zzXHO != -1) break block4;
            }
            return null;
        }
        for (Comment comment2 : this.getDocument().getChildNodes(19, true)) {
            comment = this;
            if (comment2.getId() != comment.zzXHO) continue;
            return comment2;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzWb9 == null) {
            this.zzWb9 = new CommentCollection(this.getDocument(), this);
        }
        return this.zzWb9;
    }

    public final boolean getDone() {
        return this.zzLx;
    }

    public final void setDone(boolean value) {
        this.zzLx = value;
    }

    final int zzZpw() {
        return this.zzXHO;
    }

    final void zzIL(int n) {
        this.zzXHO = n;
        if (this.getDocument() != null) {
            this.getDocument().zzp4();
        }
    }

    final int zzvK() {
        return this.zzYoK;
    }

    final void zztF(int n) {
        this.zzYoK = n;
    }

    final boolean zzh1() {
        return this.zzWrA;
    }

    final void zzZJF(boolean bl) {
        this.zzWrA = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzWiz getMoveFromRevision() {
        return this.zzQ().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzWiz value) {
        zzWiz zzWiz2 = value;
        zzYfQ zzYfQ2 = this.zzQ();
        zzYfQ2.zzXf9(13, zzWiz2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzWiz getMoveToRevision() {
        return this.zzQ().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzWiz value) {
        zzWiz zzWiz2 = value;
        zzYfQ zzYfQ2 = this.zzQ();
        zzYfQ2.zzXf9(15, zzWiz2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzQ().remove(13);
        this.zzQ().remove(15);
    }

    final String zzZQK() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZvc(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

