/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZ3F;
import com.aspose.words.zzGr;
import com.aspose.words.zzVWN;
import com.aspose.words.zzWcA;
import com.aspose.words.zzXCL;
import com.aspose.words.zzXCP;
import com.aspose.words.zzXi4;
import com.aspose.words.zzZhJ;
import com.aspose.words.zzZjz;
import com.aspose.words.zztv;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzGr,
Iterable<T> {
    private Node zzXuT;
    private Node zzZeS;
    private Node zzVVg;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzVWN zzVWN2 = new zzVWN(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzZfH((Node)this, true);
            return;
        }
        finally {
            zzVWN2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzYsk() {
        return this.zzYxk() != null;
    }

    final boolean zzW3L() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzZFa() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzZjz) {
                return true;
            }
            CompositeNode compositeNode = zzZ3F.zzXQZ((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzZFa()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzXuT;
    }

    public Node getLastChild() {
        return this.zzZeS;
    }

    final Node zzYxk() {
        return zztv.zz9U(this.getFirstChild(), false);
    }

    final Node zzW5T() {
        return zztv.zzYe3(this.getLastChild(), false);
    }

    final CompositeNode zzYDi() {
        return (CompositeNode)zztv.zz9U(this.getFirstChild(), true);
    }

    final CompositeNode zztY() {
        return (CompositeNode)zztv.zzYe3(this.getLastChild(), true);
    }

    final Node zzYgH() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zztv.zzBI((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zz0G() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zztv.zzBI((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXQZ(boolean bl, zzZhJ zzZhJ2) {
        CompositeNode compositeNode = (CompositeNode)super.zzXQZ(bl, zzZhJ2);
        ((CompositeNode)super.zzXQZ(bl, zzZhJ2)).zzZeS = null;
        compositeNode.zzXuT = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzVX9(node.zzXQZ(true, zzZhJ2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZvc(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZvc(StringBuilder stringBuilder) {
        this.zzXsA(stringBuilder);
        zzZ3F.zzfO(stringBuilder, this.zzWs0());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzfO(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zztv.zzX0p(nodeType);
            Node node2 = node = bl ? this.zzYxk() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzYai() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXCL.zzZfH(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXCL.zzXRc(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXi4(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzXQZ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzXQZ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzZfH(oldChild, false);
    }

    private Node zzZfH(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzXQZ(node, (Node)this, null, 1);
        if (documentBase.zzWrW() && zztv.zzYA5(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzXQZ(nodeChangingArgs);
        }
        if (!bl && zztv.zzWa(node)) {
            zztv.zzYhu(node, false);
        }
        Node node2 = this.zzYAS(node);
        if (nodeChangingArgs != null) {
            documentBase.zzfO(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzWcA.zzIJ(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzVX9(Node node) {
        node.getParentNode();
        if (this.zzZeS == null) {
            node.zzYjS(null);
            node.zzXEW(null);
            this.zzXuT = node;
        } else {
            node.zzYjS(this.zzZeS);
            node.zzXEW(null);
            this.zzZeS.zzXEW(node);
        }
        this.zzZeS = node;
        node.zzVQS(this);
        return node;
    }

    final void zzXQZ(Node node, Node node2, Node node3) {
        this.zzXQZ(node, node2, node3, false);
    }

    final void zzXQZ(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzw1(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzfO(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzXRc(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zztv.zzBI(node3.getNodeType())) continue;
            if (zztv.zzw1(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzWs0().length();
    }

    String zzWs0() {
        return "";
    }

    final String zzVWm() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXsA(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzXsA(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZvc(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzXQZ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzfO(visitor));
    }

    abstract int zzXQZ(DocumentVisitor var1) throws Exception;

    abstract int zzfO(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzw1(Node var1);

    final Node zzXQZ(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzvw(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzw1(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzXCP(documentBase);
            try {
                compositeNode.zzZfH(node, true);
            }
            finally {
                ((zzXCP)object).dispose();
            }
        }
        if ((object = documentBase.zzXQZ(node, null, (Node)this, 0)) != null) {
            documentBase.zzXQZ((NodeChangingArgs)object);
        }
        if (this.zzZeS == null) {
            node.zzYjS(null);
            node.zzXEW(null);
            this.zzXuT = node;
            this.zzZeS = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzfO(node, node2);
            } else {
                this.zzZfH(node, this.zzXuT);
            }
        } else if (node2 != null) {
            this.zzZfH(node, node2);
        } else {
            this.zzfO(node, this.zzZeS);
        }
        node.zzVQS(this);
        if (object != null) {
            documentBase.zzfO((NodeChangingArgs)object);
        }
        if (documentBase.zzWrW()) {
            zztv.zzXQZ(node, compositeNode, node3);
        }
        return node;
    }

    private void zzfO(Node node, Node node2) {
        Node node3 = node2.zzWOo();
        node.zzYjS(node2);
        node.zzXEW(node3);
        node2.zzXEW(node);
        if (node3 == null) {
            this.zzZeS = node;
            return;
        }
        node3.zzYjS(node);
    }

    private void zzZfH(Node node, Node node2) {
        Node node3 = node2.zzVTF();
        node.zzYjS(node3);
        node.zzXEW(node2);
        node2.zzYjS(node);
        if (node3 == null) {
            this.zzXuT = node;
            return;
        }
        node3.zzXEW(node);
    }

    private Node zzYAS(Node node) {
        if (node == this.zzXuT) {
            if (this.zzXuT == this.zzZeS) {
                this.zzXuT = null;
                this.zzZeS = null;
            } else {
                this.zzXuT = node.zzWOo();
                this.zzXuT.zzYjS(null);
            }
        } else {
            Node node2 = node.zzVTF();
            Node node3 = node.zzWOo();
            node2.zzXEW(node3);
            if (node3 == null) {
                this.zzZeS = node2;
            } else {
                node3.zzYjS(node2);
            }
        }
        node.zzXEW(null);
        node.zzYjS(null);
        node.zzVQS(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzVVg = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzVVg;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

