/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzWAt;
import com.aspose.words.internal.zzXSL;
import com.aspose.words.internal.zzXYK;
import com.aspose.words.internal.zzY5u;
import com.aspose.words.internal.zzYIU;
import com.aspose.words.internal.zzYax;
import com.aspose.words.internal.zzZ3F;
import com.aspose.words.internal.zzZ6v;
import com.aspose.words.internal.zzZM1;
import com.aspose.words.internal.zzZyY;
import com.aspose.words.internal.zzsV;
import com.aspose.words.zzW8j;
import com.aspose.words.zzWMD;
import com.aspose.words.zzX0y;
import com.aspose.words.zzY0S;
import com.aspose.words.zzYD5;
import com.aspose.words.zzYY0;
import com.aspose.words.zzYhh;
import com.aspose.words.zzYnB;
import com.aspose.words.zzYox;
import com.aspose.words.zzYuE;
import com.aspose.words.zzYzs;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXQZ(zzYIU zzYIU2, zzYIU zzYIU3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZ3F.zzfO((Object)zzYIU2, "srcStream");
        zzZ3F.zzfO((Object)zzYIU3, "dstStream");
        zzZ3F.zzfO((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzfO(zzYIU2, zzYIU3, certificateHolder, signOptions);
        zzYIU3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXQZ(zzYIU.zzfO(srcStream), (zzYIU)zzYIU.zzZfH(dstStream), certHolder, signOptions);
    }

    private static void zzfO(zzYIU zzYIU2, zzYIU zzYIU3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZfH(digitalSignature);
        }
        if (zzYD5.zzWzB(zzYIU2)) {
            DigitalSignatureUtil.zzXQZ(zzYIU2, zzYIU3, digitalSignature, true);
            return;
        }
        zzYD5 zzYD52 = new zzYD5();
        zzYIU zzYIU4 = zzYIU2;
        zzYD5 zzYD53 = zzYD52;
        FileFormatInfo fileFormatInfo = zzYD52.zzfO(zzYIU4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXSL zzXSL2 = new zzXSL(zzYIU2);
                int n = fileFormatInfo.zzYha() == 1 ? 1 : 2;
                zzWMD.zzXQZ(zzXSL2, digitalSignature, n);
                zzYIU3.zzYAS(0L);
                zzXSL2.zzXsA(zzYIU3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXQZ(fileFormatInfo.zzWK3(), zzYIU3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXQZ(zzYIU2, zzYIU3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzXQZ(zzYIU2, zzYIU3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZ3F.zzZfH(srcFileName, "srcFileName");
        zzZ3F.zzZfH(dstFileName, "dstFileName");
        try (com.aspose.words.internal.zzYD5 zzYD52 = zzZ3F.zzfO(srcFileName, 3, 1);){
            try (com.aspose.words.internal.zzYD5 zzYD53 = zzZ3F.zzfO(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXQZ((zzYIU)zzYD52, (zzYIU)zzYD53, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYax zzYax2 = zzYIU.zzZfH(dstStream);
        zzYIU zzYIU2 = zzYIU.zzfO(srcStream);
        DigitalSignatureUtil.zzXQZ(zzYIU2, (zzYIU)zzYax2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (com.aspose.words.internal.zzYD5 zzYD52 = zzZ3F.zzfO(srcFileName, 3, 1);){
            try (com.aspose.words.internal.zzYD5 zzYD53 = zzZ3F.zzfO(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzuZ(zzYD52, zzYD53);
            }
            return;
        }
    }

    private static void zzuZ(zzYIU zzYIU2, zzYIU zzYIU3) throws Exception {
        zzYD5 zzYD52 = new zzYD5();
        zzYIU zzYIU4 = zzYIU2;
        Object object = zzYD52;
        FileFormatInfo fileFormatInfo = zzYD52.zzfO(zzYIU4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXSL zzXSL2 = new zzXSL(zzYIU2);
                zzXSL2.zzWyS().zzWrv("_xmlsignatures");
                zzXSL2.zzWyS().zzWrv("_signatures");
                zzYIU3.zzVSY(0L);
                zzXSL2.zzXsA(zzYIU3);
                zzYIU zzYIU5 = zzYIU3;
                zzYIU5.zzYAS(zzYIU5.zzYT0());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZM1 zzZM12 = new zzZM1(zzYIU2);
                zzZyY zzZyY2 = zzZM12.zzXQZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzZyY2 != null) {
                    for (zzZ6v zzZ6v2 : zzZyY2.zzZO8()) {
                        String string = zzZyY2.zzXQZ(zzZ6v2);
                        zzZM12.zzN3().remove(string);
                    }
                    zzZM12.zzN3().remove(zzZyY2.getName());
                    zzZ6v zzZ6v3 = zzZM12.zzZO8().zzXxD("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZM12.zzZO8().remove(zzZ6v3.getId());
                    zzZM12.zzWA8();
                }
                zzYIU3.zzVSY(0L);
                zzZM12.zzXsA(zzYIU3);
                zzYIU zzYIU6 = zzYIU3;
                zzYIU6.zzYAS(zzYIU6.zzYT0());
                return;
            }
            case 60: 
            case 61: {
                zzY0S zzY0S2 = new zzY0S(zzYIU2);
                zzX0y zzX0y2 = zzY0S2.zz2j("/META-INF/documentsignatures.xml");
                if (zzX0y2 != null) {
                    zzY0S2.zzYEa().remove(zzX0y2.getName());
                }
                zzYIU3.zzVSY(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzYIU4 = zzYIU3;
                object = zzY0S2;
                ((zzY0S)object).zzXQZ(zzYIU4, string, null);
                zzYIU zzYIU7 = zzYIU3;
                zzYIU7.zzYAS(zzYIU7.zzYT0());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzuZ(zzYIU.zzfO(srcStream), zzYIU.zzZfH(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (com.aspose.words.internal.zzYD5 zzYD52 = zzZ3F.zzfO(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzXQR(zzYD52);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzXQR(zzYIU zzYIU2) throws Exception {
        if (zzYD5.zzWzB(zzYIU2)) {
            return DigitalSignatureUtil.zzWdb(zzYIU2);
        }
        zzYD5 zzYD52 = new zzYD5();
        zzYIU zzYIU3 = zzYIU2;
        zzYD5 zzYD53 = zzYD52;
        FileFormatInfo fileFormatInfo = zzYD52.zzfO(zzYIU3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzYIU2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzXQR(zzYIU.zzfO(stream));
    }

    static zzY5u zzXQZ(zzXSL zzXSL2, String string) throws Exception {
        zzYox zzYox2 = new zzYox(zzXSL2);
        if (zzYox2.zz8Y()) {
            zzY5u zzY5u2 = zzYox2.zzZKo(string);
            return zzY5u2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzZfc(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzWAt.zzfO("Unexpected digest algorithm: {0}.", n));
    }

    static String zzZNj(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzZfc(n);
    }

    private static void zzXQZ(zzYIU zzYIU2, zzYIU zzYIU3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZM1 zzZM12 = new zzZM1(zzYIU2);
        zzYnB zzYnB2 = bl ? new zzYhh(zzZM12) : new zzW8j(zzZM12);
        zzYnB2.zzfO(digitalSignature);
        zzYIU3.zzYAS(0L);
        zzZM12.zzXsA(zzYIU3);
    }

    private static void zzXQZ(zzYIU zzYIU2, zzYIU zzYIU3, DigitalSignature digitalSignature) throws Exception {
        zzY0S zzY0S2 = new zzY0S(zzYIU2);
        zzYuE zzYuE2 = new zzYuE(zzY0S2);
        zzYuE2.zzfO(digitalSignature);
        zzYIU3.zzYAS(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzYIU zzYIU4 = zzYIU3;
        zzY0S zzY0S3 = zzY0S2;
        zzY0S3.zzXQZ(zzYIU4, string, null);
    }

    private static void zzXQZ(zzXSL zzXSL2, zzYIU zzYIU2, DigitalSignature digitalSignature, String string) throws Exception {
        zzY5u zzY5u2 = DigitalSignatureUtil.zzXQZ(zzXSL2, string);
        zzY5u zzY5u3 = new zzY5u();
        DigitalSignatureUtil.zzXQZ((zzYIU)zzY5u2, (zzYIU)zzY5u3, digitalSignature, false);
        zzXSL zzXSL3 = zzYox.zzuZ(zzY5u3, string);
        zzXSL3.zzXsA(zzYIU2);
    }

    private static DigitalSignatureCollection zzWdb(zzYIU zzYIU2) throws Exception {
        zzYIU2.zzVSY(0L);
        zzZM1 zzZM12 = new zzZM1(zzYIU2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzZyY zzZyY2 = zzZM12.zzXQZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzZyY2 != null) {
            for (zzZ6v zzZ6v2 : zzZyY2.zzZO8()) {
                String string = zzZyY2.zzXQZ(zzZ6v2);
                zzZyY zzZyY3 = zzZM12.zzXaK(string);
                zzZyY zzZyY4 = zzZM12.zzXQZ(zzZyY3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzsV zzsV2 = zzXYK.zzYJT(zzZyY4.zzZ5X().zzWR0());
                zzYzs.zzXQZ(zzZyY3.zzYIU(), zzsV2, new zzYY0(zzZM12), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

