/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzUJ;
import com.aspose.words.internal.zzWAt;
import com.aspose.words.internal.zzWEs;
import com.aspose.words.internal.zzWHy;
import com.aspose.words.internal.zzWRZ;
import com.aspose.words.internal.zzWrF;
import com.aspose.words.internal.zzWvT;
import com.aspose.words.internal.zzX00;
import com.aspose.words.internal.zzX1m;
import com.aspose.words.internal.zzX5P;
import com.aspose.words.internal.zzXMi;
import com.aspose.words.internal.zzXaQ;
import com.aspose.words.internal.zzY5u;
import com.aspose.words.internal.zzYF0;
import com.aspose.words.internal.zzYIU;
import com.aspose.words.internal.zzZ3F;
import com.aspose.words.internal.zzZNl;
import com.aspose.words.internal.zzZbV;
import com.aspose.words.zz4U;
import com.aspose.words.zz89;
import com.aspose.words.zzMy;
import com.aspose.words.zzVPR;
import com.aspose.words.zzWYU;
import com.aspose.words.zzWl5;
import com.aspose.words.zzWvo;
import com.aspose.words.zzX0x;
import com.aspose.words.zzX4d;
import com.aspose.words.zzXCP;
import com.aspose.words.zzXiJ;
import com.aspose.words.zzXje;
import com.aspose.words.zzXjr;
import com.aspose.words.zzXks;
import com.aspose.words.zzXpU;
import com.aspose.words.zzXra;
import com.aspose.words.zzXw6;
import com.aspose.words.zzY8R;
import com.aspose.words.zzY96;
import com.aspose.words.zzYG1;
import com.aspose.words.zzYHC;
import com.aspose.words.zzYMN;
import com.aspose.words.zzYT3;
import com.aspose.words.zzYUw;
import com.aspose.words.zzYfQ;
import com.aspose.words.zzYkk;
import com.aspose.words.zzYre;
import com.aspose.words.zzYs4;
import com.aspose.words.zzYsU;
import com.aspose.words.zzYz2;
import com.aspose.words.zzZ4b;
import com.aspose.words.zzZDU;
import com.aspose.words.zzZIr;
import com.aspose.words.zzZXF;
import com.aspose.words.zzZq8;
import com.aspose.words.zzZyP;
import com.aspose.words.zza1;
import com.aspose.words.zzbj;
import com.aspose.words.zzmO;
import com.aspose.words.zzmS;
import com.aspose.words.zztF;
import com.aspose.words.zztv;
import com.aspose.words.zzw0;
import com.aspose.words.zzy7;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzXje,
zzYT3,
zzYUw,
zzmO {
    private Document zzY1P;
    private Node zzXWO;
    private Node zzWpu;
    private zzYfQ zzXtw;
    private Font zzXlF;
    private zzZbV<zzYfQ> zzX3;
    private zzZbV<zzy7> zzWw7;
    private zzZbV<zzXQZ> zzZnI;
    private zzXw6 zzW0X = zzXw6.zzXRJ();
    private zzXiJ zzWhY = new zzXiJ();
    private zzy7 zzXAs;
    private RowFormat zzZke;
    private CellFormat zzXl4;
    private ParagraphFormat zzZUj;
    private zzZbV<zzbj> zzWjk;
    private int zzWa5 = 0;
    private int zzWNv = -1;
    private int zzJc;
    private boolean zzXRg;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzYe3(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzYe3(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzYe3(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXQZ(documentBuilder.getCurrentSection(), zza1.zzYIM(headerFooterType), 0, 0);
    }

    private void zzYe3(int n, int n2, int n3, int n4) {
        this.zzY1P.ensureMinimum();
        Section section = (Section)this.zzY1P.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXQZ(section, 1, n3, n4);
    }

    private void zzXQZ(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zza1.zzjK(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzY1P, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzY1P));
            }
        }
        this.zzXQZ(story, n2, n3);
    }

    private void zzXQZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXQZ((CompositeNode)paragraph2, n3);
    }

    final void zzXQZ(Paragraph paragraph, int n) {
        this.zzXQZ((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXJO().zzYA2() ? zz4U.zzXrG(this.zzY1P, fieldName) : zz4U.zzZzs(this.zzXJO(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXQZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXQZ(field, isAfter, false);
    }

    private boolean zzXQZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZXF zzZXF2 = field.getFormat().zzW4o();
        Inline inline = zzZXF2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXQZ(inline.zzQ(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzVPR.zzXQZ(this.zzY1P, bookmarkName) : zzVPR.zzfO(this.zzY1P, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzYnF() == 6) {
            this.zzXQZ(node.zzW1v(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zztv.zzoh(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXQZ((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXQZ(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzfO(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzXQZ(structuredDocumentTag);
            return;
        }
        this.zzZfH(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzWLd(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzXQZ((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzYnF() == 6) {
            this.zzYZy(node);
        } else {
            Node node2 = node;
            if (zztv.zzBI(node2.getNodeType())) {
                Paragraph paragraph = zztv.zzoh(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzYZy(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzYnF() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzYZy(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzJc = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzYMH();
            return;
        }
        if (!this.zzWDF()) {
            this.zzYMH();
        }
    }

    private void zzXQZ(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzWDF() {
        Node node = this.zzXJO();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzXJO().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXQZ(((StructuredDocumentTag)documentBuilder.zzXJO().getParentNode()).zzWMH(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzXJO(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXQZ(inline.zzQ(), true);
            return true;
        }
        return false;
    }

    private void zzYMH() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXQZ(documentBuilder.getCurrentParagraph().zzWOK(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzWLd(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzX33() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXJO().zzvw(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZfS();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXQZ((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzZiw(text, false);
    }

    public void writeln(String text) {
        this.zzZiw(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzXJO() != null && this.zzXJO().zzYnF() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzXJO().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzZfO();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzXCP zzXCP2 = new zzXCP(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzY1P, this.zzYnp(), this.zzWwG());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzfO(this.zzXJO(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzXCP2.dispose();
        }
        if (this.getDocument().zzWrW()) {
            zztv.zzZfH((zzYz2)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzYL6());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzYc1() {
        zzYfQ zzYfQ2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzZfO();
        Node node = this.zzXJO();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzo8(false);
        } else {
            run2 = run = (Run)node.zzWTW(21);
        }
        if (run2 == null && zzZ3F.zz4W(node, paragraph.zzWyf())) {
            run = paragraph.zzWyf();
        }
        if (run != null) {
            cloneable = run.zzQ();
            zzYfQ2 = (zzYfQ)((zzMy)cloneable).zzXV9();
        } else {
            cloneable = paragraph.zzWOK();
            zzYfQ2 = (zzYfQ)((zzMy)cloneable).zzXV9();
        }
        zzYfQ zzYfQ3 = zzYfQ2;
        Paragraph paragraph2 = new Paragraph(this.zzY1P, this.zzYnp(), zzYfQ3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzXCP zzXCP2 = new zzXCP(this.zzY1P);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzfO(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzXCP2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXks.zzXrG(this);
    }

    public void insertBreak(int breakType) {
        this.zzZPz(breakType, true);
    }

    final void zzZPz(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzZPl(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzWuM(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzXX1())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzZPl(bl)) {
                        this.zzWuM(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzZPl(bl)) {
                        this.zzZM0(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzZPl(bl)) {
                        this.zzZM0(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzZPl(bl)) {
                        this.zzZM0(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzZPl(bl)) {
                        this.zzZM0(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzZPl(bl)) {
                        this.zzZM0(4);
                    }
                    return;
                }
                case 8: {
                    this.zzWuM(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzUJ.zzXlr(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzWAt.zzfO("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzZfO();
        return zztv.zzXQZ(fieldType, updateField, this.zzWwG(), this.zzXL7(), this.zz2r(), this.zz2r() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzZfO();
        return zztv.zzXQZ(fieldCode, this.zzWwG(), this.zzXL7(), this.zz2r(), this.zz2r() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzZfO();
        return zztv.zzXQZ(fieldCode, fieldValue, this.zzWwG(), this.zzXL7(), this.zz2r(), this.zz2r() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZ3F.zzfO((Object)displayText, "displayText");
        zzZ3F.zzfO((Object)urlOrBookmark, "hrefOrBookmark");
        zzXra zzXra2 = this.zzfO(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzXra2.zzZfH(documentBuilder.zzWeI(88, true));
        return zztv.zzXQZ(zzXra2.getStart(), zzXra2.getSeparator(), zzXra2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzWXk(70);
        if (zzUJ.zzXlr(name)) {
            this.startBookmark(name);
        }
        this.zzWXo(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzWs5(70);
        String string = zzUJ.zzXlr(fieldValue) ? fieldValue : FormField.zzZ1k;
        Run run = new Run(this.zzY1P, string, this.zzWwG());
        this.insertNode(run);
        Node node = this.zzWeI(70, true);
        if (zzUJ.zzXlr(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzXYg(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzXQZ((CompositeNode)((Paragraph)node.zzW1v()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzWXk(71);
        if (zzUJ.zzXlr(name)) {
            this.startBookmark(name);
        }
        this.zzWXo(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzWeI(71, false);
        if (zzUJ.zzXlr(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXYg(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzWXk(83);
        if (zzUJ.zzXlr(name)) {
            this.startBookmark(name);
        }
        this.zzWXo(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzWeI(83, false);
        if (zzUJ.zzXlr(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXYg(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzY1P, footnoteType, !zzUJ.zzXlr(referenceMark), referenceMark, this.zzWwG());
        Style style = this.getDocument().getStyles().zzYjg(zztv.zzWe6(footnoteType));
        footnote.zzQ().set(50, style.zz9s());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzY1P);
        Style style2 = this.getDocument().getStyles().zzYjg(zztv.zzXrr(footnoteType));
        paragraph.zzZwo().set(1000, style2.zz9s());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzY1P, '\u0002', new zzYfQ()) : new Run(this.zzY1P, footnote.getReferenceMark(), new zzYfQ());
        inline.zzQ().set(50, style.zz9s());
        paragraph.appendChild(inline);
        if (zzUJ.zzXlr(footnoteText)) {
            Node node = this.zzXJO();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYZy(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzYQT(zzYIU zzYIU2) throws Exception {
        return this.zzXQZ(zzYIU2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzYQT(zzYIU.zzfO(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXQZ(zzYIU zzYIU2, double d, double d2) throws Exception {
        return this.zzXQZ(zzYIU2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXQZ(zzYIU.zzfO(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        try (zzY5u zzY5u2 = new zzY5u();){
            zzYF0.zzfO(image, zzY5u2);
            Shape shape = this.zzXQZ(zzY5u2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZ3F.zzZfH(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzZNl.zzLq(fileName);
        try {
            Shape shape = this.zzXQZ((zzYIU)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzYIU)object).close();
            }
        }
    }

    private Shape zzXQZ(zzYIU zzYIU2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzYIU2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzZ3F.zzXrG(zzYIU2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXQZ(zzYIU.zzfO(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXQZ(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzXQZ(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzWrF.zzXe1(object)) {
            object4 = new zzYF0((byte[])object);
            bl2 = true;
            ((zzWHy)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzY1P.getCompatibilityOptions().getMswVersion() > 12 || this.zzY1P.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzY1P, 0);
            object3 = new zzWl5();
            ((zzZyP)object3).zzXQZ(zzZIr.zzC1("rect"));
            ((zzWl5)object3).zzXQZ(new zzYG1());
            ((zzWl5)object3).zzza().zzZOE().zzZfH(this.zzY1P);
            object2 = new zzWYU();
            ((zzZ4b)object2).zzfO(new zzX0x(this.zzY1P.zzUf(), ""));
            ((zzZ4b)object2).zzXQZ(new zztF());
            ((zzw0)object3).zzXQZ((zzZ4b)object2);
            shape.setShapeType(75);
            shape.zzw1((zzw0)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzY1P, 75);
        }
        if (zzWrF.zzko(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzXQZ((byte[])object, new zzYs4(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzYs4(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzWrF.zzWKN((byte[])object2));
                this.zzXQZ((zzWl5)shape.zzZak(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzWl5)shape.zzZak()).zzza().zzZOE().zzOq((byte[])object);
            object3 = zzWrF.zzWa8(object);
            object4 = new zzYs4(((zzWRZ)object3).getWidthPoints(), ((zzWRZ)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzfO(this.zzWwG());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzWrF.zzYeh(object)) {
            d5 = DocumentBuilder.zzXQZ(shape, object);
        }
        shape.zzXQZ(d3, d4, (zzYs4)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzXQZ(Shape shape, byte[] byArray) throws Exception {
        int n = zzWrF.zzZ3b(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zztv.zzX8T(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zztv.zzY65(n);
        return d;
    }

    private void zzXQZ(zzWl5 zzWl52, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzWl52.zzza().zzZOE().getExtensions();
        try (zzY5u zzY5u2 = new zzY5u(byArray);){
            object = zztv.zzXQZ(zzY5u2, this.zzY1P);
            ((zzYMN)object).zzVz(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzYMN)object).zzX0I();
            byArray2 = ((zzYMN)object).zzXNo(true);
        }
        zzWl52.zzza().zzZOE().setExtensions(new zzX00<zzYHC>());
        object = zzYHC.zzXQZ(byArray2, this.zzY1P);
        zzWl52.zzza().zzZOE().getExtensions().zzuZ(((zzYHC)object).getUri(), (zzYHC)object);
    }

    private Shape zzXQZ(zzYIU zzYIU2, String string, boolean bl, zzYIU zzYIU3) throws Exception {
        zz89 zz892 = zz89.zzWjP(string);
        Shape shape = this.zzXQZ(zzYIU3, bl, zz892, null);
        zzXpU zzXpU2 = zzY8R.zzXQZ(zzYIU2, string, bl);
        return DocumentBuilder.zzXQZ(null, false, shape, zz892.zzWFx, zzXpU2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXQZ(zzYIU.zzfO(stream), progId, asIcon, zzYIU.zzfO(presentation));
    }

    private Shape zzXQZ(String string, boolean bl, boolean bl2, zzYIU zzYIU2) throws Exception {
        zz89 zz892 = zz89.zzW7w(zzWEs.zzub(string));
        return this.zzXQZ(string, bl, bl2, zzYIU2, zz892);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXQZ(fileName, isLinked, asIcon, zzYIU.zzfO(presentation));
    }

    private Shape zzXQZ(String string, String string2, boolean bl, boolean bl2, zzYIU zzYIU2) throws Exception {
        zz89 zz892 = zz89.zzWjP(string2);
        return this.zzXQZ(string, bl, bl2, zzYIU2, zz892);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXQZ(fileName, progId, isLinked, asIcon, zzYIU.zzfO(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zz89 zz892 = zz89.zzW7w(zzWEs.zzub(fileName));
        return this.zzXQZ(fileName, isLinked, iconFile, iconCaption, zz892);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zz89 zz892 = zz89.zzWjP(progId);
        return this.zzXQZ(fileName, isLinked, iconFile, iconCaption, zz892);
    }

    private Shape zzfO(zzYIU zzYIU2, String string, String string2, String string3) throws Exception {
        zz89 zz892 = zz89.zzWjP(string);
        Shape shape = this.zzXQZ(string2, string3, zz892);
        zzXpU zzXpU2 = zzY8R.zzXQZ(zzYIU2, string, true);
        return DocumentBuilder.zzXQZ(null, false, shape, zz892.zzWFx, zzXpU2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzfO(zzYIU.zzfO(stream), progId, iconFile, iconCaption);
    }

    final Shape zzXQZ(zzYre zzYre2, zzYIU zzYIU2) throws Exception {
        Shape shape = this.zz6f(zzYIU2);
        shape.setShapeType(201);
        shape.setShapeAttr(4112, zzYre2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzZfO();
        if (this.zzVRh()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzZmj(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzXjr zzXjr2 = zztv.zzXQZ(html, options, this);
        zzXjr2.zzZq5();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzZfO();
        return zztv.zzXQZ(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzZfO();
        return zztv.zzXQZ(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzYkk zzYkk2 = new zzYkk();
        return zzYkk2.zzXQZ(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWvo(this).zzXQZ(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWvo(this).zzXQZ(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzY1P, 75);
        shape.zzfO(this.zzWwG());
        shape.zzXPn(true);
        shape.getSignatureLine().zzXQZ(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXYF(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zziU(this.zzY1P);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzVRh() {
        boolean bl = false;
        if (this.zzXJO().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXJO().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzZmj(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzZfO();
        if (this.zzX33() == null) {
            this.startTable();
        }
        if (this.zzX33().zzYZW() == 1) {
            this.zzX33().zzXr7();
        }
        if (this.zzX33().zzYZW() == 3) {
            this.zzX33().zzZUT();
        }
        return this.zzX33().zzG2();
    }

    public Table startTable() {
        this.zzWjk.push(new zzbj(this));
        return this.zzX33().startTable();
    }

    public Table endTable() {
        if (this.zzX33() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzX33().endTable();
        this.zzWjk.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzX33() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzX33().endRow();
        if (this.zzXlF != null && this.zzXlF.getHidden()) {
            row.zz3p().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzY1P, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzY1P, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYQ5();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzY1P, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzY6T();
        bookmarkStart.zzC1(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYQ5();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzY6T();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzY1P, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzYhw(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzY1P);
        this.zzWNv = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzWNv == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzY1P, this.zzWNv);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzY1P, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZ3F.zzfO((Object)importFormatOptions, "ImportFormatOptions");
        this.zzZfO();
        return zzmS.zzXQZ(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzY1P;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzY1P) {
            return;
        }
        this.zzY1P = value;
        this.zzYZy(null);
        this.zzXtw = new zzYfQ();
        this.zzX3 = null;
        this.zzWw7 = null;
        this.zzXlF = null;
        this.zzWjk = new zzZbV();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzXlF == null) {
            DocumentBuilder documentBuilder = this;
            this.zzXlF = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzXlF;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzZUj == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZUj = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzZUj;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZke == null) {
            this.zzZke = new RowFormat(this);
        }
        return this.zzZke;
    }

    public CellFormat getCellFormat() {
        if (this.zzXl4 == null) {
            this.zzXl4 = new CellFormat(this);
        }
        return this.zzXl4;
    }

    final void zzWW5(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzYfQ zzYfQ2;
        if (this.getCurrentParagraph() != null) {
            zzYfQ zzYfQ3 = this.getCurrentParagraph().zzWOK();
            zzYfQ2 = (zzYfQ)zzYfQ3.zzXV9();
        } else {
            zzYfQ2 = this.zzWwG();
        }
        zzYfQ zzYfQ4 = zzYfQ2;
        this.zzWSU().push(new zzXQZ(this.zzWwG(), zzYfQ4));
    }

    public void popFont() {
        zzZbV<zzXQZ> zzZbV2 = this.zzWSU();
        if (zzZbV2.size() > 0) {
            zzXQZ zzXQZ2 = (zzXQZ)this.zzWSU().pop();
            this.zzXQZ(zzXQZ2.zzQ(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzWW5(zzXQZ2.zzYQw());
            }
        }
    }

    final void zzYMe() {
        this.zzYL1().push(this.zzWwG());
    }

    final void zzWsQ() {
        zzZbV<zzYfQ> zzZbV2 = this.zzYL1();
        if (zzZbV2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXQZ((zzYfQ)documentBuilder.zzYL1().pop(), false);
        }
    }

    final void zzXK() {
        this.zzXgl().push(this.zzYnp());
    }

    final void zzYKi() {
        zzZbV<zzy7> zzZbV2 = this.zzXgl();
        if (zzZbV2.size() > 0) {
            zzy7 zzy72 = (zzy7)this.zzXgl().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXQZ(zzy72);
            }
        }
    }

    private zzXra zzfO(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzWXk(88);
        zzZq8 zzZq82 = new zzZq8();
        zzZq82.setTarget(string2);
        zzZq82.setScreenTip(string3);
        if (bl) {
            zzZq82.setSubAddress(string);
        } else {
            zzZq82.setAddress(zzWvT.zzZVE(string));
            zzZq82.setSubAddress(zzWvT.zzYAR(string));
        }
        this.zzWXo(zzZq82.zz7P());
        FieldSeparator fieldSeparator = this.zzWs5(88);
        return new zzXra(fieldStart, fieldSeparator, null);
    }

    final zzXra zzYe3(String string, String string2, String string3) {
        boolean bl = zzWvT.zzI6(string);
        String string4 = bl ? zzWvT.zzYAR(string) : string;
        return this.zzfO(string4, bl, string2, string3);
    }

    final zzXra zzXQZ(zzZq8 zzZq82) {
        FieldStart fieldStart = this.zzWXk(88);
        this.zzWXo(zzZq82.zz7P());
        FieldSeparator fieldSeparator = this.zzWs5(88);
        return new zzXra(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzZr4() {
        return this.zzWeI(88, true);
    }

    final zzYfQ zzWwG() {
        zzYfQ zzYfQ2 = this.zzXtw;
        return (zzYfQ)zzYfQ2.zzXV9();
    }

    final zzy7 zzYnp() {
        zzy7 zzy72 = this.zzZwo();
        return (zzy7)zzy72.zzXV9();
    }

    final zzXw6 zzVYe() {
        zzXw6 zzXw62 = this.zz3p();
        return (zzXw6)zzXw62.zzXV9();
    }

    final zzXiJ zzYjb() {
        zzXiJ zzXiJ2 = this.zz5L();
        return (zzXiJ)zzXiJ2.zzXV9();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXJO(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXJO().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzXRg && this.zzXJO().getNodeType() == 28;
    }

    private void zzZiw(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzXJO()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zza1.zzWEb(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzX6j(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWa5) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzWuM(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzX6j(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzZfO();
        if (this.zzX33() != null && this.zzX33().zzYZW() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzXJO().getParentNode().insertBefore(node, this.zzXJO());
    }

    final void zzSs(int n) {
        this.zzZPl(true);
        this.zzZM0(n);
    }

    private void zzZM0(int n) {
        this.insertParagraph();
        zzXCP zzXCP2 = new zzXCP(this.getDocument());
        try {
            zzX4d zzX4d2 = this.getCurrentSection().zzZlP();
            zzX4d zzX4d3 = (zzX4d)zzX4d2.zzXV9();
            Section section = new Section(this.zzY1P, zzX4d3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzY1P));
            this.zzY1P.insertAfter(section, this.getCurrentSection());
            section.getBody().zzfO(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzXCP2.dispose();
        }
    }

    final FieldStart zzWXk(int n) {
        this.zzZfO();
        return zztv.zzXQZ(n, this.zzWwG(), this.zzXL7(), this.zz2r(), this.zz2r() == null);
    }

    final Run zzWXo(String string) {
        return zztv.zzfO(string, this.zzWwG(), this.zzXL7(), this.zz2r(), this.zz2r() == null);
    }

    final FieldEnd zzWeI(int n, boolean bl) {
        return zztv.zzfO(n, bl, this.zzWwG(), this.zzXL7(), this.zz2r(), this.zz2r() == null);
    }

    final FieldSeparator zzWs5(int n) {
        return zztv.zzfO(n, this.zzWwG(), this.zzXL7(), this.zz2r(), this.zz2r() == null);
    }

    private FormField zzXYg(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzY1P, new zzY96(), this.zzWwG());
        CompositeNode compositeNode = node == null ? this.zzXL7() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzZPl(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzX33() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzWLd(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzX6j(String string) {
        if (this.zz1D(string)) {
            zzX1m zzX1m2 = new zzX1m(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzXMi zzXMi2 : zzX1m2.zzXeT(this.getParagraphFormat().getBidi())) {
                zzYsU zzYsU2 = zzYsU.zzXXK(zzXMi2.zzZSS());
                zzYfQ zzYfQ2 = this.zzWwG();
                zzYfQ2.zzXf9(265, zzYsU2);
                if (zzXMi2.zzYk5()) {
                    zzYfQ2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzY1P, zzXMi2.getText(), zzYfQ2);
                this.insertNode(run);
            }
            return;
        }
        this.zzWuM(string);
    }

    private boolean zz1D(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzXaQ.zzZml(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXQZ(zzYfQ zzYfQ2, boolean bl) {
        zzYfQ zzYfQ3;
        if (bl) {
            zzYfQ zzYfQ4 = zzYfQ2;
            zzYfQ3 = (zzYfQ)zzYfQ4.zzXV9();
        } else {
            zzYfQ3 = zzYfQ2;
        }
        this.zzXtw = zzYfQ3;
    }

    final void zzXR2() {
        this.zzXtw.clear();
    }

    final void zzXvd() {
        if (this.zzYQ5() != null) {
            zzXiJ zzXiJ2;
            zzXiJ zzXiJ3 = zzXiJ2 = this.zzYQ5().zz5L();
            this.zzWhY = (zzXiJ)zzXiJ3.zzXV9();
            zzXiJ2.zzfO(this.zzWhY);
        }
    }

    private Shape zzXQZ(String string, boolean bl, boolean bl2, zzYIU zzYIU2, zz89 zz892) throws Exception {
        if (zz892 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzXQZ(zzYIU2, bl2, zz892, string);
        zzXpU zzXpU2 = zzY8R.zzXQZ(string, bl, bl2, zz892);
        return DocumentBuilder.zzXQZ(string, bl, shape, zz892.zzWFx, zzXpU2);
    }

    private Shape zzXQZ(String string, boolean bl, String string2, String string3, zz89 zz892) throws Exception {
        if (zz892 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzWEs.zzZNd(string);
        }
        Shape shape = string2 != null ? this.zzZhL(string2, string3) : this.zzXQZ(null, string3, zz892);
        zzXpU zzXpU2 = zzY8R.zzXQZ(string, bl, true, zz892);
        return DocumentBuilder.zzXQZ(string, bl, shape, zz892.zzWFx, zzXpU2);
    }

    private static Shape zzXQZ(String string, boolean bl, Shape shape, String string2, zzXpU zzXpU2) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzfO(zzXpU2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzXQZ(zzYIU zzYIU2, boolean bl, zz89 zz892, String string) throws Exception {
        if (zz892 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzYIU2 != null) {
            return this.zz6f(zzYIU2);
        }
        if (!bl) {
            return this.zz1S(zzY8R.zzjL().get("normal"));
        }
        String string2 = string != null ? zzWEs.zzZNd(string) : zzY8R.zzYcU(zz892.zzwo);
        return this.zzXQZ(zz892, string2);
    }

    private Shape zzXQZ(String string, String string2, zz89 zz892) throws Exception {
        if (zz892 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzY8R.zzYcU(zz892.zzwo);
        }
        if (string != null) {
            return this.zzZhL(string, string2);
        }
        return this.zzXQZ(zz892, string2);
    }

    private Shape zzXQZ(zz89 zz892, String string) throws Exception {
        if (zz892 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzY8R.zzW60(zz892.zzwo);
        zzX5P zzX5P2 = new zzX5P(byArray, null, string, this.getDocument().zzYcT());
        return this.zz1S(zzX5P2.zzWxc());
    }

    private Shape zzZhL(String string, String string2) throws Exception {
        zzX5P zzX5P2 = new zzX5P(string, string2, this.getDocument().zzYcT());
        return this.zz1S(zzX5P2.zzWxc());
    }

    private Shape zz6f(zzYIU zzYIU2) throws Exception {
        byte[] byArray = zzZ3F.zzXrG(zzYIU2);
        return this.zz1S(byArray);
    }

    private Shape zz1S(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzY1P, 1);
        shape.setShapeType(75);
        shape.zzfO(this.zzWwG());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXYF(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzXQZ(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzfO(compositeNode, n);
            return;
        }
        this.zzZfH(compositeNode, n);
    }

    private void zzfO(CompositeNode compositeNode, int n) {
        zzZDU zzZDU2 = zzZDU.zzWLY(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzZDU2.zzXQZ(null, true, true, true, false, true);
            node = zzZDU2.getNode();
            if (zzZDU2.zzXcv() && (!node.isComposite() || node.zzYnF() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzWs0().length() : node.getTextLength();
            if (!zzZDU2.zzXcv() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzZDU2.zzXcv() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzXQZ((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzXQZ(null, node);
            this.zzJc = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzXQZ(StructuredDocumentTag structuredDocumentTag) {
        this.zzYZy(structuredDocumentTag);
        this.zzXRg = true;
        this.zzJc = 0;
        zzYfQ zzYfQ2 = structuredDocumentTag.zzWMH();
        switch (structuredDocumentTag.zzYnF()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zz0G(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzYfQ2 = ((Inline)node).zzQ();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzYfQ2 = paragraph.zzWOK();
                break;
            }
            default: {
                return;
            }
        }
        this.zzXQZ(zzYfQ2, true);
    }

    private void zzZfH(CompositeNode compositeNode, int n) {
        zzZDU zzZDU2 = zzZDU.zzMy(compositeNode);
        while (zzZDU2.getNode() != compositeNode || !zzZDU2.zzXcv()) {
            int n2;
            Node node = zzZDU2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzWs0().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzXQZ(null, node);
                this.zzJc = n;
                return;
            }
            while (zzZDU2.zzXQZ(null, false, true, true, false, true) && zzZDU2.zzXcv() && zzZDU2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzZfO() {
        int n = this.zzJc;
        if (n == 0) {
            return;
        }
        this.zzJc = 0;
        Run run = zzZ3F.zzXQZ((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzXj8(n);
        }
    }

    private Run zzWuM(String string) {
        Run run = new Run(this.zzY1P, string, this.zzWwG());
        this.insertNode(run);
        return run;
    }

    final boolean zzZeS() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZrS() {
        return this.zzWa5;
    }

    final void zz1e(int n) {
        this.zzWa5 = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXJO();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXJO();
        }
        return (Paragraph)this.zzXJO().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzXJO();
        }
        return (StructuredDocumentTag)this.zzXJO().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzXJO().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzbj zzX33() {
        zzZbV<zzbj> zzZbV2 = this.zzWjk;
        if (zzZbV2.size() > 0) {
            return (zzbj)this.zzWjk.peek();
        }
        return null;
    }

    private Cell zzYQ5() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzWXI();
    }

    private CompositeNode zzXL7() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzXJO();
        }
        return this.zzXJO().getParentNode();
    }

    private Node zz2r() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXJO();
    }

    private zzZbV<zzYfQ> zzYL1() {
        if (this.zzX3 == null) {
            this.zzX3 = new zzZbV();
        }
        return this.zzX3;
    }

    private zzZbV<zzy7> zzXgl() {
        if (this.zzWw7 == null) {
            this.zzWw7 = new zzZbV();
        }
        return this.zzWw7;
    }

    private zzZbV<zzXQZ> zzWSU() {
        if (this.zzZnI == null) {
            this.zzZnI = new zzZbV();
        }
        return this.zzZnI;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXtw.zzb3(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzXtw.zzWQ5(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZP(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZP(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXtw.zzXf9(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYqG()) {
            this.getCurrentParagraph().zzWOK().zzXf9(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXtw.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXtw.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYqG()) {
            this.getCurrentParagraph().zzWOK().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzZwo().zzb3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzZwo().zzWQ5(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzom(key, 0);
        }
        return this.getDocument().getStyles().zzY9O().zzWht(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzZwo().zzXf9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzZwo().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzZwo().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zz3p().zzb3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zz3p().zzWht(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zz3p().zzZRf(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zz3p().zzXf9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zz3p().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zz3p().clear();
        zzXw6.zzXRJ().zzfO(this.zz3p());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zz5L().zzb3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zz5L().zzWht(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zz5L().zzZRf(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZ3F.zzXQZ(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzYQ5() != null ? this.zzYQ5().getCellFormat() : this.getCellFormat();
            border.zzXQZ(cellFormat);
        }
        this.zz5L().zzXf9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zz5L().clear();
    }

    private Node zzXJO() {
        Node node = this.zzXWO != null && this.zzXWO.getParentNode() == null ? this.zzWpu : this.zzXWO;
        if (node != null && node.zzYnF() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzXRg = this.zzXRg && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzYZy(Node node) {
        this.zzXWO = node;
        if (this.zzXWO != null) {
            this.zzWpu = this.zzXWO.getParentNode();
        }
        this.zzXRg = false;
    }

    private zzy7 zzZwo() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzZwo();
        }
        if (this.zzXAs == null) {
            this.zzXAs = new zzy7();
        }
        return this.zzXAs;
    }

    private zzXw6 zz3p() {
        if (this.zzX33() != null && this.zzX33().zzYZW() == 1) {
            return this.zzW0X;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zz3p();
        }
        return this.zzW0X;
    }

    private zzXiJ zz5L() {
        if (this.zzX33() != null && this.zzX33().zzYZW() != 3) {
            return this.zzWhY;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzWXI().zz5L();
        }
        return this.zzWhY;
    }

    static final class zzXQZ {
        private zzYfQ zzXtw;
        private zzYfQ zzYj8;

        public zzXQZ(zzYfQ zzYfQ2, zzYfQ zzYfQ3) {
            this.zzXtw = zzYfQ2;
            this.zzYj8 = zzYfQ3;
        }

        public final zzYfQ zzQ() {
            return this.zzXtw;
        }

        public final zzYfQ zzYQw() {
            return this.zzYj8;
        }
    }
}

