/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzUJ;
import com.aspose.words.internal.zzWLV;
import com.aspose.words.internal.zzYIU;
import com.aspose.words.internal.zzYzf;
import com.aspose.words.internal.zzZ3F;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzYD5;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzVWo = new HashMap();
    private static HashMap<Integer, Integer> zzZvg = new HashMap();
    private static HashMap<Integer, Integer> zzWJK = new HashMap();
    private static HashMap<Integer, Integer> zzZnF = new HashMap();
    private static HashMap<Integer, Integer> zzYxL = new HashMap();
    private static HashMap<Integer, Integer> zzWuT = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZ3F.zzZfH(fileName, "fileName");
        try (com.aspose.words.internal.zzYD5 zzYD52 = zzZ3F.zzVz(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzYoh(zzYD52);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzYoh(zzWLV.zzXQZ(stream));
    }

    static FileFormatInfo zzYoh(zzYIU zzYIU2) throws Exception {
        if (zzYIU2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzYD5 zzYD52 = new zzYD5();
            zzYIU zzYIU3 = zzYIU2;
            zzYD5 zzYD53 = zzYD52;
            return zzYD52.zzfO(zzYIU3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZfH(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzc4(zzYzf.zzXrg(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzZdb(zzYzf.zzXrg(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzUJ.zzXlr(string = zzYzf.zzX1X(FileFormatUtil.zzVTG(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzc4(FileFormatUtil.zzYN0(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzZdb(FileFormatUtil.zzVTG(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYzf.zzX1X(FileFormatUtil.zzYN0(saveFormat));
        if (zzUJ.zzXlr(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzZdb(zzYzf.zzBB(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYzf.zzX1X(FileFormatUtil.zzIz(imageType));
    }

    static Exception zzZfH(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzZq8(int n) {
        return zzYzf.toString(FileFormatUtil.zzYN0(n));
    }

    static int zzZdb(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZ3F.zzXQZ(zzYxL, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzYp3(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZ3F.zzXQZ(zzWuT, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzZW7(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzVTG(int n) {
        return zzZ3F.zzXQZ(zzVWo, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzYN0(int n) {
        return zzZ3F.zzXQZ(zzZvg, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzIz(int n) {
        return zzZ3F.zzXQZ(zzWJK, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzc4(int n) {
        return zzZ3F.zzXQZ(zzZnF, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzYhu(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZ3F.zzfO(zzYxL, Integer.valueOf(n), Integer.valueOf(n2));
            zzZ3F.zzfO(zzZvg, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZnF.containsKey(n)) {
                zzZ3F.zzfO(zzZnF, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZ3F.zzfO(zzVWo, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZ3F.zzfO(zzWuT, Integer.valueOf(n), Integer.valueOf(n4));
            zzZ3F.zzfO(zzWJK, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzYhu(12, 10, 10, 1);
        FileFormatUtil.zzYhu(12, 0, 0, 1);
        FileFormatUtil.zzYhu(13, 11, 11, 1);
        FileFormatUtil.zzYhu(14, 20, 20, 1);
        FileFormatUtil.zzYhu(14, 0, 254, 1);
        FileFormatUtil.zzYhu(15, 21, 21, 1);
        FileFormatUtil.zzYhu(16, 22, 22, 1);
        FileFormatUtil.zzYhu(17, 23, 23, 1);
        FileFormatUtil.zzYhu(19, 24, 24, 1);
        FileFormatUtil.zzYhu(20, 25, 25, 1);
        FileFormatUtil.zzYhu(21, 26, 26, 1);
        FileFormatUtil.zzYhu(22, 27, 27, 1);
        FileFormatUtil.zzYhu(25, 30, 30, 1);
        FileFormatUtil.zzYhu(18, 31, 31, 1);
        FileFormatUtil.zzYhu(26, 50, 50, 1);
        FileFormatUtil.zzYhu(27, 45, 255, 1);
        FileFormatUtil.zzYhu(28, 51, 51, 1);
        FileFormatUtil.zzYhu(29, 54, 52, 1);
        FileFormatUtil.zzYhu(30, 0, 53, 1);
        FileFormatUtil.zzYhu(32, 53, 54, 1);
        FileFormatUtil.zzYhu(23, 60, 60, 1);
        FileFormatUtil.zzYhu(24, 61, 61, 1);
        FileFormatUtil.zzYhu(35, 40, 64, 1);
        FileFormatUtil.zzYhu(42, 47, 255, 1);
        FileFormatUtil.zzYhu(43, 48, 255, 1);
        FileFormatUtil.zzYhu(36, 41, 255, 1);
        FileFormatUtil.zzYhu(37, 46, 255, 1);
        FileFormatUtil.zzYhu(39, 42, 255, 1);
        FileFormatUtil.zzYhu(38, 44, 255, 1);
        FileFormatUtil.zzYhu(31, 52, 55, 1);
        FileFormatUtil.zzYhu(33, 70, 62, 1);
        FileFormatUtil.zzYhu(34, 73, 63, 1);
        FileFormatUtil.zzYhu(40, 71, 255, 1);
        FileFormatUtil.zzYhu(8, 100, 255, 1);
        FileFormatUtil.zzYhu(9, 105, 255, 1);
        FileFormatUtil.zzYhu(6, 101, 255, 6);
        FileFormatUtil.zzYhu(7, 102, 255, 7);
        FileFormatUtil.zzYhu(5, 104, 255, 5);
        FileFormatUtil.zzYhu(4, 0, 255, 4);
        FileFormatUtil.zzYhu(3, 0, 255, 3);
        FileFormatUtil.zzYhu(41, 72, 255, 1);
        FileFormatUtil.zzYhu(2, 103, 255, 2);
        FileFormatUtil.zzYhu(10, 106, 255, 8);
        FileFormatUtil.zzYhu(47, 80, 255, 1);
    }
}

