/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzYIU;
import com.aspose.words.internal.zzYax;
import com.aspose.words.zzZPx;
import java.io.InputStream;
import java.io.OutputStream;

public class Merger {
    private Merger() {
    }

    public static void merge(String outputFile, String[] inputFiles) throws Exception {
        Merger.merge(outputFile, inputFiles, SaveOptions.createSaveOptions(outputFile), 1);
    }

    public static void merge(String outputFile, String[] inputFiles, int saveFormat, int mergeFormatMode) throws Exception {
        Merger.merge(outputFile, inputFiles, SaveOptions.createSaveOptions(saveFormat), mergeFormatMode);
    }

    public static void merge(String outputFile, String[] inputFiles, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Document document = Merger.merge(inputFiles, mergeFormatMode);
        if (document.getOriginalLoadFormat() == 64 && !saveOptions.zz9P()) {
            document.updatePageLayout();
        }
        document.save(outputFile, saveOptions);
    }

    public static Document merge(String[] inputFiles, int mergeFormatMode) throws Exception {
        Document document = null;
        String[] stringArray = inputFiles;
        int n = inputFiles.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (document == null) {
                document = new Document(string);
                continue;
            }
            if (mergeFormatMode == 2) {
                Document[] documentArray = new Document[]{new Document(string)};
                Document document2 = document;
                zzZPx.zzXQZ(document2, documentArray);
                continue;
            }
            document.appendDocument(new Document(string), Merger.zzYbs(mergeFormatMode));
        }
        return document;
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, int saveFormat) throws Exception {
        int n = saveFormat;
        zzYIU[] zzYIUArray = zzYIU.zzXQZ(inputStreams);
        zzYax zzYax2 = zzYIU.zzZfH(outputStream);
        Merger.zzXQZ(zzYax2, zzYIUArray, n);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        int n = mergeFormatMode;
        SaveOptions saveOptions2 = saveOptions;
        zzYIU[] zzYIUArray = zzYIU.zzXQZ(inputStreams);
        zzYax zzYax2 = zzYIU.zzZfH(outputStream);
        Merger.zzXQZ(zzYax2, zzYIUArray, saveOptions2, n);
    }

    public static Document merge(InputStream[] inputStreams, int mergeFormatMode) throws Exception {
        int n = mergeFormatMode;
        zzYIU[] zzYIUArray = zzYIU.zzXQZ(inputStreams);
        return Merger.zzXQZ(zzYIUArray, n);
    }

    private static void zzXQZ(zzYIU zzYIU2, zzYIU[] zzYIUArray, int n) throws Exception {
        Merger.zzXQZ(zzYIU2, zzYIUArray, SaveOptions.createSaveOptions(n), 1);
    }

    private static void zzXQZ(zzYIU zzYIU2, zzYIU[] zzYIUArray, SaveOptions saveOptions, int n) throws Exception {
        Document document = Merger.zzXQZ(zzYIUArray, n);
        if (document.getOriginalLoadFormat() == 64 && !saveOptions.zz9P()) {
            document.updatePageLayout();
        }
        document.zzWa3(zzYIU2, saveOptions.getSaveFormat());
    }

    private static Document zzXQZ(zzYIU[] zzYIUArray, int n) throws Exception {
        Document document = null;
        zzYIU[] zzYIUArray2 = zzYIUArray;
        int n2 = zzYIUArray.length;
        for (int i = 0; i < n2; ++i) {
            zzYIU zzYIU2 = zzYIUArray2[i];
            if (document == null) {
                document = new Document(zzYIU2);
                continue;
            }
            if (n == 2) {
                Document[] documentArray = new Document[]{new Document(zzYIU2)};
                Document document2 = document;
                zzZPx.zzXQZ(document2, documentArray);
                continue;
            }
            document.appendDocument(new Document(zzYIU2), Merger.zzYbs(n));
        }
        return document;
    }

    private static int zzYbs(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 1;
    }
}

