/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWAt;
import com.aspose.words.internal.zzZ3F;
import com.aspose.words.internal.zzZbV;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXLt;
import com.aspose.words.zzZ0v;
import com.aspose.words.zzZDU;
import com.aspose.words.zzZhJ;
import com.aspose.words.zztv;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzX09;
    private Node zzXbQ;
    private Node zzXfl;
    private int zzXsC;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzZfH(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzX09 == null) {
            return null;
        }
        if (this.zzX09.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzX09;
    }

    final CompositeNode zzW1v() {
        if (zztv.zzoz(this.getParentNode())) {
            return this.getParentNode().zzW1v();
        }
        return this.getParentNode();
    }

    final CompositeNode zzYYb() {
        if (zztv.zzoz(this.getParentNode()) || zztv.zzWUH(this.getParentNode())) {
            return this.getParentNode().zzYYb();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzX09 != null) {
            return this.zzX09.getDocument();
        }
        return null;
    }

    final Document zzM() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzc9() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzWxO();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzXfl;
    }

    final Node zzml() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zztv.zzBI((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzj6() {
        Node node = zztv.zzYe3(this.getPreviousSibling(), false);
        if (node == null && zztv.zzoz(this.getParentNode())) {
            node = this.getParentNode().zzj6();
        }
        return node;
    }

    final Node zzYai() {
        Node node = zztv.zz9U(this.getNextSibling(), false);
        if (node == null && zztv.zzoz(this.getParentNode())) {
            node = this.getParentNode().zzYai();
        }
        return node;
    }

    final CompositeNode zzWEV() {
        Node node = this;
        while ((node = node.zzj6()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZfS() {
        Node node = this;
        while ((node = node.zzYai()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzXbQ;
    }

    final Node zzl3() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zztv.zzBI((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzXsx() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzX0y() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZ2j() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zztv.zzYzC(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzWOo() {
        return this.zzXbQ;
    }

    final void zzXEW(Node node) {
        this.zzXbQ = node;
    }

    final Node zzVTF() {
        return this.zzXfl;
    }

    final void zzYjS(Node node) {
        this.zzXfl = node;
    }

    final Node zzYNY() {
        Node node = this;
        if (node.zzXbQ != null) {
            node = this;
            return node.zzXbQ;
        }
        return this.getParentNode();
    }

    final int zzYnF() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zztv.zzXiM(this);
        boolean bl2 = zztv.zzXi9(this);
        boolean bl3 = zztv.zzXIR(this);
        boolean bl4 = zztv.zzZ2x(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzYnF() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzYnF() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzXQZ(isCloneChildren, new zzXQZ(this));
    }

    Node zzXQZ(boolean bl, zzZhJ zzZhJ2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzX09 != null) {
            node.zzX09 = this.getDocument().zzXDS();
        }
        node.zzXbQ = null;
        node.zzXfl = null;
        if (zzZhJ2 != null) {
            zzZhJ2.zzXRc(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzZvc(StringBuilder stringBuilder) {
        zzZ3F.zzfO(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzVQS(Node node) {
        this.zzX09 = node != null ? node : this.getDocument().zzXDS();
    }

    final void zzZfH(DocumentBase documentBase) {
        this.zzX09 = documentBase != null ? documentBase.zzXDS() : null;
    }

    final boolean zzvw(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzVSd() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzkj(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWTW(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zz4W(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzZvc(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzZel(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzZ0v zzZ0v2 = zztv.zzW60(saveFormat);
        return zzZ0v2.zzX3K(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZ0v zzZ0v2 = zztv.zzfO(saveOptions);
        return zzZ0v2.zzX3K(this);
    }

    final Node zzZQa(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zztv.zzZml(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzZDU zzWm8() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzZDU.zzMy(node);
        }
        return zzZDU.zzWLY(this.getParentNode());
    }

    final zzZDU zzWJp() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzZDU.zzWLY(node);
        }
        return zzZDU.zzMy(this.getParentNode());
    }

    final boolean zzYCV(Node node) {
        return Node.zzZiw(this, node);
    }

    final boolean zzYA2() {
        return this.getAncestor(1) == null;
    }

    static Node zzdK(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzZbV<Node> zzZbV2 = Node.zzHh(node);
        zzZbV<Node> zzZbV3 = Node.zzHh(node2);
        return Node.zzXQZ(zzZbV2, zzZbV3);
    }

    static boolean zzZiw(Node node, Node node2) {
        zzZbV<Node> zzZbV2;
        if (node == null || node2 == null) {
            return false;
        }
        zzZbV<Node> zzZbV3 = Node.zzHh(node);
        Node node3 = Node.zzXQZ(zzZbV3, zzZbV2 = Node.zzHh(node2));
        if (node3 == null) {
            return false;
        }
        zzZbV<Node> zzZbV4 = zzZbV3;
        if (zzZbV4.size() == 0 || (zzZbV4 = zzZbV2).size() == 0) {
            zzZbV4 = zzZbV2;
            boolean bl = zzZbV4.size() > 0;
            return bl;
        }
        Object e = zzZbV3.peek();
        Object e2 = zzZbV2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzZbV<Node> zzHh(Node node) {
        zzZbV<Node> zzZbV2 = new zzZbV<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzZbV2.push(node2);
        }
        return zzZbV2;
    }

    private static Node zzXQZ(zzZbV<Node> zzZbV2, zzZbV<Node> zzZbV3) {
        Node node = null;
        while (zzZbV2.peek() == zzZbV3.peek()) {
            node = (Node)zzZbV2.pop();
            zzZbV3.pop();
            zzZbV<Node> zzZbV4 = zzZbV2;
            if (zzZbV4.size() != 0 && (zzZbV4 = zzZbV3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzXsC;
    }

    public void setCustomNodeId(int value) {
        this.zzXsC = value;
    }

    private String zzn6() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzZ3F.zzXQZ(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzWAt.zzXfw(stringBuilder.toString());
    }

    public String toString() {
        return zzWAt.zzXfw(zzWAt.zzfO("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzn6()));
    }

    public void dd() {
    }

    final Node zzZ2x(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzXiM(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzXIR(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzXiM(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzXiM(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzXQZ
    implements zzZhJ {
        private Node zzlO;
        private HashMap<Integer, Integer> zzXaI;

        zzXQZ(Node node) {
            this.zzlO = node;
        }

        @Override
        public final void zzXRc(Node node, Node node2) {
            if (node == this.zzlO) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzXLt zzXLt2 = (zzXLt)((Object)node2);
            if (this.zzXaI == null) {
                this.zzXaI = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzZ3F.zzXQZ(this.zzXaI, Integer.valueOf(zzXLt2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzPq();
                zzZ3F.zzfO(this.zzXaI, Integer.valueOf(zzXLt2.getIdInternal()), Integer.valueOf(n));
            }
            zzXLt2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzZ3F.zzXQZ(this.zzXaI, Integer.valueOf(zzXLt2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzXLt2.setParentIdInternal(n2);
            }
        }
    }
}

