/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzWLV;
import com.aspose.words.zzGr;
import com.aspose.words.zzWVN;
import com.aspose.words.zzXQJ;
import com.aspose.words.zzXi4;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzGr,
Iterable<T> {
    private Node zzVVg;
    private CompositeNode zzAj;
    private DocumentBase zzWrX;
    private boolean zzYck;
    private int zzZAl;
    private int zzZIK;
    private Node zzXET;
    private int zzZQb;
    private zzXQJ zzWiv;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzWVN.zzY3K(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzWVN(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzXQJ matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: container");
        }
        if (matcher == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: matcher");
        }
        this.zzAj = container;
        this.zzWrX = container.getDocument();
        this.zzWiv = matcher;
        this.zzYck = isDeep;
        this.zz92();
    }

    public Node get(int index) {
        try {
            this.zzZVT();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzZIK == index) {
                return this.zzXET;
            }
            int n = index - this.zzZIK;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzXsA(nodeCollection.zzXET, n);
            if (node != null) {
                this.zzZIK = index;
                this.zzXET = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzYck) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzAj.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzYck) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzAj.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zz8M();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXi4(this);
    }

    final <TNode extends Node> zzXi4<TNode> zzVSz() {
        return new zzXi4(this);
    }

    final ArrayList<Node> zzYwD() {
        return this.zz8M();
    }

    final <TValue extends Node> ArrayList<TValue> zz8M() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzWLV.zzXQZ(arrayList, node);
        }
        return arrayList;
    }

    private Node zzXsA(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZGH(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzWra(curNode, true);
    }

    private Node zzWra(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzVVg = node;
        do {
            node2 = this.zzVVg;
            Node node3 = this.zzYck ? this.zzXQZ(true, this.zzVVg) : (this.zzVVg = this.zzWiv.zzM8() ? this.zzZfH(true, this.zzVVg) : this.zzfO(true, this.zzVVg));
        } while (this.zzVVg != null && !this.zzWiv.zzXUb(this.zzVVg));
        return node2;
    }

    private Node zzZGH(Node node, boolean bl) throws Exception {
        while ((this.zzYck ? this.zzXQZ(bl, node) : (node = this.zzWiv.zzM8() ? this.zzZfH(bl, node) : this.zzfO(bl, node))) != null && !this.zzWiv.zzXUb(node)) {
        }
        return node;
    }

    private Node zzXQZ(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzAj);
        }
        return node.previousPreOrder(this.zzAj);
    }

    private Node zzfO(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzAj) {
                return this.zzAj.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzAj) {
            return this.zzAj.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzZfH(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzAj ? this.zzAj.zzYxk() : node.zzYai();
        } else {
            Node node3 = node2 = node == this.zzAj ? this.zzAj.zzW5T() : node.zzj6();
        }
        if (node2 == this.zzAj.getNextSibling() || node2 == this.zzAj.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzZVT() {
        if (this.zzZAl != this.zzWiD()) {
            this.zz92();
        }
    }

    private void zz92() {
        this.zzZAl = this.zzWiD();
        this.zzZIK = -1;
        this.zzXET = this.zzAj;
        this.zzZQb = -1;
    }

    private int zzWiD() {
        if (this.zzWrX != null) {
            return this.zzWrX.zzXKD();
        }
        return 0;
    }

    public int getCount() {
        this.zzZVT();
        if (this.zzZQb == -1) {
            this.zzZQb = zzXi4.zzXQZ(this);
        }
        return this.zzZQb;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzVVg;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzAj;
    }
}

