/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Cell;
import com.aspose.words.Comment;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Field;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FrameFormat;
import com.aspose.words.HeaderFooter;
import com.aspose.words.Inline;
import com.aspose.words.List;
import com.aspose.words.ListFormat;
import com.aspose.words.ListLabel;
import com.aspose.words.ListLevel;
import com.aspose.words.Node;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.Run;
import com.aspose.words.RunCollection;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.TabStop;
import com.aspose.words.TabStopCollection;
import com.aspose.words.Table;
import com.aspose.words.TableStyle;
import com.aspose.words.WordAttrCollection;
import com.aspose.words.internal.zzWAt;
import com.aspose.words.internal.zzZ3F;
import com.aspose.words.ref.RefBoolean;
import com.aspose.words.ref.RefDouble;
import com.aspose.words.zzMy;
import com.aspose.words.zzWDX;
import com.aspose.words.zzWH5;
import com.aspose.words.zzWWj;
import com.aspose.words.zzWiz;
import com.aspose.words.zzXje;
import com.aspose.words.zzY7U;
import com.aspose.words.zzYT3;
import com.aspose.words.zzYVQ;
import com.aspose.words.zzYfQ;
import com.aspose.words.zzYz2;
import com.aspose.words.zzZhJ;
import com.aspose.words.zzZjz;
import com.aspose.words.zztv;
import com.aspose.words.zzy7;
import java.util.Iterator;

public class Paragraph
extends CompositeNode<Node>
implements zzXje,
zzYT3,
zzYz2 {
    private int zzTM;
    private int zzXVo;
    private zzy7 zzXAs;
    private zzYfQ zzVYG;
    private ParagraphFormat zzZUj;
    private FrameFormat zzY9w;
    private ListFormat zzX4n;
    private ListLabel zzYOC;
    private RunCollection zzXaf;

    public Paragraph(DocumentBase doc) {
        this(doc, new zzy7(), new zzYfQ());
    }

    Paragraph(DocumentBase doc, zzy7 paraPr, zzYfQ runPr) {
        super(doc);
        this.zzXAs = paraPr;
        this.zzVYG = runPr;
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    public Story getParentStory() {
        return (Story)this.getAncestor(Story.class);
    }

    public Section getParentSection() {
        return (Section)this.getAncestor(2);
    }

    public boolean isInCell() {
        return this.zzW1v() instanceof Cell;
    }

    final boolean zzYCL() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode == null) {
            return false;
        }
        if (zztv.zzoz(compositeNode)) {
            if (this.isInCell()) {
                Paragraph paragraph = this;
                if (paragraph.zzvw(paragraph.zzW1v().getFirstChild())) {
                    return true;
                }
            }
            return false;
        }
        return this.isInCell() && this == compositeNode.zzYDi();
    }

    public boolean isEndOfCell() {
        CompositeNode compositeNode = this.zzW1v();
        return compositeNode instanceof Cell && compositeNode.zztY() == this;
    }

    public boolean getBreakIsStyleSeparator() {
        return zztv.zzZfH(this.zzVYG, 130) && zztv.zzZfH(this.zzVYG, 10);
    }

    final boolean zzgv() {
        return this.isEndOfCell() && this.zzWXI().isLastCell();
    }

    final Cell zzWXI() {
        return zzZ3F.zzXQZ((Object)this.zzW1v(), Cell.class);
    }

    final Row getParentRow() {
        if (this.zzWXI() != null) {
            return this.zzWXI().getParentRow();
        }
        return null;
    }

    final Table getParentTable() {
        if (this.getParentRow() != null) {
            return this.getParentRow().getParentTable();
        }
        return null;
    }

    public boolean isEndOfSection() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1 && this == story.zztY();
    }

    public boolean isEndOfHeaderFooter() {
        Story story = this.getParentStory();
        return story instanceof HeaderFooter && story.zztY() == this;
    }

    public boolean isEndOfDocument() {
        if (!this.isEndOfSection()) {
            return false;
        }
        for (Node node = this.getDocument().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (!(node instanceof Section)) continue;
            return node == this.getParentSection();
        }
        return true;
    }

    final boolean zzYfh() {
        if (this.zzl3() != null) {
            return false;
        }
        if (this.getParentNode().getNodeType() != 3) {
            return false;
        }
        return !this.getParentSection().zzXsx();
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzZUj == null) {
            Paragraph paragraph = this;
            this.zzZUj = new ParagraphFormat(paragraph, paragraph.getDocument().getStyles());
        }
        return this.zzZUj;
    }

    public ListFormat getListFormat() {
        if (this.zzX4n == null) {
            Paragraph paragraph = this;
            this.zzX4n = new ListFormat(paragraph, paragraph, this.getDocument().getLists());
        }
        return this.zzX4n;
    }

    public FrameFormat getFrameFormat() {
        if (this.zzY9w == null) {
            this.zzY9w = new FrameFormat(this);
        }
        return this.zzY9w;
    }

    public ListLabel getListLabel() {
        if (this.zzYOC == null) {
            this.zzYOC = new ListLabel(this);
        }
        return this.zzYOC;
    }

    public RunCollection getRuns() {
        if (this.zzXaf == null) {
            this.zzXaf = new RunCollection(this);
        }
        return this.zzXaf;
    }

    public Font getParagraphBreakFont() {
        Paragraph paragraph = this;
        return new Font(paragraph, paragraph.getDocument());
    }

    public boolean isInsertRevision() {
        return this.zzVYG.zzZGU();
    }

    public boolean isDeleteRevision() {
        return this.zzVYG.zzX92();
    }

    public boolean isMoveFromRevision() {
        return this.zzVYG.zzWzH();
    }

    public boolean isMoveToRevision() {
        return this.zzVYG.zzZz9();
    }

    public boolean isFormatRevision() {
        return this.zzXAs.zzZRT();
    }

    final Style zzZmI() {
        return this.zzYNo(0);
    }

    final Style zzYNo(int n) {
        Object object = this.zzXAs.zzWQ5(1000, n);
        int n2 = object != null ? (Integer)object : 0;
        return this.getDocument().getStyles().zzXU2(n2, 0);
    }

    private Style zzDy() {
        return this.getDocument().getStyles().zzXU2(this.zzVYG.zz9s(), 10);
    }

    final zzy7 zzZwo() {
        return this.zzXAs;
    }

    final void zzXQZ(zzy7 zzy72) {
        this.zzXAs = zzy72;
    }

    final void zzXXK(Paragraph paragraph) {
        if (paragraph.getListLabel().zzXLq() != null && paragraph.getListLabel().zzZME() != null) {
            this.getListLabel().zzXQZ(paragraph.getListLabel().zzXLq(), paragraph.getListLabel().zzVTO(), paragraph.getListLabel().zzZME().zzZIP(), 0);
        }
        if (paragraph.getListLabel().zzXLC() != null && paragraph.getListLabel().zzUD() != null) {
            this.getListLabel().zzXQZ(paragraph.getListLabel().zzXLC(), paragraph.getListLabel().zzW7t(), paragraph.getListLabel().zzUD().zzZIP(), 1);
        }
    }

    final void zzY0V(int n) {
        if (this.zzYOC != null) {
            this.zzYOC.zzXQZ(null, null, null, n);
        }
    }

    final zzYfQ zzWOK() {
        return this.zzVYG;
    }

    final void zzWW5(zzYfQ zzYfQ2) {
        this.zzVYG = zzYfQ2;
    }

    @Override
    final Node zzXQZ(boolean bl, zzZhJ zzZhJ2) {
        zzYfQ zzYfQ2;
        zzy7 zzy72;
        Paragraph paragraph = (Paragraph)super.zzXQZ(bl, zzZhJ2);
        WordAttrCollection wordAttrCollection = this.zzXAs;
        paragraph.zzXAs = zzy72 = (zzy7)wordAttrCollection.zzXV9();
        wordAttrCollection = this.zzVYG;
        paragraph.zzVYG = zzYfQ2 = (zzYfQ)wordAttrCollection.zzXV9();
        paragraph.zzZUj = null;
        paragraph.zzY9w = null;
        paragraph.zzX4n = null;
        paragraph.zzYOC = null;
        paragraph.zzXaf = null;
        return paragraph;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXQZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphStart(this);
    }

    @Override
    final int zzfO(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphEnd(this);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    final zzy7 zzWPx(int n) {
        TabStop tabStop;
        zzy7 zzy72 = new zzy7();
        this.zzfO(zzy72, n);
        if ((n & 0x100) != 0 && (tabStop = zztv.zzWLY(this)) != null) {
            if (!zzy72.zzeD(1140)) {
                zzy72.zzXf9(1140, new TabStopCollection());
            }
            zzy72.getTabStops().add(tabStop);
        }
        return zzy72;
    }

    final void zzfO(zzy7 zzy72, int n) {
        TableStyle tableStyle;
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        boolean bl = (n & 0x40) != 0;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 0x80) == 0;
        n &= 0xFFFFFF7F;
        if (bl2) {
            this.getDocument().getStyles().zzY9O().zzXQZ((zzMy)zzy72, bl);
        }
        if ((n & 4) != 0 && (cloneable3 = this.zzWXI()) != null && (cloneable2 = ((Cell)(cloneable = cloneable3)).getParentRow().getParentTable()) != null && (tableStyle = zzZ3F.zzXQZ((Object)((Table)cloneable2).getStyle(), TableStyle.class)) != null) {
            tableStyle.zzXQZ((Cell)cloneable3, zzy72);
        }
        cloneable3 = this.zzXAs.zzGr(n);
        if ((n & 0x10) != 0 && this.zzXAs.zzZRT()) {
            zzy72.zzXQZ((zzWDX)this.zzXAs.zzZdV().deepCloneComplexAttr());
        }
        cloneable2 = this.getDocument().getStyles().zzXU2(((zzy7)cloneable3).zz9s(), 0);
        int n2 = bl2 ? n & 0xFFFFFFFE : n;
        n2 = bl ? n2 & 0xFFFFFFBF : n2;
        ((Style)cloneable2).zzfO(zzy72, n2);
        if (zzy72.getListId() != ((zzy7)cloneable3).getListId() || zzy72.zzXf7() != ((zzy7)cloneable3).zzXf7()) {
            Cloneable cloneable4 = cloneable3;
            if (!((zzMy)cloneable3).zzWQV(1110) && zzy72.zzWQV(1110)) {
                cloneable = cloneable3;
                cloneable4 = (zzy7)((zzMy)cloneable).zzXV9();
                ((zzMy)cloneable4).zzXf9(1110, zzy72.get(1110));
            }
            this.getDocument().getLists().zzXQZ((zzy7)cloneable4, zzy72);
        }
        if ((n & 8) != 0 && this.zzXAs.zzWQV(1585)) {
            this.getDocument().zzXNy().zzXQZ(this.zzXAs, zzy72, this.getParentTable() == null);
        }
        if (bl3) {
            ((zzMy)cloneable3).zzfO(zzy72);
        }
        ((zzy7)cloneable3).zzYhu(zzy72);
        if (((zzy7)cloneable3).zzYB1()) {
            if (!((zzMy)cloneable3).zzWQV(1170)) {
                zzy72.zzZqY(0);
            }
            if (!((zzMy)cloneable3).zzWQV(1160)) {
                zzy72.zzVYV(0);
            }
            if (!((zzMy)cloneable3).zzWQV(1165)) {
                if (bl) {
                    zzy72.set(1165, 0);
                } else {
                    zzy72.remove(1165);
                }
            }
            if (!((zzMy)cloneable3).zzWQV(1175)) {
                if (bl) {
                    zzy72.set(1175, 0);
                } else {
                    zzy72.remove(1175);
                }
            }
        }
        if (((Node)(cloneable = this)).zzW1v() instanceof Shape) {
            zzy72.zzWyX();
        }
        if ((n & 2) != 0) {
            zzy72.zzXMS();
        }
    }

    final zzYfQ zzVYk(int n) {
        zzYfQ zzYfQ2 = new zzYfQ();
        int n2 = n;
        zzYfQ zzYfQ3 = zzYfQ2;
        Paragraph paragraph = this;
        zztv.zzXQZ(paragraph, zzYfQ3, n2);
        return zzYfQ2;
    }

    final void zzXBH(int n) {
        for (int i = this.zzXAs.getCount() - 1; i >= 0; --i) {
            Object object;
            Object object2;
            int n2 = this.zzXAs.zzWeO(i);
            if (n2 == 1000 || n2 == 1120 || n2 == 1110 || !(object2 = this.zzXAs.zzWQ5(n2, 0)).equals(object = this.zzom(n2, 0))) continue;
            this.zzXAs.removeAt(i);
        }
    }

    final boolean zzXsZ() {
        CompositeNode compositeNode = this.zzW1v();
        return compositeNode instanceof Comment && this == compositeNode.zztY();
    }

    final boolean zzYLO() {
        CompositeNode compositeNode = this.zzW1v();
        return compositeNode instanceof Footnote && this == compositeNode.zztY();
    }

    final boolean zzYyQ() {
        CompositeNode compositeNode = this.zzW1v();
        return compositeNode instanceof zzWH5 && this == compositeNode.zztY();
    }

    final boolean zzZ1x() {
        CompositeNode compositeNode = this.zzW1v();
        return compositeNode instanceof Shape && compositeNode.zztY() == this;
    }

    final void zzXQZ(RefDouble refDouble, RefDouble refDouble2, RefBoolean refBoolean) {
        refDouble.set(2.147483647E9);
        refDouble2.set(0.0);
        refBoolean.set(false);
        for (Node node = this.zzYxk(); node != null; node = node.zzYai()) {
            if (!(node instanceof Inline)) continue;
            Paragraph.zzXQZ((Inline)node, refDouble, refDouble2, refBoolean);
        }
        if (refDouble2.get() == 0.0) {
            Paragraph.zzXQZ(this, refDouble, refDouble2, refBoolean);
        }
    }

    private static void zzXQZ(zzXje zzXje2, RefDouble refDouble, RefDouble refDouble2, RefBoolean refBoolean) {
        Object object = zzXje2.getDirectRunAttr(190);
        int n = (Integer)(object != null ? object : zzXje2.fetchInheritedRunAttr(190));
        double d = (double)n / 2.0;
        refDouble.set(Math.min(d, refDouble.get()));
        refDouble2.set(Math.max(d, refDouble2.get()));
        if (!refBoolean.get()) {
            refBoolean.set(object != null);
            if (!refBoolean.get()) {
                Object object2 = zzXje2.getDirectRunAttr(50);
                refBoolean.set(object2 != null && (Integer)object2 != 10);
            }
        }
    }

    @Override
    final String zzWs0() {
        if (this.isEndOfCell()) {
            return ControlChar.CELL;
        }
        if (this.isEndOfSection()) {
            return ControlChar.SECTION_BREAK;
        }
        return ControlChar.PARAGRAPH_BREAK;
    }

    @Override
    final boolean zzw1(Node node) {
        Shape shape;
        Shape shape2 = zzZ3F.zzXQZ((Object)node, Shape.class);
        if (shape2 != null && (shape2.zzYYS() || shape2.getShapeType() == 20) && (shape = (Shape)this.getAncestor(18)) != null && shape.zzYYS()) {
            return false;
        }
        return zztv.zzXiM(node);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzXAs.zzb3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzXAs.zzWQ5(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        return this.zzom(key, 0);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        return this.zzXRv(key, 0);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        this.zzXAs.zzXf9(key, value);
        switch (key) {
            case 1155: 
            case 1165: 
            case 1175: 
            case 1205: 
            case 1225: {
                this.zzXsi();
            }
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzXAs.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzXAs.clear();
    }

    final Object zzom(int n, int n2) {
        Object object;
        Object object2;
        Paragraph paragraph = this;
        ListLevel listLevel = this.getDocument().getLists().zzXQZ(paragraph.zzXAs, n2);
        if (listLevel != null) {
            object2 = listLevel.zzZwo().zzb3(n);
            if (object2 != null) {
                return object2;
            }
        } else {
            object = this.zzXAs.zzWQ5(1120, n2);
            if (object != null && (Integer)object == 0 && zzy7.zzWYN(n)) {
                return 0;
            }
        }
        if ((object2 = this.zzYNo(n2).zzWiG(n, n2)) != null) {
            return object2;
        }
        if (this.zzZkd() && (object2 = ((TableStyle)(object = (TableStyle)this.getParentTable().getStyle())).zzZfH(n, this.zzWXI())) != null) {
            return object2;
        }
        return this.getDocument().getStyles().zzY9O().zzWht(n);
    }

    private boolean zzZkd() {
        Cell cell = this.zzWXI();
        if (cell == null) {
            return false;
        }
        Row row = cell.getParentRow();
        if (row == null) {
            return false;
        }
        Table table = row.getParentTable();
        if (table == null) {
            return false;
        }
        TableStyle tableStyle = zzZ3F.zzXQZ((Object)this.getDocument().getStyles().zzWsB(this.getParentTable().zz9s(), false), TableStyle.class);
        if (tableStyle == null) {
            return false;
        }
        return tableStyle.getStyleIdentifier() != 105;
    }

    final Object zzXRv(int n, int n2) {
        Object object = this.zzXAs.zzWQ5(n, n2);
        if (object != null) {
            return object;
        }
        return this.zzom(n, n2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key) {
        return this.getDirectRunAttr(key, 0);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzVYG.zzWQ5(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int key) {
        Object object = this.zzDy().zzZP(key, false);
        if (object != null) {
            return object;
        }
        Paragraph paragraph = this;
        return paragraph.zzYNo(0).zzZP(key, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int key, Object value) {
        this.zzVYG.zzXf9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzVYG.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzVYG.clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWWj getInsertRevision() {
        Paragraph paragraph = this;
        return paragraph.zzVYG.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzWWj value) {
        Cloneable cloneable = this;
        zzWWj zzWWj2 = value;
        cloneable = cloneable.zzVYG;
        ((zzMy)cloneable).zzXf9(14, zzWWj2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWWj getDeleteRevision() {
        Paragraph paragraph = this;
        return paragraph.zzVYG.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzWWj value) {
        Cloneable cloneable = this;
        zzWWj zzWWj2 = value;
        cloneable = cloneable.zzVYG;
        ((zzMy)cloneable).zzXf9(12, zzWWj2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWiz getMoveFromRevision() {
        Paragraph paragraph = this;
        return paragraph.zzVYG.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzWiz value) {
        Cloneable cloneable = this;
        zzWiz zzWiz2 = value;
        cloneable = cloneable.zzVYG;
        ((zzMy)cloneable).zzXf9(13, zzWiz2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWiz getMoveToRevision() {
        Paragraph paragraph = this;
        return paragraph.zzVYG.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzWiz value) {
        Cloneable cloneable = this;
        zzWiz zzWiz2 = value;
        cloneable = cloneable.zzVYG;
        ((zzMy)cloneable).zzXf9(15, zzWiz2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Paragraph paragraph = this;
        paragraph.zzVYG.remove(13);
        paragraph = this;
        paragraph.zzVYG.remove(15);
    }

    final boolean zzVRd() throws Exception {
        double d;
        CompositeNode compositeNode = this.zzZfS();
        if (!(compositeNode instanceof Paragraph)) {
            return false;
        }
        Paragraph paragraph = (Paragraph)compositeNode;
        ParagraphFormat paragraphFormat = this.getParagraphFormat();
        ParagraphFormat paragraphFormat2 = paragraph.getParagraphFormat();
        if (paragraphFormat2.getPageBreakBefore()) {
            return false;
        }
        Paragraph paragraph2 = paragraph;
        Paragraph paragraph3 = paragraph2;
        paragraph3 = this;
        if (paragraph2.zzXAs.zzXFM() != paragraph3.zzXAs.zzXFM()) {
            return false;
        }
        double d2 = paragraphFormat.getLeftIndent() + Math.min(paragraphFormat.getFirstLineIndent(), 0.0);
        if (d2 != (d = paragraphFormat2.getLeftIndent() + Math.min(paragraphFormat2.getFirstLineIndent(), 0.0))) {
            return false;
        }
        if (paragraphFormat.getRightIndent() != paragraphFormat2.getRightIndent()) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(1).equals(paragraphFormat2.getBorders().getByBorderType(1))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(2).equals(paragraphFormat2.getBorders().getByBorderType(2))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(3).equals(paragraphFormat2.getBorders().getByBorderType(3))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(0).equals(paragraphFormat2.getBorders().getByBorderType(0))) {
            return false;
        }
        return this.zzX1p(paragraph);
    }

    private boolean zzX1p(Paragraph paragraph) {
        Paragraph paragraph2 = paragraph;
        return this.zzXAs.zzXf9(paragraph2.zzXAs);
    }

    final Run zzWyf() {
        return (Run)this.getChild(21, 0, false);
    }

    final Run zzo8(boolean bl) {
        Run run = null;
        for (Node node = this.zzYxk(); node != null; node = node.zzYai()) {
            if (node.getNodeType() != 21 || bl && zzWAt.zzqz(node.getText())) continue;
            run = (Run)node;
        }
        return run;
    }

    final boolean zzYPG() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1;
    }

    public boolean isListItem() {
        return this.zzXCm();
    }

    public TabStop[] getEffectiveTabStops() {
        zzy7 zzy72 = this.zzWPx(0);
        int n = zzy72.zzWQV(1140) ? zzy72.getTabStops().getCount() : 0;
        TabStop[] tabStopArray = new TabStop[n];
        for (int i = 0; i < n; ++i) {
            tabStopArray[i] = zzy72.getTabStops().get(i).zzJU();
        }
        return tabStopArray;
    }

    public int joinRunsWithSameFormatting() {
        StringBuilder stringBuilder = new StringBuilder();
        Paragraph paragraph = this;
        return Paragraph.zzXQZ(paragraph, stringBuilder);
    }

    final boolean zzYoT() {
        return this.zzXCm() && this.getListLabel().zzZT1();
    }

    final boolean zzWzT() {
        return this.zzYRp() && this.getListLabel().zzXgx();
    }

    final boolean hasRevisions() {
        block3: {
            block2: {
                Paragraph paragraph = this;
                if (paragraph.zzVYG.hasRevisions()) break block2;
                paragraph = this;
                if (paragraph.zzXAs.hasRevisions()) break block2;
                paragraph = this;
                if (!paragraph.zzXAs.zzMJ()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXrh() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!zztv.zzWuo(node)) continue;
            return true;
        }
        return false;
    }

    final boolean zzYqG() {
        Iterator iterator = this.getChildNodes(0, false).iterator();
        while (iterator.hasNext()) {
            Node node;
            Node node2 = node = (Node)iterator.next();
            if (zztv.zzBI(node.getNodeType())) continue;
            return false;
        }
        return true;
    }

    final int zzYsU(StringBuilder stringBuilder) {
        return Paragraph.zzXQZ(this, stringBuilder);
    }

    private static int zzXQZ(CompositeNode compositeNode, StringBuilder stringBuilder) {
        if (stringBuilder != null) {
            stringBuilder.length();
        }
        int n = 0;
        Run run = null;
        zzYfQ zzYfQ2 = null;
        for (Node node = compositeNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node node2;
            if (node.getNodeType() == 21) {
                node2 = (Run)node;
                if (run != null) {
                    int n2 = 33;
                    Run run2 = node2;
                    zzYfQ zzYfQ3 = zztv.zzXQZ((zzZjz)run2, n2);
                    if (zzYfQ2 == null) {
                        n2 = 33;
                        run2 = run;
                        zzYfQ2 = zztv.zzXQZ((zzZjz)run2, n2);
                    }
                    if (zzYfQ.zzuZ(zzYfQ3, zzYfQ2)) {
                        if (stringBuilder.length() == 0) {
                            zzZ3F.zzfO(stringBuilder, run.getText());
                        }
                        zzZ3F.zzfO(stringBuilder, ((Run)node2).getText());
                        ++n;
                        compositeNode.removeChild(run);
                    } else {
                        Paragraph.zzXQZ(run, stringBuilder);
                        zzYfQ2 = null;
                    }
                }
                run = node2;
            } else {
                Paragraph.zzXQZ(run, stringBuilder);
                run = null;
                zzYfQ2 = null;
            }
            if (node.getNodeType() != 28) continue;
            node2 = (StructuredDocumentTag)node;
            Paragraph.zzXQZ((CompositeNode)node2, stringBuilder);
        }
        Paragraph.zzXQZ(run, stringBuilder);
        stringBuilder.length();
        return n;
    }

    private static void zzXQZ(Run run, StringBuilder stringBuilder) {
        if (run != null && stringBuilder.length() != 0) {
            run.setText(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
    }

    public Field appendField(int fieldType, boolean updateField) throws Exception {
        return this.insertField(fieldType, updateField, null, true);
    }

    public Field appendField(String fieldCode) throws Exception {
        return this.insertField(fieldCode, null, true);
    }

    public Field appendField(String fieldCode, String fieldValue) {
        return this.insertField(fieldCode, fieldValue, null, true);
    }

    public Field insertField(int fieldType, boolean updateField, Node refNode, boolean isAfter) throws Exception {
        return zztv.zzXQZ(fieldType, updateField, this.zzdK(refNode), (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, Node refNode, boolean isAfter) throws Exception {
        return zztv.zzXQZ(fieldCode, this.zzdK(refNode), (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, String fieldValue, Node refNode, boolean isAfter) {
        return zztv.zzXQZ(fieldCode, fieldValue, this.zzdK(refNode), (CompositeNode)this, refNode, isAfter);
    }

    final boolean zzXCm() {
        return (Integer)this.zzXRv(1120, 0) != 0;
    }

    final boolean zzYRp() {
        return (Integer)this.zzXRv(1120, 1) != 0;
    }

    final List zzWxU(boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = (Integer)this.zzXRv(1120, n);
        if (n2 == 0) {
            return null;
        }
        List list = this.getDocument().getLists().zzZS2(n2);
        return list;
    }

    final ListLevel zzz6(boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = (Integer)this.zzXRv(1120, n);
        if (n2 == 0) {
            return null;
        }
        List list = this.getDocument().getLists().zzZS2(n2);
        int n3 = (Integer)this.zzXRv(1110, n);
        ListLevel listLevel = list.zzZkP(n3);
        return listLevel;
    }

    final int zzpL() {
        Paragraph paragraph = this;
        zzYVQ zzYVQ2 = this.getDocument().zzXNy().zzBG(paragraph.zzXAs.zzXFM());
        int n = 0;
        while (zzYVQ2 != null) {
            if (zzYVQ2.zzWUe() == 1) {
                ++n;
            }
            zzYVQ2 = this.getDocument().zzXNy().zzBG(zzYVQ2.zzZpw());
        }
        return n;
    }

    final int zzXtP() {
        return this.zzTM;
    }

    final void zzWef(int n) {
        this.zzTM = n;
    }

    final int zzDZ() {
        return this.zzXVo;
    }

    final void zzhg(int n) {
        this.zzXVo = n;
    }

    private zzYfQ zzdK(Node node) {
        if (node == null) {
            if (this.getRuns().getCount() > 0) {
                return this.getRuns().get(this.getRuns().getCount() - 1).zzQ();
            }
        } else if (node instanceof Run && node.getParentNode() == this) {
            return ((Run)node).zzQ();
        }
        Paragraph paragraph = this;
        return paragraph.zzVYG;
    }

    private void zzXsi() {
        if (this.getDocument() == null || this.getParentSection() == null || this.getDocument().getNodeType() != 1) {
            return;
        }
        zzY7U zzY7U2 = new zzY7U();
        zzY7U2.visitDocumentStart((Document)this.getDocument());
        zzY7U2.visitSectionStart(this.getParentSection());
        zzY7U2.visitParagraphStart(this);
    }
}

