/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzWEs;
import com.aspose.words.internal.zzYzf;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzWyt;
    private boolean zzY86;
    boolean zzX98 = true;
    private boolean zzZBm = true;
    private boolean zzZBa = false;
    private boolean zzWD5;
    private boolean zzZPy = true;
    private boolean zzXix;
    private String zzYHT;
    private boolean zz4s;
    private boolean zzWvh = false;
    private int zzT2 = 1;
    private int zzZvG = 1;
    private int zzWbm = 0;
    private String zzZgC = "";
    private boolean zzZDx = true;
    private boolean zzZUg = true;
    private boolean zzZgu;
    private boolean zzZkW;
    private int zzXwN = 0;
    private boolean zzXSE = true;
    private boolean zzXIk = false;

    protected SaveOptions() {
    }

    final boolean zzYUw() {
        return this.zzWD5;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzWTC() {
        return false;
    }

    boolean zz9P() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzZPy;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzZPy = value;
    }

    public String getTempFolder() {
        return this.zzYHT;
    }

    public void setTempFolder(String value) {
        this.zzYHT = value;
    }

    public boolean getPrettyFormat() {
        return this.zzXix;
    }

    public void setPrettyFormat(boolean value) {
        this.zzXix = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zz4s;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zz4s = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWvh;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWvh = value;
    }

    public int getDmlRenderingMode() {
        return this.zzT2;
    }

    public void setDmlRenderingMode(int value) {
        this.zzT2 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzWbm;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzWbm = value;
    }

    public int getImlRenderingMode() {
        return this.zzZvG;
    }

    public void setImlRenderingMode(int value) {
        this.zzZvG = value;
    }

    public String getDefaultTemplate() {
        return this.zzZgC;
    }

    public void setDefaultTemplate(String value) {
        this.zzZgC = value;
    }

    public boolean getUpdateFields() {
        return this.zzZDx;
    }

    public void setUpdateFields(boolean value) {
        this.zzZDx = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzZgu;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzZgu = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZkW;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZkW = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzXIk;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzXIk = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzZBa;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzZBa = value;
    }

    final boolean zzW9Y() {
        return this.zzZUg;
    }

    final boolean zzX8M() {
        return this.zzXSE;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzZdb(zzYzf.zzBB(zzWEs.zzub(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzXwN;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzXwN = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzWyt;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzWyt = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzY86;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzY86 = value;
    }

    final boolean zzZhg() {
        return this.zzZBm;
    }

    final void zzPA(boolean bl) {
        this.zzZBm = false;
    }
}

