/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzWAt;
import com.aspose.words.internal.zzZ3F;
import com.aspose.words.zzX4d;
import com.aspose.words.zzZhJ;
import com.aspose.words.zzoD;

public final class Section
extends CompositeNode<Node>
implements zzoD {
    private zzX4d zzWAd;
    private PageSetup zzXme;
    private HeaderFooterCollection zzZ5q;

    public Section(DocumentBase doc) {
        this(doc, new zzX4d());
    }

    Section(DocumentBase doc, zzX4d sectPr) {
        super(doc);
        this.zzWAd = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzZ5q == null) {
            this.zzZ5q = new HeaderFooterCollection(this);
        }
        return this.zzZ5q;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXme == null) {
            Section section = this;
            this.zzXme = new PageSetup(section, section.getDocument().zzeV(), this.getDocument().getStyles(), new zzXQZ(this));
        }
        return this.zzXme;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzYgk();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYqF(!value);
    }

    final zzX4d zzZlP() {
        return this.zzWAd;
    }

    final void zzZfH(zzX4d zzX4d2) {
        this.zzWAd = zzX4d2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXQZ(boolean bl, zzZhJ zzZhJ2) {
        zzX4d zzX4d2;
        Section section = (Section)super.zzXQZ(bl, zzZhJ2);
        zzX4d zzX4d3 = this.zzWAd;
        section.zzWAd = zzX4d2 = (zzX4d)zzX4d3.zzXV9();
        section.zzXme = null;
        section.zzZ5q = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXQZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzfO(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzXRc(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzXRc(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzY2N(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzw1(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzY2N(n) == null;
            }
        }
        return false;
    }

    final void zzZfH(Shape shape, boolean bl) throws Exception {
        this.zzXQZ(shape, 4, bl);
        this.zzXQZ(shape, 0, bl);
        this.zzXQZ(shape, 1, bl);
    }

    private void zzXQZ(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzUf());
        shape2.setName(zzWAt.zzfO("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzXBU() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzYu1()) {
                if (!shape.zzXl0()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzXRc(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzfO(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzWAd.zzb3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzeV().zzYNN.zzWht(key);
        }
        return zzX4d.zzWuM(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzWAd.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzeV().zzYNN.zzXf9(key, value);
            return;
        }
        this.zzWAd.zzXf9(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzWAd.clear();
    }

    final boolean zzYEV() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZj1() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzWAd.getSectionStart());
        return zzWAt.zzfO("{0} {1}", objectArray);
    }

    static final class zzXQZ
    implements zzoD {
        private Section zzZNt;

        zzXQZ(Section section) {
            this.zzZNt = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzYfN().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzYfN().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzYfN().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzoD zzYfN() {
            Document document = zzZ3F.zzXQZ((Object)this.zzZNt.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzZNt;
        }
    }
}

