/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzUJ;
import com.aspose.words.internal.zzWAt;
import com.aspose.words.internal.zzX9d;
import com.aspose.words.internal.zzXp3;
import com.aspose.words.internal.zzYVQ;
import com.aspose.words.internal.zzZ3F;
import com.aspose.words.zzH3;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzY1P;
    private zzH3 zzXBr;

    Watermark(Document doc, zzH3 watermarkProvider) {
        this.zzY1P = doc;
        this.zzXBr = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzCE(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXQZ(text, textWatermarkOptions, this.zzY1P);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZ3F.zzfO((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzY1P, 75);
        shape.getImageData().setImage(image);
        this.zzXQZ(shape, options, this.zzY1P);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZ3F.zzfO((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzY1P, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXQZ(shape, options, this.zzY1P);
    }

    public final int getType() {
        Shape shape = this.zzXBr.get();
        if (shape == null) {
            return 2;
        }
        shape.zzXl0();
        if (shape.zzWI3()) {
            return 0;
        }
        if (shape.zzVWO()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzXBr.add(shape);
    }

    public final void remove() {
        this.zzXBr.remove();
    }

    private static void zzCE(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzUJ.zzWM7(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZ3F.zzXQZ(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXQZ(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzfO(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzuZ(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzfO(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzXhP() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzW2a()) / d2) > (double)(f = pageSetup.zzWIG())) {
            d = (double)f / d3;
        }
        shape.zzva(zzYVQ.zzZfH(d2 * d, 2, 1));
        shape.zzXHf(zzYVQ.zzZfH(d3 * d, 2, 1));
    }

    private Shape zzXQZ(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXQZ(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzuZ(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXQZ(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzXoc() ? 1.0f : textWatermarkOptions.getFontSize();
        zzX9d zzX9d2 = document.zzYcT().zzZfH(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzX9d2.zzXiM(shape.getTextPath().getText());
        if (textWatermarkOptions.zzXoc()) {
            l = Watermark.zzXQZ(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzva(zzYVQ.zzZfH(Float.intBitsToFloat(n), 2, 1));
        shape.zzXHf(zzYVQ.zzZfH(zzXp3.zzX1p(l), 2, 1));
    }

    private static long zzXQZ(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzW2a();
        float f2 = pageSetup.zzWIG();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzXp3.zzX1p(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzXp3.zzVX9(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzXp3.zzX1p(l) >= Float.intBitsToFloat(n)) {
            return zzXp3.zzVX9(f2 / f3, f2);
        }
        float f6 = f;
        return zzXp3.zzVX9(f6, f6 * f3);
    }

    private static void zzuZ(Shape shape, String string) {
        shape.setName(zzWAt.zzfO("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

