/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWAt;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzYAP = new ArrayList();
    private final Map<String, DataColumn> zzW1p = new HashMap<String, DataColumn>();
    private DataTable zzJz;

    DataColumnCollection(DataTable table) {
        this.zzJz = table;
    }

    public void add(DataColumn column) {
        if (zzWAt.zzqz(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzZku(column.getColumnName());
        if (this.zzW1p.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzXRc(this.zzJz);
        column.setOrdinal(this.zzYAP.size());
        this.zzYAP.add(column);
        this.zzW1p.put(string, column);
        this.zzJz.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzJz);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzJz);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzWAt.zzqz(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzZku(columnName);
        DataColumn dataColumn = this.zzW1p.get(string);
        if (dataColumn != null) {
            int n = this.zzYAP.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzYAP.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzYAP.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzYAP.remove(n);
            this.zzW1p.remove(DataColumnCollection.zzZku(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzJz.getRows()) {
                dataRow.remove(n);
            }
            this.zzJz.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzYAP.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzYAP.iterator();
    }

    public void clear() {
        this.zzW1p.clear();
        this.zzYAP.clear();
    }

    final DataColumn[] zzVt() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzYAP);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzXQZ(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzYAP.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzYAP.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzZku(string);
            String string3 = DataColumnCollection.zzZku(dataColumn.getColumnName());
            this.zzW1p.remove(string3);
            this.zzW1p.put(string2, dataColumn);
            return;
        }
    }

    private static String zzZku(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

