/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWDO;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzZDB;
import com.aspose.words.net.System.Data.zzZfH;
import com.aspose.words.net.System.Data.zzfO;
import com.aspose.words.net.System.Data.zzw1;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXfg;
    private final DataColumnCollection zzZv6;
    private final ConstraintCollection zzCs;
    private final zzZDB zzYIQ;
    private ResultSet zzZ0O;
    private String zzZw7;
    private DataSet zzWaH;
    private String zzWh8;
    private UniqueConstraint zzXWP;
    private boolean zzWZL;
    private final List<DataTableEventListener> zzZms;
    private final Set<DataRow> zzWP2;
    private DataRelationCollection zzlT;

    public DataTable() {
        this.zzXfg = new DataRowCollection(this);
        this.zzZv6 = new DataColumnCollection(this);
        this.zzCs = new ConstraintCollection(this);
        this.zzYIQ = new zzZDB(this);
        this.zzWh8 = "";
        this.zzWZL = true;
        this.zzZms = new ArrayList<DataTableEventListener>();
        this.zzWP2 = new HashSet<DataRow>();
        this.zzlT = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzXfg = new DataRowCollection(this);
        this.zzZv6 = new DataColumnCollection(this);
        this.zzCs = new ConstraintCollection(this);
        this.zzYIQ = new zzZDB(this);
        this.zzWh8 = "";
        this.zzWZL = true;
        this.zzZms = new ArrayList<DataTableEventListener>();
        this.zzWP2 = new HashSet<DataRow>();
        this.zzlT = new DataRelationCollection();
        this.zzZw7 = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzfO.zzXQZ(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzXfg = new DataRowCollection(this);
        this.zzZv6 = new DataColumnCollection(this);
        this.zzCs = new ConstraintCollection(this);
        this.zzYIQ = new zzZDB(this);
        this.zzWh8 = "";
        this.zzWZL = true;
        this.zzZms = new ArrayList<DataTableEventListener>();
        this.zzWP2 = new HashSet<DataRow>();
        this.zzlT = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzZ0O = resultSet;
        this.zzZw7 = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzZ0O != null) {
            if (this.zzZ0O.getStatement() != null) {
                this.zzZ0O.getStatement().getConnection().close();
            }
            this.zzZ0O = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZw7;
    }

    public void setTableName(String tableName) {
        this.zzZw7 = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzZv6.getCount();
    }

    public String getColumnName(int index) {
        return this.zzZv6.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzZ0O;
    }

    public DataSet getDataSet() {
        return this.zzWaH;
    }

    final void zzXRc(DataSet dataSet) {
        this.zzWaH = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzWaH.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzlT.add(dataRelation);
        }
        return this.zzlT;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzWaH.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzXfg;
    }

    public DataColumnCollection getColumns() {
        return this.zzZv6;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzCs;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzXWP == null) {
            return new DataColumn[0];
        }
        return this.zzXWP.getColumns();
    }

    final void zzZDB(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzXWP != null) {
                this.zzXWP.zzZIc(false);
                this.getConstraints().remove(this.zzXWP);
                this.zzXWP = null;
            }
            return;
        }
        if (this.zzXWP != null && DataColumn.areColumnSetsTheSame(value, this.zzXWP.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXQZ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzXWP != null) {
            this.zzXWP.zzZIc(false);
            this.getConstraints().remove(this.zzXWP);
            this.zzXWP = null;
        }
        UniqueConstraint.zzXQZ(this.getConstraints(), uniqueConstraint);
        this.zzXWP = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzWh8;
    }

    public void setNamespace(String namespace) {
        this.zzWh8 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzWZL;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzWZL = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzWP2.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzfO.zzXQZ(this.getResultSet(), this);
            zzfO.zzfO(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzWDO.zzXRc(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzfO.zzuZ(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzZms.contains(listener)) {
            this.zzZms.add(listener);
        }
    }

    public void removeEventListener(zzZfH listener) {
        if (this.zzZms.contains(listener)) {
            this.zzZms.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzZms.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzWP2.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZms) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzWP2.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZms) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzWP2.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZms) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZms) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZms) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzw1 zzXQZ(zzfO[] zzfOArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzfOArray.length];
        for (int i = 0; i < zzfOArray.length; ++i) {
            dataColumnArray[i] = zzfOArray[i].zzXLV();
        }
        DataTable dataTable = this;
        zzw1 zzw12 = dataTable.zzYIQ.zzXRc(dataColumnArray);
        if (zzw12 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzw12;
    }

    final zzZDB zzZmF() {
        return this.zzYIQ;
    }

    final Set<DataRow> zzXJw() {
        return this.zzWP2;
    }
}

