/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzYWV;
import com.aspose.words.zzIp;
import com.aspose.words.zzVY4;
import com.aspose.words.zzW3B;
import com.aspose.words.zzWwH;
import com.aspose.words.zzXNd;
import com.aspose.words.zzXm3;
import com.aspose.words.zzXw5;
import com.aspose.words.zzY49;
import com.aspose.words.zzYdu;
import com.aspose.words.zzuY;

public class Cell
extends CompositeNode<Node>
implements zzW3B,
zzWwH {
    private zzXNd zzXYX;
    private CellFormat zzZEo;
    private ParagraphCollection zzYWr;
    private TableCollection zzYwO;

    public Cell(DocumentBase doc) {
        this(doc, new zzXNd());
    }

    Cell(DocumentBase doc, zzXNd cellPr) {
        super(doc);
        this.zzXYX = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzZ6m();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzXEU();
    }

    public Row getParentRow() {
        return (Row)this.zzWQP();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzZHp() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzX4P(this, true);
        }
        return -1;
    }

    final int zz72() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zz72();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzZEo == null) {
            this.zzZEo = new CellFormat(this);
        }
        return this.zzZEo;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzYWr == null) {
            this.zzYWr = new ParagraphCollection(this);
        }
        return this.zzYWr;
    }

    public TableCollection getTables() {
        if (this.zzYwO == null) {
            this.zzYwO = new TableCollection(this);
        }
        return this.zzYwO;
    }

    final zzXNd zzTQ() {
        return this.zzXYX;
    }

    final void zzYON(zzXNd zzXNd2) {
        this.zzXYX = zzXNd2;
    }

    @Override
    final Node zzYON(boolean bl, zzVY4 zzVY42) {
        zzXNd zzXNd2;
        Cell cell = (Cell)super.zzYON(bl, zzVY42);
        zzXNd zzXNd3 = this.zzXYX;
        cell.zzXYX = zzXNd2 = (zzXNd)zzXNd3.zzXC3();
        cell.zzZEo = null;
        cell.zzYWr = null;
        cell.zzYwO = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzXw5.zzy6(this);
    }

    @Override
    final boolean zzWqY(Node node) {
        return zzuY.zzTG(node);
    }

    final int zzZM9() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXYX.zzXCF(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzXYX.zzXCF(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzXm3 zzXm32 = zzYWV.zzYON(object, zzXm3.class);
        if (zzXm32 != null && zzXm32.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZY8(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzXNd.zzYjA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzXYX.zzkw(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXYX.clear();
    }

    private Object zzZY8(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzYWV.zzYON((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzYON(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzY49 getInsertRevision() {
        Cell cell = this;
        return cell.zzXYX.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzY49 value) {
        Cloneable cloneable = this;
        zzY49 zzY492 = value;
        cloneable = cloneable.zzXYX;
        ((zzIp)cloneable).zzkw(14, zzY492);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzY49 getDeleteRevision() {
        Cell cell = this;
        return cell.zzXYX.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzY49 value) {
        Cloneable cloneable = this;
        zzY49 zzY492 = value;
        cloneable = cloneable.zzXYX;
        ((zzIp)cloneable).zzkw(12, zzY492);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYdu getMoveFromRevision() {
        Cell cell = this;
        return cell.zzXYX.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzYdu value) {
        Cloneable cloneable = this;
        zzYdu zzYdu2 = value;
        cloneable = cloneable.zzXYX;
        ((zzIp)cloneable).zzkw(13, zzYdu2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYdu getMoveToRevision() {
        Cell cell = this;
        return cell.zzXYX.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzYdu value) {
        Cloneable cloneable = this;
        zzYdu zzYdu2 = value;
        cloneable = cloneable.zzXYX;
        ((zzIp)cloneable).zzkw(15, zzYdu2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzXYX.remove(13);
        cell = this;
        cell.zzXYX.remove(15);
    }

    final zzXNd zzWkG(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzXNd zzXNd2 = new zzXNd();
        this.zzYON(3120, zzXNd2);
        this.zzYON(3140, zzXNd2);
        this.zzYON(3110, zzXNd2);
        this.zzYON(3130, zzXNd2);
        this.zzYON(3090, zzXNd2);
        this.zzYON(3100, zzXNd2);
        this.zzYON(3070, zzXNd2);
        this.zzYON(3080, zzXNd2);
        if (bl && (tableStyle = zzYWV.zzYON((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzVVX(this, zzXNd2);
        }
        this.zzXYX.zzVVX((zzIp)zzXNd2);
        return zzXNd2;
    }

    private void zzYON(int n, zzXNd zzXNd2) {
        zzXNd2.zzkw(n, this.fetchInheritedCellAttr(n));
    }
}

