/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzZTN;
import com.aspose.words.zzVS2;
import com.aspose.words.zzWEN;
import com.aspose.words.zzWEr;
import com.aspose.words.zzWI9;
import com.aspose.words.zzWVY;
import com.aspose.words.zzWoB;
import com.aspose.words.zzXVj;
import com.aspose.words.zzZRf;
import com.aspose.words.zzZoy;
import com.aspose.words.zzZtu;
import com.aspose.words.zzqN;
import com.aspose.words.zzuY;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzWEr zzZOY;

    ChartSeriesCollection(zzWEr chartSpace) {
        this.zzZOY = chartSpace;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWIQ().zzYAY().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWIQ().zzYAY().iterator();
    }

    public void removeAt(int index) {
        this.zzWIQ().zzVUs(index);
    }

    public void clear() {
        this.zzWIQ().zzWEs();
        for (zzWVY zzWVY2 : this.zzZOY.zzZjk()) {
            zzWVY2.zzFo(false);
        }
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYON(chartSeriesCollection.zzWIQ().zzYPy(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYON(chartSeriesCollection.zzWIQ().zzYPy(), seriesName, xValues, yValues);
    }

    private ChartSeries zzYON(String string, zzZTN[] zzZTNArray, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYON(chartSeriesCollection.zzWIQ().zzYPy(), string, zzZTNArray, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzYON(seriesName, zzZTN.zzYON(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYON(chartSeriesCollection.zzWIQ().zzYPy(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzYON(zzWVY zzWVY2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYON(zzWVY2, string, dArray);
        chartSeries.zzX57().zzXMu(ChartSeriesCollection.zzZ1d(stringArray));
        return chartSeries;
    }

    final ChartSeries zzYON(zzWVY zzWVY2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYON(zzWVY2, string, dArray2);
        chartSeries.zzX57().zzXMu(ChartSeriesCollection.zzWqY(dArray));
        return chartSeries;
    }

    private ChartSeries zzYON(zzWVY zzWVY2, String string, zzZTN[] zzZTNArray, double[] dArray) {
        if (zzZTNArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzZTNArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzZTNArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYON(zzWVY2, string, dArray);
        chartSeries.zzX57().zzXMu(ChartSeriesCollection.zzYON(zzZTNArray));
        if (!zzWVY2.zzZGz()) {
            zzWVY2.zzFo(true);
        }
        return chartSeries;
    }

    final ChartSeries zzYON(zzWVY zzWVY2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzWVY2.zzYZ7() != 15) {
            zzWVY2.zzX8L(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzYON(zzWVY2, string, dArray2);
        chartSeries.zzZDR().zzZIP().zzXN3(3, chartSeries.zzWa4().zzWrG());
        chartSeries.zzX57().zzXMu(ChartSeriesCollection.zzWqY(dArray));
        if (dArray3 != null) {
            chartSeries.zzVZ3().zzXMu(ChartSeriesCollection.zzWqY(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzYON(zzWVY zzWVY2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzWVY2);
        chartSeries.setName(string);
        ChartSeriesCollection.zzXAw(chartSeries);
        chartSeries.zzZBV().zzXMu(ChartSeriesCollection.zzWqY(dArray));
        this.zzZOY.zzYJm();
        this.zzWIQ().zzWXY(chartSeries);
        return chartSeries;
    }

    private static void zzXAw(ChartSeries chartSeries) {
        chartSeries.zzZDR().zzZIP().zzXN3(5, new zzZRf());
        if (ChartDataPointCollection.zzqN(chartSeries.zzWa4().zzYZ7())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzWa4().zzYZ7()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzYON(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzYON(chartSeries, 5);
                ChartSeriesCollection.zzW28(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzYON(chartSeries, 1);
                ChartSeriesCollection.zzW28(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzkw(chartSeries);
            }
        }
    }

    private static void zzkw(ChartSeries chartSeries) {
        zzZRf zzZRf2 = new zzZRf();
        zzZRf2.setOutline(new zzZtu());
        zzWI9 zzWI92 = new zzWI9();
        zzWI92.zzA9(1);
        zzZRf2.getOutline().setFill(new zzWEN(zzWI92));
        zzZRf2.getOutline().zzXEy(19050.0);
        chartSeries.zzZDR().zzZIP().zzXN3(5, zzZRf2);
    }

    private static void zzW28(ChartSeries chartSeries) {
        zzZRf zzZRf2 = new zzZRf();
        zzZRf2.setOutline(new zzZtu());
        zzZRf2.getOutline().setFill(new zzWoB());
        zzZRf2.getOutline().setEndCap(0);
        zzZRf2.getOutline().zzXEy(19050.0);
        chartSeries.zzZDR().zzZIP().zzXN3(5, zzZRf2);
    }

    private static void zzYON(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzWa4());
        chartMarker.zztr().zzXN3(0, n);
        chartSeries.zzZDR().zzZIP().zzXN3(4, chartMarker);
    }

    private static zzXVj zzWqY(double[] dArray) {
        int n = 0;
        zzXVj zzXVj2 = new zzXVj(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzXVj2.zzX8V(new zzVS2(n, d, "General"));
            }
            ++n;
        }
        zzXVj2.zzWDe(dArray.length);
        return zzXVj2;
    }

    private static zzXVj zzYON(zzZTN[] zzZTNArray) {
        int n = 0;
        zzXVj zzXVj2 = new zzXVj(2);
        zzZTN[] zzZTNArray2 = zzZTNArray;
        int n2 = zzZTNArray.length;
        for (int i = 0; i < n2; ++i) {
            zzZTN zzZTN2 = zzZTNArray2[i];
            zzXVj2.zzX8V(new zzVS2(n++, zzuY.zzV1(zzZTN2), "m/d/yyyy"));
        }
        zzXVj2.zzWDe(zzZTNArray.length);
        return zzXVj2;
    }

    private static zzXVj zzZ1d(String[] stringArray) {
        int n = 0;
        zzXVj zzXVj2 = new zzXVj(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzXVj2.zzX8V(new zzqN(n++, string));
        }
        zzXVj2.zzWDe(stringArray.length);
        return zzXVj2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWIQ().zzYAY().size();
    }

    private zzZoy zzWIQ() {
        return this.zzZOY.zzVU6().zzWIQ();
    }
}

