/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzYWV;
import com.aspose.words.zzBU;
import com.aspose.words.zzVY4;
import com.aspose.words.zzWn1;
import com.aspose.words.zzXdh;
import com.aspose.words.zzXfs;
import com.aspose.words.zzY1;
import com.aspose.words.zzZNr;
import com.aspose.words.zzbQ;
import com.aspose.words.zzuY;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzWn1,
Iterable<V> {
    private Node zzXTd;
    private Node zzXpq;
    private Node zzW0G;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzXdh zzXdh2 = new zzXdh(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzYhC(this, true);
            return;
        }
        finally {
            zzXdh2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzgx() {
        return this.zzWaS() != null;
    }

    final boolean zzXRu() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzWm8() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzY1) {
                return true;
            }
            CompositeNode compositeNode = zzYWV.zzYON((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzWm8()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzXTd;
    }

    public Node getLastChild() {
        return this.zzXpq;
    }

    final Node zzWaS() {
        return zzuY.zzX8V(this.getFirstChild(), false);
    }

    final Node zzVP6() {
        return zzuY.zzXAw(this.getLastChild(), false);
    }

    final CompositeNode zzZHO() {
        return (CompositeNode)zzuY.zzX8V(this.getFirstChild(), true);
    }

    final CompositeNode zzYFO() {
        return (CompositeNode)zzuY.zzXAw(this.getLastChild(), true);
    }

    final Node zzYSi() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzuY.zzYq2((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzVSE() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzuY.zzYq2((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzYON(boolean bl, zzVY4 zzVY42) {
        CompositeNode compositeNode = (CompositeNode)super.zzYON(bl, zzVY42);
        ((CompositeNode)super.zzYON(bl, zzVY42)).zzXpq = null;
        compositeNode.zzXTd = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzy6(node.zzYON(true, zzVY42));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzEv(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzEv(StringBuilder stringBuilder) {
        this.zzWXY(stringBuilder);
        zzYWV.zzVVX(stringBuilder, this.zzXQJ());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzVVX(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzuY.zzWy1(nodeType);
            Node node2 = node = bl ? this.zzWaS() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzMn() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZNr.zzYhC(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZNr.zzX4P(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzXfs(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzYON(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzYON(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzYhC(oldChild, false);
    }

    private <T extends Node> T zzYhC(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = CompositeNode.zzYON(documentBase, t, this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzZcy() && zzuY.zzWYR(t)) {
            return t;
        }
        CompositeNode.zzYON(documentBase, nodeChangingArgs);
        if (!bl && zzuY.zzYZm(t)) {
            zzuY.zzW28(t, false);
        }
        T t2 = this.zzSs(t);
        CompositeNode.zzVVX(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzBU.zzZyu(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzy6(Node node) {
        node.getParentNode();
        if (this.zzXpq == null) {
            node.zzZjn(null);
            node.zzZF2(null);
            this.zzXTd = node;
        } else {
            node.zzZjn(this.zzXpq);
            node.zzZF2(null);
            this.zzXpq.zzZF2(node);
        }
        this.zzXpq = node;
        node.zzlT(this);
        return node;
    }

    final void zzYON(Node node, Node node2, Node node3) {
        this.zzYON(node, node2, node3, false);
    }

    final void zzYON(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzWqY(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzVVX(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzX4P(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzuY.zzYq2(node3.getNodeType())) continue;
            if (zzuY.zzWqY(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzXQJ().length();
    }

    String zzXQJ() {
        return "";
    }

    final String zzXSf() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWXY(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzWXY(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzEv(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzWqY(Node node) {
        return true;
    }

    private static NodeChangingArgs zzYON(DocumentBase documentBase, Node node, Node node2, Node node3, int n) {
        return documentBase.zzYON(node, node2, node3, n);
    }

    private static void zzYON(DocumentBase documentBase, NodeChangingArgs nodeChangingArgs) {
        if (nodeChangingArgs != null) {
            documentBase.zzYON(nodeChangingArgs);
        }
    }

    private static void zzVVX(DocumentBase documentBase, NodeChangingArgs nodeChangingArgs) {
        if (nodeChangingArgs != null) {
            documentBase.zzVVX(nodeChangingArgs);
        }
    }

    final <T extends Node> T zzYON(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYmY(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (t.getNodeType() != 37 && !this.zzWqY(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzbQ(documentBase);
            try {
                compositeNode.zzYhC(t, true);
            }
            finally {
                ((zzbQ)object).dispose();
            }
        }
        object = CompositeNode.zzYON(documentBase, t, null, this, 0);
        CompositeNode.zzYON(documentBase, (NodeChangingArgs)object);
        if (this.zzXpq == null) {
            t.zzZjn(null);
            t.zzZF2(null);
            this.zzXTd = t;
            this.zzXpq = t;
        } else if (bl) {
            if (node != null) {
                this.zzVVX(t, node);
            } else {
                this.zzYhC(t, this.zzXTd);
            }
        } else if (node != null) {
            this.zzYhC(t, node);
        } else {
            this.zzVVX(t, this.zzXpq);
        }
        t.zzlT(this);
        CompositeNode.zzVVX(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzZcy()) {
            zzuY.zzYON(t, compositeNode, node2);
        }
        return t;
    }

    private void zzVVX(Node node, Node node2) {
        Node node3 = node2.zzZ2C();
        node.zzZjn(node2);
        node.zzZF2(node3);
        node2.zzZF2(node);
        if (node3 == null) {
            this.zzXpq = node;
            return;
        }
        node3.zzZjn(node);
    }

    private void zzYhC(Node node, Node node2) {
        Node node3 = node2.zzW0();
        node.zzZjn(node3);
        node.zzZF2(node2);
        node2.zzZjn(node);
        if (node3 == null) {
            this.zzXTd = node;
            return;
        }
        node3.zzZF2(node);
    }

    private <T extends Node> T zzSs(T t) {
        if (t == this.zzXTd) {
            if (this.zzXTd == this.zzXpq) {
                this.zzXTd = null;
                this.zzXpq = null;
            } else {
                this.zzXTd = t.zzZ2C();
                this.zzXTd.zzZjn(null);
            }
        } else {
            Node node = t.zzW0();
            Node node2 = t.zzZ2C();
            node.zzZF2(node2);
            if (node2 == null) {
                this.zzXpq = node;
            } else {
                node2.zzZjn(node);
            }
        }
        t.zzZF2(null);
        t.zzZjn(null);
        t.zzlT(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzW0G = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzW0G;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

