/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzLF;
import com.aspose.words.internal.zzUB;
import com.aspose.words.internal.zzXlc;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.internal.zzY46;
import com.aspose.words.internal.zzYO7;
import com.aspose.words.internal.zzYWV;
import com.aspose.words.internal.zzYeG;
import com.aspose.words.internal.zzYht;
import com.aspose.words.internal.zzZk6;
import com.aspose.words.internal.zzav;
import com.aspose.words.internal.zzdR;
import com.aspose.words.zzWYz;
import com.aspose.words.zzWjF;
import com.aspose.words.zzX7F;
import com.aspose.words.zzXro;
import com.aspose.words.zzYR6;
import com.aspose.words.zzYVx;
import com.aspose.words.zzYYK;
import com.aspose.words.zzZyf;
import com.aspose.words.zzkp;
import com.aspose.words.zzyU;
import com.aspose.words.zzzg;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzYON(zzav zzav2, zzav zzav3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzYWV.zzVVX((Object)zzav2, "srcStream");
        zzYWV.zzVVX((Object)zzav3, "dstStream");
        zzYWV.zzVVX((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzVVX(zzav2, zzav3, certificateHolder, signOptions);
        zzav3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzYON(zzav.zzVVX(srcStream), (zzav)zzav.zzYhC(dstStream), certHolder, signOptions);
    }

    private static void zzVVX(zzav zzav2, zzav zzav3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzYhC(digitalSignature);
        }
        if (zzkp.zzvl(zzav2)) {
            DigitalSignatureUtil.zzYON(zzav2, zzav3, digitalSignature, true);
            return;
        }
        zzkp zzkp2 = new zzkp();
        zzav zzav4 = zzav2;
        zzkp zzkp3 = zzkp2;
        FileFormatInfo fileFormatInfo = zzkp2.zzVVX(zzav4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzUB zzUB2 = new zzUB(zzav2);
                int n = fileFormatInfo.zzXPg() == 1 ? 1 : 2;
                zzyU.zzYON(zzUB2, digitalSignature, n);
                zzav3.zzSs(0L);
                zzUB2.zzWXY(zzav3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzYON(fileFormatInfo.zzYMm(), zzav3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzYON(zzav2, zzav3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzYON(zzav2, zzav3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzYWV.zzYhC(srcFileName, "srcFileName");
        zzYWV.zzYhC(dstFileName, "dstFileName");
        try (zzZk6 zzZk62 = zzYWV.zzVVX(srcFileName, 3, 1);){
            try (zzZk6 zzZk63 = zzYWV.zzVVX(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYON((zzav)zzZk62, (zzav)zzZk63, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYeG zzYeG2 = zzav.zzYhC(dstStream);
        zzav zzav2 = zzav.zzVVX(srcStream);
        DigitalSignatureUtil.zzYON(zzav2, (zzav)zzYeG2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzZk6 zzZk62 = zzYWV.zzVVX(srcFileName, 3, 1);){
            try (zzZk6 zzZk63 = zzYWV.zzVVX(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXMu(zzZk62, zzZk63);
            }
            return;
        }
    }

    private static void zzXMu(zzav zzav2, zzav zzav3) throws Exception {
        zzkp zzkp2 = new zzkp();
        zzav zzav4 = zzav2;
        Object object = zzkp2;
        FileFormatInfo fileFormatInfo = zzkp2.zzVVX(zzav4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzUB zzUB2 = new zzUB(zzav2);
                zzUB2.zzLG().zzZTh("_xmlsignatures");
                zzUB2.zzLG().zzZTh("_signatures");
                zzav3.zzqS(0L);
                zzUB2.zzWXY(zzav3);
                zzav zzav5 = zzav3;
                zzav5.zzSs(zzav5.zzXH0());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzY46 zzY462 = new zzY46(zzav2);
                zzXlc zzXlc2 = zzY462.zzYON(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXlc2 != null) {
                    for (zzYht zzYht2 : zzXlc2.zzWgz()) {
                        String string = zzXlc2.zzYON(zzYht2);
                        zzY462.zzWG1().remove(string);
                    }
                    zzY462.zzWG1().remove(zzXlc2.getName());
                    zzYht zzYht3 = zzY462.zzWgz().zzW0D("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzY462.zzWgz().remove(zzYht3.getId());
                    zzY462.zzYAO();
                }
                zzav3.zzqS(0L);
                zzY462.zzWXY(zzav3);
                zzav zzav6 = zzav3;
                zzav6.zzSs(zzav6.zzXH0());
                return;
            }
            case 60: 
            case 61: {
                zzYYK zzYYK2 = new zzYYK(zzav2);
                zzYR6 zzYR62 = zzYYK2.zzXSv("/META-INF/documentsignatures.xml");
                if (zzYR62 != null) {
                    zzYYK2.zzYl9().remove(zzYR62.getName());
                }
                zzav3.zzqS(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzav4 = zzav3;
                object = zzYYK2;
                ((zzYYK)object).zzYON(zzav4, string, null);
                zzav zzav7 = zzav3;
                zzav7.zzSs(zzav7.zzXH0());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzXMu(zzav.zzVVX(srcStream), zzav.zzYhC(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzZk6 zzZk62 = zzYWV.zzVVX(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzZ4s(zzZk62);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzZ4s(zzav zzav2) throws Exception {
        if (zzkp.zzvl(zzav2)) {
            return DigitalSignatureUtil.zzWGI(zzav2);
        }
        zzkp zzkp2 = new zzkp();
        zzav zzav3 = zzav2;
        zzkp zzkp3 = zzkp2;
        FileFormatInfo fileFormatInfo = zzkp2.zzVVX(zzav3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzav2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzZ4s(zzav.zzVVX(stream));
    }

    static zzLF zzYON(zzUB zzUB2, String string) throws Exception {
        zzWjF zzWjF2 = new zzWjF(zzUB2);
        if (zzWjF2.zzs4()) {
            zzLF zzLF2 = zzWjF2.zzZ6p(string);
            return zzLF2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzYyE(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzYO7.zzVVX("Unexpected digest algorithm: {0}.", n));
    }

    static String zzWeG(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzYyE(n);
    }

    private static void zzYON(zzav zzav2, zzav zzav3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzY46 zzY462 = new zzY46(zzav2);
        zzXro zzXro2 = bl ? new zzZyf(zzY462) : new zzWYz(zzY462);
        zzXro2.zzVVX(digitalSignature);
        zzav3.zzSs(0L);
        zzY462.zzWXY(zzav3);
    }

    private static void zzYON(zzav zzav2, zzav zzav3, DigitalSignature digitalSignature) throws Exception {
        zzYYK zzYYK2 = new zzYYK(zzav2);
        zzzg zzzg2 = new zzzg(zzYYK2);
        zzzg2.zzVVX(digitalSignature);
        zzav3.zzSs(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzav zzav4 = zzav3;
        zzYYK zzYYK3 = zzYYK2;
        zzYYK3.zzYON(zzav4, string, null);
    }

    private static void zzYON(zzUB zzUB2, zzav zzav2, DigitalSignature digitalSignature, String string) throws Exception {
        zzLF zzLF2 = DigitalSignatureUtil.zzYON(zzUB2, string);
        zzLF zzLF3 = new zzLF();
        DigitalSignatureUtil.zzYON((zzav)zzLF2, (zzav)zzLF3, digitalSignature, false);
        zzUB zzUB3 = zzWjF.zzXMu(zzLF3, string);
        zzUB3.zzWXY(zzav2);
    }

    private static DigitalSignatureCollection zzWGI(zzav zzav2) throws Exception {
        zzav2.zzqS(0L);
        zzY46 zzY462 = new zzY46(zzav2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXlc zzXlc2 = zzY462.zzYON(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXlc2 != null) {
            for (zzYht zzYht2 : zzXlc2.zzWgz()) {
                String string = zzXlc2.zzYON(zzYht2);
                zzXlc zzXlc3 = zzY462.zzZ16(string);
                zzXlc zzXlc4 = zzY462.zzYON(zzXlc3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzdR zzdR2 = zzXwP.zzYiR(zzXlc4.zzZEB().zzY8C());
                zzX7F.zzYON(zzXlc3.zzgI(), zzdR2, new zzYVx(zzY462), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

