/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzLF;
import com.aspose.words.internal.zzPm;
import com.aspose.words.internal.zzWOS;
import com.aspose.words.internal.zzWc1;
import com.aspose.words.internal.zzX04;
import com.aspose.words.internal.zzX10;
import com.aspose.words.internal.zzXNZ;
import com.aspose.words.internal.zzXo3;
import com.aspose.words.internal.zzY0N;
import com.aspose.words.internal.zzYCe;
import com.aspose.words.internal.zzYO7;
import com.aspose.words.internal.zzYRr;
import com.aspose.words.internal.zzYWV;
import com.aspose.words.internal.zzZTw;
import com.aspose.words.internal.zzZWA;
import com.aspose.words.internal.zzZY2;
import com.aspose.words.internal.zzav;
import com.aspose.words.internal.zzow;
import com.aspose.words.zzIp;
import com.aspose.words.zzVRz;
import com.aspose.words.zzVXP;
import com.aspose.words.zzW2J;
import com.aspose.words.zzW3B;
import com.aspose.words.zzWBL;
import com.aspose.words.zzWEY;
import com.aspose.words.zzWJ3;
import com.aspose.words.zzWWD;
import com.aspose.words.zzWas;
import com.aspose.words.zzWeP;
import com.aspose.words.zzWif;
import com.aspose.words.zzWv4;
import com.aspose.words.zzWvg;
import com.aspose.words.zzWwH;
import com.aspose.words.zzWwZ;
import com.aspose.words.zzX3y;
import com.aspose.words.zzXCr;
import com.aspose.words.zzXNd;
import com.aspose.words.zzXam;
import com.aspose.words.zzXow;
import com.aspose.words.zzXw5;
import com.aspose.words.zzY7w;
import com.aspose.words.zzY8m;
import com.aspose.words.zzY9g;
import com.aspose.words.zzYLl;
import com.aspose.words.zzYNA;
import com.aspose.words.zzYen;
import com.aspose.words.zzYlq;
import com.aspose.words.zzYnK;
import com.aspose.words.zzYoZ;
import com.aspose.words.zzYpq;
import com.aspose.words.zzYqK;
import com.aspose.words.zzZOp;
import com.aspose.words.zzZSk;
import com.aspose.words.zzZr6;
import com.aspose.words.zzbQ;
import com.aspose.words.zze;
import com.aspose.words.zzeD;
import com.aspose.words.zzjD;
import com.aspose.words.zzjN;
import com.aspose.words.zzob;
import com.aspose.words.zzuY;
import com.aspose.words.zzyN;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzW3B,
zzWWD,
zze,
zzjN {
    private Document zzWTk;
    private Node zzZ6h;
    private Node zzZJK;
    private zzXCr zzZ2x;
    private Font zzXQo;
    private zzZY2<zzXCr> zz9Q;
    private zzZY2<zzWeP> zzYPG;
    private zzZY2<zzYON> zzMh;
    private zzVRz zzY24 = zzVRz.zzZxK();
    private zzXNd zzXYX = new zzXNd();
    private zzWeP zzWJZ;
    private RowFormat zzhw;
    private CellFormat zzZEo;
    private ParagraphFormat zzX9k;
    private zzZY2<zzyN> zz8F;
    private int zzkS = 0;
    private int zzkc = -1;
    private int zzWaF;
    private boolean zzXW8;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzXAw(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzXAw(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzXAw(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYON(documentBuilder.getCurrentSection(), zzXw5.zzY8A(headerFooterType), 0, 0);
    }

    private void zzXAw(int n, int n2, int n3, int n4) {
        this.zzWTk.ensureMinimum();
        Section section = (Section)this.zzWTk.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzYON(section, 1, n3, n4);
    }

    private void zzYON(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzXw5.zzZjO(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = section.appendChild(new HeaderFooter(this.zzWTk, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzWTk));
            }
        }
        this.zzYON(story, n2, n3);
    }

    private void zzYON(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYON((CompositeNode)paragraph2, n3);
    }

    final void zzYON(Paragraph paragraph, int n) {
        this.zzYON((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzZLv().zzYgE() ? zzYNA.zzXgg(this.zzWTk, fieldName) : zzYNA.zzXUT(this.zzZLv(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzYON(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzYON(field, isAfter, false);
    }

    private boolean zzYON(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzeD zzeD2 = field.getFormat().zzZ5B();
        Inline inline = zzeD2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzYON(inline.zzAp(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzY7w.zzYON(this.zzWTk, bookmarkName) : zzY7w.zzVVX(this.zzWTk, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzNc() == 6) {
            this.zzYON(node.zzWQP(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzuY.zzX2E(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzYON((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYON(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzVVX(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzYON(structuredDocumentTag);
            return;
        }
        this.zzYhC(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzXiq(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzYON((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzNc() == 6) {
            this.zzVVN(node);
        } else {
            Node node2 = node;
            if (zzuY.zzYq2(node2.getNodeType())) {
                Paragraph paragraph = zzuY.zzX2E(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzVVN(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzNc() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzVVN(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzWaF = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzXtH();
            return;
        }
        if (!this.zzYhQ()) {
            this.zzXtH();
        }
    }

    private void zzYON(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzYhQ() {
        Node node = this.zzZLv();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzZLv().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzYON(((StructuredDocumentTag)documentBuilder.zzZLv().getParentNode()).zzXCx(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzZLv(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzYON(inline.zzAp(), true);
            return true;
        }
        return false;
    }

    private void zzXtH() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYON(documentBuilder.getCurrentParagraph().zzZKd(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzXiq(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZaR() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzZLv().zzYmY(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZ6m();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzYON((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzWas(text, false);
    }

    public void writeln(String text) {
        this.zzWas(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzZLv() != null && this.zzZLv().zzNc() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzZLv().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzIv();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzbQ zzbQ2 = new zzbQ(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzWTk, this.zzZhv(), this.zzYrm());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().zzXRl(paragraph);
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzVVX(this.zzZLv(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzbQ2.dispose();
        }
        if (this.getDocument().zzZcy()) {
            zzuY.zzYhC((zzWwH)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzWMu());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzP9() {
        zzXCr zzXCr2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzIv();
        Node node = this.zzZLv();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzWAw(false);
        } else {
            run2 = run = (Run)node.zzZlV(21);
        }
        if (run2 == null && zzYWV.zzXN3(node, paragraph.zzOM())) {
            run = paragraph.zzOM();
        }
        if (run != null) {
            cloneable = run.zzAp();
            zzXCr2 = (zzXCr)((zzIp)cloneable).zzXC3();
        } else {
            cloneable = paragraph.zzZKd();
            zzXCr2 = (zzXCr)((zzIp)cloneable).zzXC3();
        }
        zzXCr zzXCr3 = zzXCr2;
        Paragraph paragraph2 = new Paragraph(this.zzWTk, this.zzZhv(), zzXCr3);
        paragraph.zzSX(paragraph2);
        zzbQ zzbQ2 = new zzbQ(this.zzWTk);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzVVX(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzbQ2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzYLl.zzXgg(this);
    }

    public void insertBreak(int breakType) {
        this.zzXPb(breakType, true);
    }

    final void zzXPb(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzso(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzWXL(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzWVf())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzso(bl)) {
                        this.zzWXL(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzso(bl)) {
                        this.zzZAw(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzso(bl)) {
                        this.zzZAw(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzso(bl)) {
                        this.zzZAw(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzso(bl)) {
                        this.zzZAw(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzso(bl)) {
                        this.zzZAw(4);
                    }
                    return;
                }
                case 8: {
                    this.zzWXL(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzYCe.zzW4Z(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzYO7.zzVVX("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzIv();
        return zzuY.zzYON(fieldType, updateField, this.zzYrm(), this.zzXNt(), this.zzj6(), this.zzj6() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzIv();
        return zzuY.zzYON(fieldCode, this.zzYrm(), this.zzXNt(), this.zzj6(), this.zzj6() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzIv();
        return zzuY.zzYON(fieldCode, fieldValue, this.zzYrm(), this.zzXNt(), this.zzj6(), this.zzj6() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzYWV.zzVVX((Object)displayText, "displayText");
        zzYWV.zzVVX((Object)urlOrBookmark, "hrefOrBookmark");
        zzYen zzYen2 = this.zzVVX(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzYen2.zzYhC(documentBuilder.zzXNv(88, true));
        return zzuY.zzYON(zzYen2.getStart(), zzYen2.getSeparator(), zzYen2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzZsa(70);
        if (zzYCe.zzW4Z(name)) {
            this.startBookmark(name);
        }
        this.zzYAH(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zz3y(70);
        String string = zzYCe.zzW4Z(fieldValue) ? fieldValue : FormField.zzZ0v;
        Run run = new Run(this.zzWTk, string, this.zzYrm());
        this.insertNode(run);
        Node node = this.zzXNv(70, true);
        if (zzYCe.zzW4Z(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzW9N(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzYON((CompositeNode)((Paragraph)node.zzWQP()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzZsa(71);
        if (zzYCe.zzW4Z(name)) {
            this.startBookmark(name);
        }
        this.zzYAH(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzXNv(71, false);
        if (zzYCe.zzW4Z(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzW9N(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzZsa(83);
        if (zzYCe.zzW4Z(name)) {
            this.startBookmark(name);
        }
        this.zzYAH(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzXNv(83, false);
        if (zzYCe.zzW4Z(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzW9N(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzWTk, footnoteType, !zzYCe.zzW4Z(referenceMark), referenceMark, this.zzYrm());
        Style style = this.getDocument().getStyles().zzWmU(zzuY.zzUp(footnoteType));
        footnote.zzAp().set(50, style.zzY8Y());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzWTk);
        Style style2 = this.getDocument().getStyles().zzWmU(zzuY.zzYh8(footnoteType));
        paragraph.zzXJs().set(1000, style2.zzY8Y());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzWTk, '\u0002', new zzXCr()) : new Run(this.zzWTk, footnote.getReferenceMark(), new zzXCr());
        inline.zzAp().set(50, style.zzY8Y());
        paragraph.appendChild(inline);
        if (zzYCe.zzW4Z(footnoteText)) {
            Node node = this.zzZLv();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzVVN(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZgh(zzav zzav2) throws Exception {
        return this.zzYON(zzav2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZgh(zzav.zzVVX(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzYON(zzav zzav2, double d, double d2) throws Exception {
        return this.zzYON(zzav2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzYON(zzav.zzVVX(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        try (zzLF zzLF2 = new zzLF();){
            zzXo3.zzYON(image, zzLF2);
            Shape shape = this.zzYON(zzLF2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzYWV.zzYhC(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzYRr.zzoo(fileName);
        try {
            Shape shape = this.zzYON((zzav)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzav)object).close();
            }
        }
    }

    private Shape zzYON(zzav zzav2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzav2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzYWV.zzXgg(zzav2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYON(zzav.zzVVX(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYON(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzYON(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzWOS.zzla(object)) {
            object4 = new zzXo3((byte[])object);
            bl2 = true;
            ((zzZTw)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzWTk.getCompatibilityOptions().getMswVersion() > 12 || this.zzWTk.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzWTk, 0);
            object3 = new zzXow();
            ((zzW2J)object3).zzYON(zzZr6.zzXm5("rect"));
            ((zzXow)object3).zzYON(new zzWEY());
            ((zzXow)object3).zzjQ().zzWZI().zzYhC(this.zzWTk);
            object2 = new zzYqK();
            ((zzWif)object2).zzVVX(new zzWwZ(this.zzWTk.zzu(), ""));
            ((zzWif)object2).zzYON(new zzWJ3());
            ((zzjD)object3).zzYON((zzWif)object2);
            shape.setShapeType(75);
            shape.zzWqY((zzjD)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzWTk, 75);
        }
        if (zzWOS.zzLU(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzYON((byte[])object, new zzYnK(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzYnK(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzWOS.zzWYR((byte[])object2));
                this.zzYON((zzXow)shape.zzbj(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXow)shape.zzbj()).zzjQ().zzWZI().zz15((byte[])object);
            object3 = zzWOS.zzVVz(object);
            object4 = new zzYnK(((zzPm)object3).getWidthPoints(), ((zzPm)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzVVX(this.zzYrm());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzWOS.zzYBK(object)) {
            d5 = DocumentBuilder.zzYON(shape, object);
        }
        shape.zzYON(d3, d4, (zzYnK)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzYON(Shape shape, byte[] byArray) throws Exception {
        int n = zzWOS.zzWnD(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzuY.zzX2H(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzuY.zzxR(n);
        return d;
    }

    private void zzYON(zzXow zzXow2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXow2.zzjQ().zzWZI().getExtensions();
        try (zzLF zzLF2 = new zzLF(byArray);){
            object = zzuY.zzYON(zzLF2, this.zzWTk);
            ((zzWBL)object).zzd2(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzWBL)object).zzWAU();
            byArray2 = ((zzWBL)object).zzZoy(true);
        }
        zzXow2.zzjQ().zzWZI().setExtensions(new zzow<zzob>());
        object = zzob.zzYON(byArray2, this.zzWTk);
        zzXow2.zzjQ().zzWZI().getExtensions().zzXMu(((zzob)object).getUri(), (zzob)object);
    }

    private Shape zzYON(zzav zzav2, String string, boolean bl, zzav zzav3) throws Exception {
        zzYlq zzYlq2 = zzYlq.zzYh8(string);
        Shape shape = this.zzYON(zzav3, bl, zzYlq2, null);
        zzWv4 zzWv42 = zzX3y.zzYON(zzav2, string, bl);
        return DocumentBuilder.zzYON(null, false, shape, zzYlq2.zzX4S, zzWv42);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYON(zzav.zzVVX(stream), progId, asIcon, zzav.zzVVX(presentation));
    }

    private Shape zzYON(String string, boolean bl, boolean bl2, zzav zzav2) throws Exception {
        zzYlq zzYlq2 = zzYlq.zzWuh(zzX10.zzZGx(string));
        return this.zzYON(string, bl, bl2, zzav2, zzYlq2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYON(fileName, isLinked, asIcon, zzav.zzVVX(presentation));
    }

    private Shape zzYON(String string, String string2, boolean bl, boolean bl2, zzav zzav2) throws Exception {
        zzYlq zzYlq2 = zzYlq.zzYh8(string2);
        return this.zzYON(string, bl, bl2, zzav2, zzYlq2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYON(fileName, progId, isLinked, asIcon, zzav.zzVVX(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYlq zzYlq2 = zzYlq.zzWuh(zzX10.zzZGx(fileName));
        return this.zzYON(fileName, isLinked, iconFile, iconCaption, zzYlq2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYlq zzYlq2 = zzYlq.zzYh8(progId);
        return this.zzYON(fileName, isLinked, iconFile, iconCaption, zzYlq2);
    }

    private Shape zzVVX(zzav zzav2, String string, String string2, String string3) throws Exception {
        zzYlq zzYlq2 = zzYlq.zzYh8(string);
        Shape shape = this.zzYON(string2, string3, zzYlq2);
        zzWv4 zzWv42 = zzX3y.zzYON(zzav2, string, true);
        return DocumentBuilder.zzYON(null, false, shape, zzYlq2.zzX4S, zzWv42);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzVVX(zzav.zzVVX(stream), progId, iconFile, iconCaption);
    }

    final Shape zzYON(zzY8m zzY8m2, zzav zzav2) throws Exception {
        Shape shape = this.zzVUX(zzav2);
        shape.setShapeType(201);
        shape.setShapeAttr(4112, zzY8m2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzIv();
        if (this.zzoh()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzZhb(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzYpq zzYpq2 = zzuY.zzYON(html, options, this);
        zzYpq2.zzZAT();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzIv();
        return zzuY.zzYON(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzIv();
        return zzuY.zzYON(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzXam zzXam2 = new zzXam();
        return zzXam2.zzYON(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzVXP(this).zzYON(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzVXP(this).zzYON(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzWTk, 75);
        shape.zzVVX(this.zzYrm());
        shape.zzZkK(true);
        shape.getSignatureLine().zzYON(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXDm(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzXcE(this.zzWTk);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzoh() {
        boolean bl = false;
        if (this.zzZLv().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzZLv().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzZhb(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzIv();
        if (this.zzZaR() == null) {
            this.startTable();
        }
        if (this.zzZaR().zzZQm() == 1) {
            this.zzZaR().zzZIu();
        }
        if (this.zzZaR().zzZQm() == 3) {
            this.zzZaR().zzXM7();
        }
        return this.zzZaR().zzus();
    }

    public Table startTable() {
        this.zz8F.push(new zzyN(this));
        return this.zzZaR().startTable();
    }

    public Table endTable() {
        if (this.zzZaR() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZaR().endTable();
        this.zz8F.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzZaR() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzZaR().endRow();
        if (this.zzXQo != null && this.zzXQo.getHidden()) {
            row.zzYLT().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWTk, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWTk, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYdN();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWTk, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzZM9();
        bookmarkStart.zziX(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYdN();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzZM9();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWTk, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzXm5(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzWTk);
        this.zzkc = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzkc == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWTk, this.zzkc);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWTk, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzYWV.zzVVX((Object)importFormatOptions, "ImportFormatOptions");
        this.zzIv();
        return zzZOp.zzYON(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Node insertDocumentInline(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzYWV.zzVVX((Object)importFormatOptions, "ImportFormatOptions");
        this.zzIv();
        importFormatOptions.zzYjc(true);
        Node node = zzZOp.zzYON(this, srcDoc, importFormatMode, importFormatOptions);
        importFormatOptions.zzYjc(false);
        return node;
    }

    public Document getDocument() {
        return this.zzWTk;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzWTk) {
            return;
        }
        this.zzWTk = value;
        this.zzVVN(null);
        this.zzZ2x = new zzXCr();
        this.zz9Q = null;
        this.zzYPG = null;
        this.zzXQo = null;
        this.zz8F = new zzZY2();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzXQo == null) {
            DocumentBuilder documentBuilder = this;
            this.zzXQo = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzXQo;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzX9k == null) {
            DocumentBuilder documentBuilder = this;
            this.zzX9k = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzX9k;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzhw == null) {
            this.zzhw = new RowFormat(this);
        }
        return this.zzhw;
    }

    public CellFormat getCellFormat() {
        if (this.zzZEo == null) {
            this.zzZEo = new CellFormat(this);
        }
        return this.zzZEo;
    }

    final void zzAH(Node node) {
        this.getCurrentParagraph().zzSX(node);
    }

    public void pushFont() {
        zzXCr zzXCr2;
        if (this.getCurrentParagraph() != null) {
            zzXCr zzXCr3 = this.getCurrentParagraph().zzZKd();
            zzXCr2 = (zzXCr)zzXCr3.zzXC3();
        } else {
            zzXCr2 = this.zzYrm();
        }
        zzXCr zzXCr4 = zzXCr2;
        this.zzYs2().push(new zzYON(this.zzYrm(), zzXCr4));
    }

    public void popFont() {
        zzZY2<zzYON> zzZY22 = this.zzYs2();
        if (zzZY22.size() > 0) {
            zzYON zzYON2 = (zzYON)this.zzYs2().pop();
            this.zzYON(zzYON2.zzAp(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzAH(zzYON2.zzW5f());
            }
        }
    }

    final void zzX4I() {
        this.zzZ6A().push(this.zzYrm());
    }

    final void zzXOK() {
        zzZY2<zzXCr> zzZY22 = this.zzZ6A();
        if (zzZY22.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzYON((zzXCr)documentBuilder.zzZ6A().pop(), false);
        }
    }

    final void zzWZK() {
        this.zzZ3P().push(this.zzZhv());
    }

    final void zzYgG() {
        zzZY2<zzWeP> zzZY22 = this.zzZ3P();
        if (zzZY22.size() > 0) {
            zzWeP zzWeP2 = (zzWeP)this.zzZ3P().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzYON(zzWeP2);
            }
        }
    }

    private zzYen zzVVX(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzZsa(88);
        zzY9g zzY9g2 = new zzY9g();
        zzY9g2.setTarget(string2);
        zzY9g2.setScreenTip(string3);
        if (bl) {
            zzY9g2.setSubAddress(string);
        } else {
            zzY9g2.setAddress(zzXNZ.zzXQI(string));
            zzY9g2.setSubAddress(zzXNZ.zzXXS(string));
        }
        this.zzYAH(zzY9g2.zzZpI());
        FieldSeparator fieldSeparator = this.zz3y(88);
        return new zzYen(fieldStart, fieldSeparator, null);
    }

    final zzYen zzXAw(String string, String string2, String string3) {
        boolean bl = zzXNZ.zzZy7(string);
        String string4 = bl ? zzXNZ.zzXXS(string) : string;
        return this.zzVVX(string4, bl, string2, string3);
    }

    final zzYen zzYON(zzY9g zzY9g2) {
        FieldStart fieldStart = this.zzZsa(88);
        this.zzYAH(zzY9g2.zzZpI());
        FieldSeparator fieldSeparator = this.zz3y(88);
        return new zzYen(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzWBd() {
        return this.zzXNv(88, true);
    }

    final zzXCr zzYrm() {
        zzXCr zzXCr2 = this.zzZ2x;
        return (zzXCr)zzXCr2.zzXC3();
    }

    final zzWeP zzZhv() {
        zzWeP zzWeP2 = this.zzXJs();
        return (zzWeP)zzWeP2.zzXC3();
    }

    final zzVRz zzXHD() {
        zzVRz zzVRz2 = this.zzYLT();
        return (zzVRz)zzVRz2.zzXC3();
    }

    final zzXNd zz4e() {
        zzXNd zzXNd2 = this.zzTQ();
        return (zzXNd)zzXNd2.zzXC3();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzZLv(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzZLv().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzXW8 && this.zzZLv().getNodeType() == 28;
    }

    private void zzWas(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzZLv()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzXw5.zzYPb(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzYjB(string2.substring(n4, n4 + n2));
                }
                switch (this.zzkS) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzWXL(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzYjB(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzIv();
        if (this.zzZaR() != null && this.zzZaR().zzZQm() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzZLv().zzSX(node);
    }

    final void zzXKx(int n) {
        this.zzso(true);
        this.zzZAw(n);
    }

    private void zzZAw(int n) {
        this.insertParagraph();
        zzbQ zzbQ2 = new zzbQ(this.getDocument());
        try {
            zzZSk zzZSk2 = this.getCurrentSection().zzVUH();
            zzZSk zzZSk3 = (zzZSk)zzZSk2.zzXC3();
            Section section = new Section(this.zzWTk, zzZSk3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzWTk));
            this.zzWTk.insertAfter(section, this.getCurrentSection());
            section.getBody().zzVVX(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzbQ2.dispose();
        }
    }

    final FieldStart zzZsa(int n) {
        this.zzIv();
        return zzuY.zzYON(n, this.zzYrm(), this.zzXNt(), this.zzj6(), this.zzj6() == null);
    }

    final Run zzYAH(String string) {
        return zzuY.zzVVX(string, this.zzYrm(), this.zzXNt(), this.zzj6(), this.zzj6() == null);
    }

    final FieldEnd zzXNv(int n, boolean bl) {
        return zzuY.zzVVX(n, bl, this.zzYrm(), this.zzXNt(), this.zzj6(), this.zzj6() == null);
    }

    final FieldSeparator zz3y(int n) {
        return zzuY.zzVVX(n, this.zzYrm(), this.zzXNt(), this.zzj6(), this.zzj6() == null);
    }

    private FormField zzW9N(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzWTk, new zzWvg(), this.zzYrm());
        CompositeNode compositeNode = node == null ? this.zzXNt() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzso(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZaR() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzXiq(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzYjB(String string) {
        if (this.zzYjA(string)) {
            zzWc1 zzWc12 = new zzWc1(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzZWA zzZWA2 : zzWc12.zzXbm(this.getParagraphFormat().getBidi())) {
                zzWas zzWas2 = zzWas.zzZlm(zzZWA2.zzZm());
                zzXCr zzXCr2 = this.zzYrm();
                zzXCr2.zzkw(265, zzWas2);
                if (zzZWA2.zzXTK()) {
                    zzXCr2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzWTk, zzZWA2.getText(), zzXCr2);
                this.insertNode(run);
            }
            return;
        }
        this.zzWXL(string);
    }

    private boolean zzYjA(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzY0N.zzXKM(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzYON(zzXCr zzXCr2, boolean bl) {
        zzXCr zzXCr3;
        if (bl) {
            zzXCr zzXCr4 = zzXCr2;
            zzXCr3 = (zzXCr)zzXCr4.zzXC3();
        } else {
            zzXCr3 = zzXCr2;
        }
        this.zzZ2x = zzXCr3;
    }

    final void zzTF() {
        this.zzZ2x.clear();
    }

    final void zzZBo() {
        if (this.zzYdN() != null) {
            zzXNd zzXNd2;
            zzXNd zzXNd3 = zzXNd2 = this.zzYdN().zzTQ();
            this.zzXYX = (zzXNd)zzXNd3.zzXC3();
            zzXNd2.zzVVX(this.zzXYX);
        }
    }

    private Shape zzYON(String string, boolean bl, boolean bl2, zzav zzav2, zzYlq zzYlq2) throws Exception {
        if (zzYlq2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzYON(zzav2, bl2, zzYlq2, string);
        zzWv4 zzWv42 = zzX3y.zzYON(string, bl, bl2, zzYlq2);
        return DocumentBuilder.zzYON(string, bl, shape, zzYlq2.zzX4S, zzWv42);
    }

    private Shape zzYON(String string, boolean bl, String string2, String string3, zzYlq zzYlq2) throws Exception {
        if (zzYlq2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzX10.zzWxS(string);
        }
        Shape shape = string2 != null ? this.zzXAD(string2, string3) : this.zzYON(null, string3, zzYlq2);
        zzWv4 zzWv42 = zzX3y.zzYON(string, bl, true, zzYlq2);
        return DocumentBuilder.zzYON(string, bl, shape, zzYlq2.zzX4S, zzWv42);
    }

    private static Shape zzYON(String string, boolean bl, Shape shape, String string2, zzWv4 zzWv42) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzVVX(zzWv42);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzYON(zzav zzav2, boolean bl, zzYlq zzYlq2, String string) throws Exception {
        if (zzYlq2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzav2 != null) {
            return this.zzVUX(zzav2);
        }
        if (!bl) {
            return this.zzZlm(zzX3y.zzZbb().get("normal"));
        }
        String string2 = string != null ? zzX10.zzWxS(string) : zzX3y.zzqJ(zzYlq2.zzWEZ);
        return this.zzYON(zzYlq2, string2);
    }

    private Shape zzYON(String string, String string2, zzYlq zzYlq2) throws Exception {
        if (zzYlq2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzX3y.zzqJ(zzYlq2.zzWEZ);
        }
        if (string != null) {
            return this.zzXAD(string, string2);
        }
        return this.zzYON(zzYlq2, string2);
    }

    private Shape zzYON(zzYlq zzYlq2, String string) throws Exception {
        if (zzYlq2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzX3y.zzYOw(zzYlq2.zzWEZ);
        zzX04 zzX042 = new zzX04(byArray, null, string, this.getDocument().zzZeh());
        return this.zzZlm(zzX042.zzZHh());
    }

    private Shape zzXAD(String string, String string2) throws Exception {
        zzX04 zzX042 = new zzX04(string, string2, this.getDocument().zzZeh());
        return this.zzZlm(zzX042.zzZHh());
    }

    private Shape zzVUX(zzav zzav2) throws Exception {
        byte[] byArray = zzYWV.zzXgg(zzav2);
        return this.zzZlm(byArray);
    }

    private Shape zzZlm(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzWTk, 1);
        shape.setShapeType(75);
        shape.zzVVX(this.zzYrm());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXDm(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzYON(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzVVX(compositeNode, n);
            return;
        }
        this.zzYhC(compositeNode, n);
    }

    private void zzVVX(CompositeNode compositeNode, int n) {
        zzYoZ zzYoZ2 = zzYoZ.zzWas(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzYoZ2.zzYON(null, true, true, true, false, true);
            node = zzYoZ2.getNode();
            if (zzYoZ2.zzY1G() && (!node.isComposite() || node.zzNc() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzXQJ().length() : node.getTextLength();
            if (!zzYoZ2.zzY1G() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzYoZ2.zzY1G() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzYON((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzYON(null, node);
            this.zzWaF = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzYON(StructuredDocumentTag structuredDocumentTag) {
        this.zzVVN(structuredDocumentTag);
        this.zzXW8 = true;
        this.zzWaF = 0;
        zzXCr zzXCr2 = structuredDocumentTag.zzXCx();
        switch (structuredDocumentTag.zzNc()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzVSE(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzXCr2 = ((Inline)node).zzAp();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzXCr2 = paragraph.zzZKd();
                break;
            }
            default: {
                return;
            }
        }
        this.zzYON(zzXCr2, true);
    }

    private void zzYhC(CompositeNode compositeNode, int n) {
        zzYoZ zzYoZ2 = zzYoZ.zzWOg(compositeNode);
        while (zzYoZ2.getNode() != compositeNode || !zzYoZ2.zzY1G()) {
            int n2;
            Node node = zzYoZ2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzXQJ().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzYON(null, node);
                this.zzWaF = n;
                return;
            }
            while (zzYoZ2.zzYON(null, false, true, true, false, true) && zzYoZ2.zzY1G() && zzYoZ2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzIv() {
        int n = this.zzWaF;
        if (n == 0) {
            return;
        }
        this.zzWaF = 0;
        Run run = zzYWV.zzYON((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zz1X(n);
        }
    }

    private Run zzWXL(String string) {
        Run run = new Run(this.zzWTk, string, this.zzYrm());
        this.insertNode(run);
        return run;
    }

    final boolean zzW5W() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZbF() {
        return this.zzkS;
    }

    final void zzXP5(int n) {
        this.zzkS = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzZLv();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzZLv();
        }
        return (Paragraph)this.zzZLv().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzZLv();
        }
        return (StructuredDocumentTag)this.zzZLv().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzZLv().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzyN zzZaR() {
        zzZY2<zzyN> zzZY22 = this.zz8F;
        if (zzZY22.size() > 0) {
            return (zzyN)this.zz8F.peek();
        }
        return null;
    }

    private Cell zzYdN() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzET();
    }

    private CompositeNode zzXNt() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzZLv();
        }
        return this.zzZLv().getParentNode();
    }

    private Node zzj6() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzZLv();
    }

    private zzZY2<zzXCr> zzZ6A() {
        if (this.zz9Q == null) {
            this.zz9Q = new zzZY2();
        }
        return this.zz9Q;
    }

    private zzZY2<zzWeP> zzZ3P() {
        if (this.zzYPG == null) {
            this.zzYPG = new zzZY2();
        }
        return this.zzYPG;
    }

    private zzZY2<zzYON> zzYs2() {
        if (this.zzMh == null) {
            this.zzMh = new zzZY2();
        }
        return this.zzMh;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZ2x.zzXCF(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzZ2x.zzWsU(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzVA(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzVA(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZ2x.zzkw(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzXqQ()) {
            this.getCurrentParagraph().zzZKd().zzkw(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZ2x.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZ2x.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzXqQ()) {
            this.getCurrentParagraph().zzZKd().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzXJs().zzXCF(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzXJs().zzWsU(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zz72(key, 0);
        }
        return this.getDocument().getStyles().zzZZb().zzWhQ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzXJs().zzkw(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzXJs().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzXJs().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzYLT().zzXCF(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzYLT().zzWhQ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzYLT().zzZwP(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzYLT().zzkw(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzYLT().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzYLT().clear();
        zzVRz.zzZxK().zzVVX(this.zzYLT());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzTQ().zzXCF(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzTQ().zzWhQ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzTQ().zzZwP(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzYWV.zzYON(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzYdN() != null ? this.zzYdN().getCellFormat() : this.getCellFormat();
            border.zzYON(cellFormat);
        }
        this.zzTQ().zzkw(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzTQ().clear();
    }

    private Node zzZLv() {
        Node node = this.zzZ6h != null && this.zzZ6h.getParentNode() == null ? this.zzZJK : this.zzZ6h;
        if (node != null && node.zzNc() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzXW8 = this.zzXW8 && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzVVN(Node node) {
        this.zzZ6h = node;
        if (this.zzZ6h != null) {
            this.zzZJK = this.zzZ6h.getParentNode();
        }
        this.zzXW8 = false;
    }

    private zzWeP zzXJs() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzXJs();
        }
        if (this.zzWJZ == null) {
            this.zzWJZ = new zzWeP();
        }
        return this.zzWJZ;
    }

    private zzVRz zzYLT() {
        if (this.zzZaR() != null && this.zzZaR().zzZQm() == 1) {
            return this.zzY24;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzYLT();
        }
        return this.zzY24;
    }

    private zzXNd zzTQ() {
        if (this.zzZaR() != null && this.zzZaR().zzZQm() != 3) {
            return this.zzXYX;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzET().zzTQ();
        }
        return this.zzXYX;
    }

    static final class zzYON {
        private zzXCr zzZ2x;
        private zzXCr zzbN;

        public zzYON(zzXCr zzXCr2, zzXCr zzXCr3) {
            this.zzZ2x = zzXCr2;
            this.zzbN = zzXCr3;
        }

        public final zzXCr zzAp() {
            return this.zzZ2x;
        }

        public final zzXCr zzW5f() {
            return this.zzbN;
        }
    }
}

