/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzXG8;
import com.aspose.words.internal.zzYCe;
import com.aspose.words.internal.zzYWV;
import com.aspose.words.internal.zzZAs;
import com.aspose.words.internal.zzZk6;
import com.aspose.words.internal.zzav;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzkp;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzQs = new HashMap();
    private static HashMap<Integer, Integer> zzYzc = new HashMap();
    private static HashMap<Integer, Integer> zzYFr = new HashMap();
    private static HashMap<Integer, Integer> zzZgb = new HashMap();
    private static HashMap<Integer, Integer> zzW3L = new HashMap();
    private static HashMap<Integer, Integer> zzWlw = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzYWV.zzYhC(fileName, "fileName");
        try (zzZk6 zzZk62 = zzYWV.zzd2(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZfr(zzZk62);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZfr(zzZAs.zzYON(stream));
    }

    static FileFormatInfo zzZfr(zzav zzav2) throws Exception {
        if (zzav2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzkp zzkp2 = new zzkp();
            zzav zzav3 = zzav2;
            zzkp zzkp3 = zzkp2;
            return zzkp2.zzVVX(zzav3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzYhC(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZSh(zzXG8.zzXrI(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzWJO(zzXG8.zzXrI(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzYCe.zzW4Z(string = zzXG8.zzW5V(FileFormatUtil.zzZsV(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZSh(FileFormatUtil.zzZdC(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzWJO(FileFormatUtil.zzZsV(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXG8.zzW5V(FileFormatUtil.zzZdC(saveFormat));
        if (zzYCe.zzW4Z(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzWJO(zzXG8.zzW6H(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXG8.zzW5V(FileFormatUtil.zzYzI(imageType));
    }

    static Exception zzYhC(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzXrl(int n) {
        return zzXG8.toString(FileFormatUtil.zzZdC(n));
    }

    static int zzWJO(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYWV.zzYON(zzW3L, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzXtO(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYWV.zzYON(zzWlw, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzZde(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzZsV(int n) {
        return zzYWV.zzYON(zzQs, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzZdC(int n) {
        return zzYWV.zzYON(zzYzc, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYzI(int n) {
        return zzYWV.zzYON(zzYFr, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZSh(int n) {
        return zzYWV.zzYON(zzZgb, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzW28(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzYWV.zzVVX(zzW3L, Integer.valueOf(n), Integer.valueOf(n2));
            zzYWV.zzVVX(zzYzc, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZgb.containsKey(n)) {
                zzYWV.zzVVX(zzZgb, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzYWV.zzVVX(zzQs, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzYWV.zzVVX(zzWlw, Integer.valueOf(n), Integer.valueOf(n4));
            zzYWV.zzVVX(zzYFr, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzW28(13, 10, 10, 1);
        FileFormatUtil.zzW28(13, 0, 0, 1);
        FileFormatUtil.zzW28(14, 11, 11, 1);
        FileFormatUtil.zzW28(15, 20, 20, 1);
        FileFormatUtil.zzW28(15, 0, 254, 1);
        FileFormatUtil.zzW28(16, 21, 21, 1);
        FileFormatUtil.zzW28(17, 22, 22, 1);
        FileFormatUtil.zzW28(18, 23, 23, 1);
        FileFormatUtil.zzW28(20, 24, 24, 1);
        FileFormatUtil.zzW28(21, 25, 25, 1);
        FileFormatUtil.zzW28(22, 26, 26, 1);
        FileFormatUtil.zzW28(23, 27, 27, 1);
        FileFormatUtil.zzW28(26, 30, 30, 1);
        FileFormatUtil.zzW28(19, 31, 31, 1);
        FileFormatUtil.zzW28(27, 50, 50, 1);
        FileFormatUtil.zzW28(28, 45, 255, 1);
        FileFormatUtil.zzW28(29, 51, 51, 1);
        FileFormatUtil.zzW28(30, 54, 52, 1);
        FileFormatUtil.zzW28(31, 0, 53, 1);
        FileFormatUtil.zzW28(33, 53, 54, 1);
        FileFormatUtil.zzW28(24, 60, 60, 1);
        FileFormatUtil.zzW28(25, 61, 61, 1);
        FileFormatUtil.zzW28(36, 40, 64, 1);
        FileFormatUtil.zzW28(43, 47, 255, 1);
        FileFormatUtil.zzW28(44, 48, 255, 1);
        FileFormatUtil.zzW28(37, 41, 255, 1);
        FileFormatUtil.zzW28(38, 46, 255, 1);
        FileFormatUtil.zzW28(40, 42, 255, 1);
        FileFormatUtil.zzW28(39, 44, 255, 1);
        FileFormatUtil.zzW28(32, 52, 55, 1);
        FileFormatUtil.zzW28(34, 70, 62, 1);
        FileFormatUtil.zzW28(35, 73, 63, 1);
        FileFormatUtil.zzW28(41, 71, 255, 1);
        FileFormatUtil.zzW28(8, 100, 255, 1);
        FileFormatUtil.zzW28(9, 105, 255, 1);
        FileFormatUtil.zzW28(6, 101, 255, 6);
        FileFormatUtil.zzW28(7, 102, 255, 7);
        FileFormatUtil.zzW28(5, 104, 255, 5);
        FileFormatUtil.zzW28(4, 0, 255, 4);
        FileFormatUtil.zzW28(3, 0, 255, 3);
        FileFormatUtil.zzW28(42, 72, 255, 1);
        FileFormatUtil.zzW28(2, 103, 255, 2);
        FileFormatUtil.zzW28(10, 106, 255, 8);
        FileFormatUtil.zzW28(48, 80, 255, 1);
        FileFormatUtil.zzW28(11, 0, 255, 9);
    }
}

