/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.internal.zzX10;
import com.aspose.words.internal.zzYO7;

public final class NativeLibSettings {
    private NativeLibSettings() {
    }

    public static void setTmpDirectoryPath(String path) throws IllegalArgumentException {
        if (zzYO7.zzZZ6(path) || !zzX10.zzZj0(path)) {
            throw new IllegalArgumentException("Custom path " + path + " is invalid");
        }
        System.setProperty("com.aspose.tmpdir", path);
    }

    public static String getTmpDirectoryPath() {
        if (zzYO7.zzZZ6(System.getProperty("com.aspose.tmpdir"))) {
            return System.getProperty("java.io.tmpdir");
        }
        return System.getProperty("com.aspose.tmpdir");
    }

    public static void loadWinNativeLib() {
        System.clearProperty("com.aspose.skip_win_native_lib");
    }

    public static void loadHarfBuzzNativeLib() {
        System.clearProperty("com.aspose.skip_hb_native_lib");
    }

    public static void skipWinNativeLib() {
        System.setProperty("com.aspose.skip_win_native_lib", "true");
    }

    public static void skipHarfBuzzNativeLib() {
        System.setProperty("com.aspose.skip_hb_native_lib", "true");
    }

    public static boolean isWinNativeLibLoaded() {
        return System.getProperty("com.aspose.skip_win_native_lib") == null;
    }

    public static boolean isHarfBuzzNativeLibLoaded() {
        return System.getProperty("com.aspose.skip_hb_native_lib") == null;
    }
}

