/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzYO7;
import com.aspose.words.internal.zzYWV;
import com.aspose.words.internal.zzZY2;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zz7w;
import com.aspose.words.zzVY4;
import com.aspose.words.zzYoZ;
import com.aspose.words.zzc5;
import com.aspose.words.zzuY;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzYc1;
    private Node zzW94;
    private Node zzVZy;
    private int zzWQO;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzYhC(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYc1 == null) {
            return null;
        }
        if (this.zzYc1.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzYc1;
    }

    final CompositeNode zzWQP() {
        if (zzuY.zzCw(this.getParentNode())) {
            return this.getParentNode().zzWQP();
        }
        return this.getParentNode();
    }

    final CompositeNode zzlg() {
        if (zzuY.zzCw(this.getParentNode()) || zzuY.zzX4k(this.getParentNode())) {
            return this.getParentNode().zzlg();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzYc1 != null) {
            return this.zzYc1.getDocument();
        }
        return null;
    }

    final Document zzWl7() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZWi() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zz1y();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzVZy;
    }

    final Node zzZtV() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzuY.zzYq2((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzZJD() {
        Node node = zzuY.zzXAw(this.getPreviousSibling(), false);
        if (node == null && zzuY.zzCw(this.getParentNode())) {
            node = this.getParentNode().zzZJD();
        }
        return node;
    }

    final Node zzMn() {
        Node node = zzuY.zzX8V(this.getNextSibling(), false);
        if (node == null && zzuY.zzCw(this.getParentNode())) {
            node = this.getParentNode().zzMn();
        }
        return node;
    }

    final CompositeNode zzXEU() {
        Node node = this;
        while ((node = node.zzZJD()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZ6m() {
        Node node = this;
        while ((node = node.zzMn()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzW94;
    }

    final Node zzZ2j() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzuY.zzYq2((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzXt() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzX9c() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZZa() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzuY.zzXPb(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZ2C() {
        return this.zzW94;
    }

    final void zzZF2(Node node) {
        this.zzW94 = node;
    }

    final Node zzW0() {
        return this.zzVZy;
    }

    final void zzZjn(Node node) {
        this.zzVZy = node;
    }

    final Node zzWjR() {
        Node node = this;
        if (node.zzW94 != null) {
            node = this;
            return node.zzW94;
        }
        return this.getParentNode();
    }

    final int zzNc() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzuY.zzZMz(this);
        boolean bl2 = zzuY.zzTG(this);
        boolean bl3 = zzuY.zzWx9(this);
        boolean bl4 = zzuY.zzXKM(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzNc() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzNc() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzYON(isCloneChildren, new zzYON(this));
    }

    Node zzYON(boolean bl, zzVY4 zzVY42) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYc1 != null) {
            node.zzYc1 = this.getDocument().zzWMp();
        }
        node.zzW94 = null;
        node.zzVZy = null;
        if (zzVY42 != null) {
            zzVY42.zzX4P(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzEv(StringBuilder stringBuilder) {
        zzYWV.zzVVX(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzlT(Node node) {
        this.zzYc1 = node != null ? node : this.getDocument().zzWMp();
    }

    final void zzYhC(DocumentBase documentBase) {
        this.zzYc1 = documentBase != null ? documentBase.zzWMp() : null;
    }

    final boolean zzYmY(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzXzl() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzWEH(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZlV(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzXN3(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzEv(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzYbI(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final <T extends Node> T zzXRl(T t) {
        return this.getParentNode().insertAfter(t, this);
    }

    final <T extends Node> T zzSX(T t) {
        return this.getParentNode().insertBefore(t, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzc5 zzc52 = zzuY.zzWuh(saveFormat);
        return zzc52.zzZ9y(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzc5 zzc52 = zzuY.zzVVX(saveOptions);
        return zzc52.zzZ9y(this);
    }

    final Node zzWG2(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzuY.zzWcg(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzYoZ zzYVX() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzYoZ.zzWOg(node);
        }
        return zzYoZ.zzWas(this.getParentNode());
    }

    final zzYoZ zzy7() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzYoZ.zzWas(node);
        }
        return zzYoZ.zzWOg(this.getParentNode());
    }

    final boolean zzYVv(Node node) {
        return Node.zzYpn(this, node);
    }

    final boolean zzYgE() {
        return this.getAncestor(1) == null;
    }

    static Node zzjo(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzZY2<Node> zzZY22 = Node.zzZlb(node);
        zzZY2<Node> zzZY23 = Node.zzZlb(node2);
        return Node.zzYON(zzZY22, zzZY23);
    }

    static boolean zzYpn(Node node, Node node2) {
        zzZY2<Node> zzZY22;
        if (node == null || node2 == null) {
            return false;
        }
        zzZY2<Node> zzZY23 = Node.zzZlb(node);
        Node node3 = Node.zzYON(zzZY23, zzZY22 = Node.zzZlb(node2));
        if (node3 == null) {
            return false;
        }
        zzZY2<Node> zzZY24 = zzZY23;
        if (zzZY24.size() == 0 || (zzZY24 = zzZY22).size() == 0) {
            zzZY24 = zzZY22;
            boolean bl = zzZY24.size() > 0;
            return bl;
        }
        Object e = zzZY23.peek();
        Object e2 = zzZY22.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzZY2<Node> zzZlb(Node node) {
        zzZY2<Node> zzZY22 = new zzZY2<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzZY22.push(node2);
        }
        return zzZY22;
    }

    private static Node zzYON(zzZY2<Node> zzZY22, zzZY2<Node> zzZY23) {
        Node node = null;
        while (zzZY22.peek() == zzZY23.peek()) {
            node = (Node)zzZY22.pop();
            zzZY23.pop();
            zzZY2<Node> zzZY24 = zzZY22;
            if (zzZY24.size() != 0 && (zzZY24 = zzZY23).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzWQO;
    }

    public void setCustomNodeId(int value) {
        this.zzWQO = value;
    }

    private String zzYNK() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzYWV.zzYON(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzYO7.zzWzA(stringBuilder.toString());
    }

    public String toString() {
        return zzYO7.zzWzA(zzYO7.zzVVX("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzYNK()));
    }

    public void dd() {
    }

    final Node zzWx9(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzXcE(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZMz(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzXcE(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzXcE(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzYON
    implements zzVY4 {
        private Node zz55;
        private HashMap<Integer, Integer> zzWL2;

        zzYON(Node node) {
            this.zz55 = node;
        }

        @Override
        public final void zzX4P(Node node, Node node2) {
            if (node == this.zz55) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zz7w zz7w2 = (zz7w)((Object)node2);
            if (this.zzWL2 == null) {
                this.zzWL2 = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzYWV.zzYON(this.zzWL2, Integer.valueOf(zz7w2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzYO2();
                zzYWV.zzVVX(this.zzWL2, Integer.valueOf(zz7w2.getIdInternal()), Integer.valueOf(n));
            }
            zz7w2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzYWV.zzYON(this.zzWL2, Integer.valueOf(zz7w2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zz7w2.setParentIdInternal(n2);
            }
        }
    }
}

