/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZAs;
import com.aspose.words.zzWLr;
import com.aspose.words.zzWn1;
import com.aspose.words.zzXfs;
import com.aspose.words.zzXrs;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzWn1,
Iterable<T> {
    private Node zzW0G;
    private CompositeNode zzZsA;
    private DocumentBase zzZsx;
    private boolean zzYCp;
    private int zzXRE;
    private int zzXEF;
    private Node zzWbE;
    private int zzVYq;
    private zzWLr zzZKg;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzXrs.zzWgT(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzXrs(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzWLr matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: container");
        }
        if (matcher == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: matcher");
        }
        this.zzZsA = container;
        this.zzZsx = container.getDocument();
        this.zzZKg = matcher;
        this.zzYCp = isDeep;
        this.zzW9Z();
    }

    public Node get(int index) {
        try {
            this.zzZNh();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzXEF == index) {
                return this.zzWbE;
            }
            int n = index - this.zzXEF;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzWXY(nodeCollection.zzWbE, n);
            if (node != null) {
                this.zzXEF = index;
                this.zzWbE = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzYCp) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZsA.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzYCp) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZsA.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzUD();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXfs(this);
    }

    final <TNode extends Node> zzXfs<TNode> zzXBP() {
        return new zzXfs(this);
    }

    final ArrayList<Node> zzWI5() {
        return this.zzUD();
    }

    final <TValue extends Node> ArrayList<TValue> zzUD() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZAs.zzYON(arrayList, node);
        }
        return arrayList;
    }

    private Node zzWXY(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzeE(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzW51(curNode, true);
    }

    private Node zzW51(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzW0G = node;
        do {
            node2 = this.zzW0G;
            Node node3 = this.zzYCp ? this.zzYON(true, this.zzW0G) : (this.zzW0G = this.zzZKg.zzTh() ? this.zzYhC(true, this.zzW0G) : this.zzVVX(true, this.zzW0G));
        } while (this.zzW0G != null && !this.zzZKg.zzZ1d(this.zzW0G));
        return node2;
    }

    private Node zzeE(Node node, boolean bl) throws Exception {
        while ((this.zzYCp ? this.zzYON(bl, node) : (node = this.zzZKg.zzTh() ? this.zzYhC(bl, node) : this.zzVVX(bl, node))) != null && !this.zzZKg.zzZ1d(node)) {
        }
        return node;
    }

    private Node zzYON(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzZsA);
        }
        return node.previousPreOrder(this.zzZsA);
    }

    private Node zzVVX(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzZsA) {
                return this.zzZsA.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzZsA) {
            return this.zzZsA.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzYhC(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzZsA ? this.zzZsA.zzWaS() : node.zzMn();
        } else {
            Node node3 = node2 = node == this.zzZsA ? this.zzZsA.zzVP6() : node.zzZJD();
        }
        if (node2 == this.zzZsA.getNextSibling() || node2 == this.zzZsA.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzZNh() {
        if (this.zzXRE != this.zz4()) {
            this.zzW9Z();
        }
    }

    private void zzW9Z() {
        this.zzXRE = this.zz4();
        this.zzXEF = -1;
        this.zzWbE = this.zzZsA;
        this.zzVYq = -1;
    }

    private int zz4() {
        if (this.zzZsx != null) {
            return this.zzZsx.zz1n();
        }
        return 0;
    }

    public int getCount() {
        this.zzZNh();
        if (this.zzVYq == -1) {
            this.zzVYq = zzXfs.zzYON(this);
        }
        return this.zzVYq;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzW0G;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzZsA;
    }
}

