/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzX10;
import com.aspose.words.internal.zzXG8;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzXhl;
    private boolean zzWTx;
    boolean zzVWW = true;
    private boolean zzYAe = true;
    private boolean zzYPt = false;
    private boolean zzYgo;
    private boolean zzJC = true;
    private boolean zzWOI;
    private String zzZA9;
    private boolean zzZLo;
    private boolean zzZMd = false;
    private int zzF1 = 1;
    private int zzXr7 = 1;
    private int zzYuJ = 0;
    private String zzWv6 = "";
    private boolean zzYwW = true;
    private boolean zzXYJ = true;
    private boolean zzYvG;
    private boolean zzZug;
    private int zzYGl = 0;
    private boolean zzQQ = true;
    private boolean zzX6d = false;

    protected SaveOptions() {
    }

    final boolean zzXLL() {
        return this.zzYgo;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzX9k() {
        return false;
    }

    boolean zzW2i() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzJC;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzJC = value;
    }

    public String getTempFolder() {
        return this.zzZA9;
    }

    public void setTempFolder(String value) {
        this.zzZA9 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWOI;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWOI = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzZLo;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzZLo = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzZMd;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzZMd = value;
    }

    public int getDmlRenderingMode() {
        return this.zzF1;
    }

    public void setDmlRenderingMode(int value) {
        this.zzF1 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYuJ;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYuJ = value;
    }

    public int getImlRenderingMode() {
        return this.zzXr7;
    }

    public void setImlRenderingMode(int value) {
        this.zzXr7 = value;
    }

    public String getDefaultTemplate() {
        return this.zzWv6;
    }

    public void setDefaultTemplate(String value) {
        this.zzWv6 = value;
    }

    public boolean getUpdateFields() {
        return this.zzYwW;
    }

    public void setUpdateFields(boolean value) {
        this.zzYwW = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzYvG;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzYvG = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZug;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZug = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzX6d;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzX6d = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYPt;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYPt = value;
    }

    final boolean zzgV() {
        return this.zzXYJ;
    }

    final boolean zzWMt() {
        return this.zzQQ;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzWJO(zzXG8.zzW6H(zzX10.zzZGx(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzYGl;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzYGl = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzXhl;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzXhl = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzWTx;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzWTx = value;
    }

    final boolean zzYWY() {
        return this.zzYAe;
    }

    final void zzX13(boolean bl) {
        this.zzYAe = false;
    }
}

