/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzYO7;
import com.aspose.words.internal.zzYWV;
import com.aspose.words.zzVY4;
import com.aspose.words.zzYPJ;
import com.aspose.words.zzZSk;

public final class Section
extends CompositeNode<Node>
implements zzYPJ {
    private zzZSk zzWOb;
    private PageSetup zzWDC;
    private HeaderFooterCollection zzXFG;

    public Section(DocumentBase doc) {
        this(doc, new zzZSk());
    }

    Section(DocumentBase doc, zzZSk sectPr) {
        super(doc);
        this.zzWOb = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzXFG == null) {
            this.zzXFG = new HeaderFooterCollection(this);
        }
        return this.zzXFG;
    }

    public final PageSetup getPageSetup() {
        if (this.zzWDC == null) {
            Section section = this;
            this.zzWDC = new PageSetup(section, section.getDocument().zzYws(), this.getDocument().getStyles(), new zzYON(this));
        }
        return this.zzWDC;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzXn();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzZ63(!value);
    }

    final zzZSk zzVUH() {
        return this.zzWOb;
    }

    final void zzVVX(zzZSk zzZSk2) {
        this.zzWOb = zzZSk2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzYON(boolean bl, zzVY4 zzVY42) {
        zzZSk zzZSk2;
        Section section = (Section)super.zzYON(bl, zzVY42);
        zzZSk zzZSk3 = this.zzWOb;
        section.zzWOb = zzZSk2 = (zzZSk)zzZSk3.zzXC3();
        section.zzWDC = null;
        section.zzXFG = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzX4P(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzX4P(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzXnJ(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzWqY(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzXnJ(n) == null;
            }
        }
        return false;
    }

    final void zzYhC(Shape shape, boolean bl) throws Exception {
        this.zzYON(shape, 4, bl);
        this.zzYON(shape, 0, bl);
        this.zzYON(shape, 1, bl);
    }

    private void zzYON(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzu());
        shape2.setName(zzYO7.zzVVX("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzY6v() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZ51()) {
                if (!shape.zzXNY()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzX4P(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzVVX(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzWOb.zzXCF(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzYws().zzXY9.zzWhQ(key);
        }
        return zzZSk.zzYjA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzWOb.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzYws().zzXY9.zzkw(key, value);
            return;
        }
        this.zzWOb.zzkw(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzWOb.clear();
    }

    final boolean zzW4K() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzYzF() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzWOb.getSectionStart());
        return zzYO7.zzVVX("{0} {1}", objectArray);
    }

    static final class zzYON
    implements zzYPJ {
        private Section zzZ8v;

        zzYON(Section section) {
            this.zzZ8v = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzXqC().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzXqC().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzXqC().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzYPJ zzXqC() {
            Document document = zzYWV.zzYON((Object)this.zzZ8v.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzZ8v;
        }
    }
}

