/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzXQq;
import com.aspose.words.internal.zzY4o;
import com.aspose.words.internal.zzYCe;
import com.aspose.words.internal.zzYO7;
import com.aspose.words.internal.zzYWV;
import com.aspose.words.internal.zzZW7;
import com.aspose.words.zzYoX;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzWTk;
    private zzYoX zzzc;

    Watermark(Document doc, zzYoX watermarkProvider) {
        this.zzWTk = doc;
        this.zzzc = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzY0S(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzYON(text, textWatermarkOptions, this.zzWTk);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzYWV.zzVVX((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzWTk, 75);
        shape.getImageData().setImage(image);
        this.zzYON(shape, options, this.zzWTk);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzYWV.zzVVX((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzWTk, 75);
        shape.getImageData().setImage(imagePath);
        this.zzYON(shape, options, this.zzWTk);
    }

    public final int getType() {
        Shape shape = this.zzzc.get();
        if (shape == null) {
            return 2;
        }
        shape.zzXNY();
        if (shape.zzZlI()) {
            return 0;
        }
        if (shape.zzG6()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzzc.add(shape);
    }

    public final void remove() {
        this.zzzc.remove();
    }

    private static void zzY0S(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzYCe.zzXUc(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzYWV.zzYON(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzYON(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzVVX(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzXMu(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzVVX(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzaj() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzWGN()) / d2) > (double)(f = pageSetup.zz5O())) {
            d = (double)f / d3;
        }
        shape.zzZZj(zzXQq.zzYhC(d2 * d, 2, 1));
        shape.zzZy7(zzXQq.zzYhC(d3 * d, 2, 1));
    }

    private Shape zzYON(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzYON(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzXMu(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzYON(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzJ3() ? 1.0f : textWatermarkOptions.getFontSize();
        zzZW7 zzZW72 = document.zzZeh().zzYhC(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzZW72.zzXcE(shape.getTextPath().getText());
        if (textWatermarkOptions.zzJ3()) {
            l = Watermark.zzYON(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZZj(zzXQq.zzYhC(Float.intBitsToFloat(n), 2, 1));
        shape.zzZy7(zzXQq.zzYhC(zzY4o.zzZTo(l), 2, 1));
    }

    private static long zzYON(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzWGN();
        float f2 = pageSetup.zz5O();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzY4o.zzZTo(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzY4o.zzSs(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzY4o.zzZTo(l) >= Float.intBitsToFloat(n)) {
            return zzY4o.zzSs(f2 / f3, f2);
        }
        float f6 = f;
        return zzY4o.zzSs(f6, f6 * f3);
    }

    private static void zzXMu(Shape shape, String string) {
        shape.setName(zzYO7.zzVVX("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

