/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzI;
import com.aspose.words.internal.zzWFA;
import com.aspose.words.internal.zzWY7;
import com.aspose.words.internal.zzWYS;
import com.aspose.words.internal.zzWsl;
import com.aspose.words.internal.zzWv4;
import com.aspose.words.internal.zzYaU;
import com.aspose.words.internal.zzYlq;
import com.aspose.words.internal.zzZqE;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzY8I
extends CertPathBuilderSpi {
    private final zzWsl zzW5p;
    private zzYaU zzVSo;

    zzY8I(zzWsl zzWsl2) {
        this.zzW5p = zzWsl2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzWY7 pkixParams;
        if (params instanceof zzWY7) {
            pkixParams = (zzWY7)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzWY7.zzYON((PKIXBuilderParameters)params).zzXIr();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzWY7.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZqE zzZqE2 = pkixParams.zzXQi().zzXFs();
        try {
            collection = zzWv4.zzYON(zzZqE2, pkixParams.zzXQi().zzYIn());
            collection.addAll(zzWv4.zzYON(zzZqE2, pkixParams.zzXQi().zzBB()));
        }
        catch (zzYaU zzYaU2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzYaU2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzYON(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzVSo != null) {
            throw new CertPathBuilderException(this.zzVSo.getMessage(), this.zzVSo.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzYON(X509Certificate x509Certificate, zzWY7 zzWY72, List list) throws CertPathBuilderException {
        zzWFA zzWFA2;
        zzYlq zzYlq2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzWY72.zzYa8().contains(x509Certificate)) {
            return null;
        }
        if (zzWY72.zzX07() != -1 && list.size() - 1 > zzWY72.zzX07()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzYlq2 = new zzYlq(this.zzW5p);
            zzWFA2 = new zzWFA(this.zzW5p);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzWv4.zzYON(x509Certificate, zzWY72.zzXQi().zzYOC(), zzWY72.zzXQi().zzXRM()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzYlq2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzYaU("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzWFA2.engineValidate(certPath, zzWY72);
                }
                catch (Exception exception) {
                    throw new zzYaU("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzWYS> arrayList = new ArrayList<zzWYS>();
            arrayList.addAll(zzWY72.zzXQi().zzYIn());
            try {
                arrayList.addAll(zzWv4.zzYON(x509Certificate.getExtensionValue(zzI.zzY3V.getId()), zzWY72.zzXQi().zzWZ()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzYaU("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzWv4.zzYON(x509Certificate, zzWY72.zzXQi().zzBB(), arrayList));
            }
            catch (zzYaU zzYaU2) {
                throw new zzYaU("Cannot find issuer certificate for certificate in certification path.", zzYaU2);
            }
            if (hashSet.isEmpty()) {
                throw new zzYaU("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzYON(x509Certificate2, zzWY72, list);
            }
        }
        catch (zzYaU zzYaU3) {
            this.zzVSo = zzYaU3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

