/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYO7;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzq6 = new ArrayList();
    private final Map<String, DataColumn> zz7r = new HashMap<String, DataColumn>();
    private DataTable zzeK;

    DataColumnCollection(DataTable table) {
        this.zzeK = table;
    }

    public void add(DataColumn column) {
        if (zzYO7.zzZZ6(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzYAz(column.getColumnName());
        if (this.zz7r.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzX4P(this.zzeK);
        column.setOrdinal(this.zzq6.size());
        this.zzq6.add(column);
        this.zz7r.put(string, column);
        this.zzeK.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzeK);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzeK);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzYO7.zzZZ6(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzYAz(columnName);
        DataColumn dataColumn = this.zz7r.get(string);
        if (dataColumn != null) {
            int n = this.zzq6.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzq6.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzq6.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzq6.remove(n);
            this.zz7r.remove(DataColumnCollection.zzYAz(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzeK.getRows()) {
                dataRow.remove(n);
            }
            this.zzeK.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzq6.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzq6.iterator();
    }

    public void clear() {
        this.zz7r.clear();
        this.zzq6.clear();
    }

    final DataColumn[] zzWti() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzq6);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzYON(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzq6.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzq6.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzYAz(string);
            String string3 = DataColumnCollection.zzYAz(dataColumn.getColumnName());
            this.zz7r.remove(string3);
            this.zz7r.put(string2, dataColumn);
            return;
        }
    }

    private static String zzYAz(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

