/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXk0;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzVVX;
import com.aspose.words.net.System.Data.zzWqY;
import com.aspose.words.net.System.Data.zzX8L;
import com.aspose.words.net.System.Data.zzYhC;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzYFh;
    private final DataColumnCollection zzZOZ;
    private final ConstraintCollection zzYEI;
    private final zzX8L zzYmi;
    private ResultSet zzY2B;
    private String zzMu;
    private DataSet zzXOc;
    private String zzZXx;
    private UniqueConstraint zzYVm;
    private boolean zzY6M;
    private final List<DataTableEventListener> zzYMf;
    private final Set<DataRow> zzWBE;
    private DataRelationCollection zzXin;

    public DataTable() {
        this.zzYFh = new DataRowCollection(this);
        this.zzZOZ = new DataColumnCollection(this);
        this.zzYEI = new ConstraintCollection(this);
        this.zzYmi = new zzX8L(this);
        this.zzZXx = "";
        this.zzY6M = true;
        this.zzYMf = new ArrayList<DataTableEventListener>();
        this.zzWBE = new HashSet<DataRow>();
        this.zzXin = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzYFh = new DataRowCollection(this);
        this.zzZOZ = new DataColumnCollection(this);
        this.zzYEI = new ConstraintCollection(this);
        this.zzYmi = new zzX8L(this);
        this.zzZXx = "";
        this.zzY6M = true;
        this.zzYMf = new ArrayList<DataTableEventListener>();
        this.zzWBE = new HashSet<DataRow>();
        this.zzXin = new DataRelationCollection();
        this.zzMu = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzVVX.zzYON(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzYFh = new DataRowCollection(this);
        this.zzZOZ = new DataColumnCollection(this);
        this.zzYEI = new ConstraintCollection(this);
        this.zzYmi = new zzX8L(this);
        this.zzZXx = "";
        this.zzY6M = true;
        this.zzYMf = new ArrayList<DataTableEventListener>();
        this.zzWBE = new HashSet<DataRow>();
        this.zzXin = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzY2B = resultSet;
        this.zzMu = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzY2B != null) {
            if (this.zzY2B.getStatement() != null) {
                this.zzY2B.getStatement().getConnection().close();
            }
            this.zzY2B = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzMu;
    }

    public void setTableName(String tableName) {
        this.zzMu = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzZOZ.getCount();
    }

    public String getColumnName(int index) {
        return this.zzZOZ.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzY2B;
    }

    public DataSet getDataSet() {
        return this.zzXOc;
    }

    final void zzX4P(DataSet dataSet) {
        this.zzXOc = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzXOc.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzXin.add(dataRelation);
        }
        return this.zzXin;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzXOc.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzYFh;
    }

    public DataColumnCollection getColumns() {
        return this.zzZOZ;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzYEI;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYVm == null) {
            return new DataColumn[0];
        }
        return this.zzYVm.getColumns();
    }

    final void zzX8L(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYVm != null) {
                this.zzYVm.zzqN(false);
                this.getConstraints().remove(this.zzYVm);
                this.zzYVm = null;
            }
            return;
        }
        if (this.zzYVm != null && DataColumn.areColumnSetsTheSame(value, this.zzYVm.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzYON(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYVm != null) {
            this.zzYVm.zzqN(false);
            this.getConstraints().remove(this.zzYVm);
            this.zzYVm = null;
        }
        UniqueConstraint.zzYON(this.getConstraints(), uniqueConstraint);
        this.zzYVm = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZXx;
    }

    public void setNamespace(String namespace) {
        this.zzZXx = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzY6M;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzY6M = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzWBE.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzVVX.zzYON(this.getResultSet(), this);
            zzVVX.zzVVX(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXk0.zzX4P(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzVVX.zzXMu(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzYMf.contains(listener)) {
            this.zzYMf.add(listener);
        }
    }

    public void removeEventListener(zzYhC listener) {
        if (this.zzYMf.contains(listener)) {
            this.zzYMf.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzYMf.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzWBE.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYMf) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzWBE.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYMf) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzWBE.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYMf) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYMf) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYMf) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzWqY zzYON(zzVVX[] zzVVXArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzVVXArray.length];
        for (int i = 0; i < zzVVXArray.length; ++i) {
            dataColumnArray[i] = zzVVXArray[i].zzX5();
        }
        DataTable dataTable = this;
        zzWqY zzWqY2 = dataTable.zzYmi.zzX4P(dataColumnArray);
        if (zzWqY2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzWqY2;
    }

    final zzX8L zz20() {
        return this.zzYmi;
    }

    final Set<DataRow> zzZNH() {
        return this.zzWBE;
    }
}

